/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.AbstractPropertyHelper;
import ch.abacus.designcockpit.ide.IDEObjectColorChooser;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class DefaultPropertyHelper
extends AbstractPropertyHelper {
    String sPropertyName;
    MetaObject theObject;
    SuperDesignCockpit theDesignCockpit;

    public boolean execute(MetaObject metaObject, String sPropertyName, SuperDesignCockpit superDesignCockpit) {
        this.theObject = metaObject;
        this.theDesignCockpit = superDesignCockpit;
        this.sPropertyName = sPropertyName;
        if (this.theDesignCockpit.getSelectedObject() == null) {
            return false;
        }
        if (sPropertyName.equalsIgnoreCase("font")) {
            return this.doFontHelper(sPropertyName);
        }
        if (sPropertyName.equalsIgnoreCase("Foreground")) {
            return this.doForeground();
        }
        if (sPropertyName.equalsIgnoreCase("Background")) {
            return this.doBackground();
        }
        if (sPropertyName.equalsIgnoreCase("Icon")) {
            return this.doIcon(sPropertyName);
        }
        return false;
    }

    private boolean doIcon(String sPropertyName) {
        String defaultImagesDirectory = "/ch/abacus/lib/ui/renderer/deploy/images";
        try {
            String cname = this.getClass().getName().replace('.', '/');
            URL uthis = this.getClass().getResource("/" + cname + ".class");
            URL uImageDir = null;
            String[] files = null;
            if (uthis.toString().startsWith("file:/")) {
                uthis = this.getClass().getClassLoader().getResource(".");
                uImageDir = new URL(uthis, defaultImagesDirectory);
                files = new File(uthis.getFile() + defaultImagesDirectory + "/").list();
                for (int fi = 0; fi < files.length; ++fi) {
                    String afile = files[fi];
                    files[fi] = defaultImagesDirectory + "/" + afile;
                }
            } else if (uthis.toString().startsWith("jar:")) {
                uImageDir = this.getClass().getResource(defaultImagesDirectory + "/");
                JarURLConnection uconn = (JarURLConnection)uImageDir.openConnection();
                Enumeration<JarEntry> entries = uconn.getJarFile().entries();
                ArrayList<String> filelist = new ArrayList<String>();
                while (entries.hasMoreElements()) {
                    String afile = ((Object)entries.nextElement()).toString();
                    if (!afile.endsWith(".gif") && !afile.endsWith(".jpg") && !afile.endsWith(".png")) continue;
                    filelist.add(afile);
                }
                files = new String[filelist.size()];
                System.arraycopy(filelist.toArray(), 0, files, 0, files.length);
            }
            String selectedFileName = null;
            try {
                selectedFileName = (String)JOptionPane.showInputDialog((Component)((Object)this.theDesignCockpit), null, "Choose Icon", -1, null, files, (String)files[0]);
            }
            catch (Exception i) {
                // empty catch block
            }
            if (selectedFileName == null || selectedFileName.length() == 0) {
                return false;
            }
            this.theObject.setPropertyValue(sPropertyName, 0, 0, (Object)selectedFileName, true);
            URL uImage = new URL(uImageDir, selectedFileName);
            ImageIcon icon = new ImageIcon(uImage);
            if (this.theObject.theVisualObject instanceof AbstractButton) {
                ((AbstractButton)this.theObject.theVisualObject).setIcon(icon);
            }
            this.theObject.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this.theDesignCockpit), e, "Icon Helper Error", 0);
            return false;
        }
        return true;
    }

    private boolean doBackground() {
        try {
            IDEObjectColorChooser chooser = new IDEObjectColorChooser(this.theDesignCockpit, false);
            this.theObject.refresh();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this.theDesignCockpit), e, "Error", 0);
            return false;
        }
        return true;
    }

    private boolean doForeground() {
        try {
            IDEObjectColorChooser chooser = new IDEObjectColorChooser(this.theDesignCockpit, true);
            this.theObject.refresh();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this.theDesignCockpit), e, "Error", 0);
            return false;
        }
        return true;
    }

    private boolean doFontHelper(String sPropertyName) {
        String sFontChooserClass = this.theDesignCockpit.getConfigurationManager().getConfigurationVariable("FONT_CHOOSER", this.theDesignCockpit.thePreferences.sFontChooserName);
        try {
            Class cls = this.theDesignCockpit.getClassLoader().getLoader().loadClass(sFontChooserClass);
            if (cls != null) {
                Object[] parameters = new Object[]{this.theDesignCockpit};
                Class[] parameterTypes = new Class[]{SuperDesignCockpit.class};
                Constructor constructor = cls.getConstructor(parameterTypes);
                Object newValue = constructor.newInstance(parameters);
                this.theObject.setPropertyValue(sPropertyName, 0, 0, (Object)this.theDesignCockpit.getSelectedObject().getFont(), true);
                this.theObject.refresh();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this.theDesignCockpit), e + ": " + sFontChooserClass, "Error", 0);
            return false;
        }
        return true;
    }
}

