/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignAnchoringComponent;
import ch.abacus.designcockpit.ide.Sizebox;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.layout.Anchoring;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public class DesignAnchoringLayoutManager
implements LayoutManager {
    DesignAnchoringComponent firstAnchoringComponent = null;
    DesignAnchoringComponent lastAnchoringComponent = null;
    private static final int PREFERRED = 0;
    private static final int MINIMUM = 1;
    public int width = -1;
    public int height = -1;
    SuperDesignCockpit theDesignCockpit = null;
    MetaObject theContainer = null;
    public boolean bAnchoringEnabled = true;

    public DesignAnchoringLayoutManager(MetaObject theContainer, SuperDesignCockpit theDesignCockpit) {
        this.theDesignCockpit = theDesignCockpit;
        this.theContainer = theContainer;
    }

    protected DesignAnchoringComponent findAnchoringComponent(Component comp) {
        DesignAnchoringComponent theAnchoringComponent = this.firstAnchoringComponent;
        while (theAnchoringComponent != null && !theAnchoringComponent.component.equals(comp)) {
            theAnchoringComponent = theAnchoringComponent.nextAnchoringComponent;
        }
        return theAnchoringComponent;
    }

    protected DesignAnchoringComponent findAnchoringComponent(MetaObject someObject) {
        DesignAnchoringComponent theAnchoringComponent = this.firstAnchoringComponent;
        while (theAnchoringComponent != null && !theAnchoringComponent.theObject.equals(someObject)) {
            theAnchoringComponent = theAnchoringComponent.nextAnchoringComponent;
        }
        return theAnchoringComponent;
    }

    protected DesignAnchoringComponent debugAnchoringComponent(Component comp) {
        System.err.println("Debugging anchoring layout manager for object " + this.theContainer.getName());
        DesignAnchoringComponent theAnchoringComponent = this.firstAnchoringComponent;
        if (this.firstAnchoringComponent != null) {
            System.err.println("The first anchoring component is " + this.firstAnchoringComponent.name);
            while (theAnchoringComponent != null) {
                System.err.println("Testing search component " + comp + " against " + theAnchoringComponent.component);
                if (theAnchoringComponent.component.equals(comp)) break;
                theAnchoringComponent = theAnchoringComponent.nextAnchoringComponent;
            }
        }
        System.err.println("Returning anchoring component " + theAnchoringComponent);
        return theAnchoringComponent;
    }

    String getName(Component comp) {
        DesignAnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            return theComponent.name;
        }
        return null;
    }

    public void addLayoutComponent(String name, Component comp) {
        DesignAnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            return;
        }
        DesignAnchoringComponent theNewComponent = new DesignAnchoringComponent();
        theNewComponent.name = name;
        theNewComponent.component = comp;
        if (this.firstAnchoringComponent == null) {
            this.firstAnchoringComponent = theNewComponent;
        } else {
            this.lastAnchoringComponent.nextAnchoringComponent = theNewComponent;
        }
        theNewComponent.prevAnchoringComponent = this.lastAnchoringComponent;
        this.lastAnchoringComponent = theNewComponent;
    }

    public void setAnchoring(Component comp, MetaObject theObject, boolean left, boolean right, boolean top, boolean bottom) {
        DesignAnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            Anchoring theAnchoring;
            theComponent.anchoring = theAnchoring = new Anchoring(left, right, top, bottom);
            theComponent.theObject = theObject;
        }
    }

    public void setAnchoring(Component comp, MetaObject theObject, int iAnchoring) {
        DesignAnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            Anchoring theAnchoring;
            theComponent.anchoring = theAnchoring = new Anchoring(iAnchoring);
            theComponent.theObject = theObject;
        }
    }

    public void removeLayoutComponent(Component comp) {
        DesignAnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            if (theComponent.equals(this.firstAnchoringComponent)) {
                this.firstAnchoringComponent = theComponent.nextAnchoringComponent;
                if (this.firstAnchoringComponent != null) {
                    this.firstAnchoringComponent.prevAnchoringComponent = null;
                }
            }
            if (theComponent.equals(this.lastAnchoringComponent)) {
                this.lastAnchoringComponent = theComponent.prevAnchoringComponent;
                if (this.lastAnchoringComponent != null) {
                    this.lastAnchoringComponent.nextAnchoringComponent = null;
                }
            }
            if (theComponent.prevAnchoringComponent != null) {
                theComponent.prevAnchoringComponent.nextAnchoringComponent = theComponent.nextAnchoringComponent;
            }
            if (theComponent.nextAnchoringComponent != null) {
                theComponent.nextAnchoringComponent.prevAnchoringComponent = theComponent.prevAnchoringComponent;
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, 1);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, 0);
    }

    public void layoutContainer(Container parent) {
        if (!this.bAnchoringEnabled) {
            return;
        }
        Component[] comps = parent.getComponents();
        Dimension dimParent = parent.getSize();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            Dimension dimComponent = comp.getSize();
            Point ptLocation = comp.getLocation();
            int x = (int)ptLocation.getX();
            int y = (int)ptLocation.getY();
            int cx = (int)dimComponent.getWidth();
            int cy = (int)dimComponent.getHeight();
            DesignAnchoringComponent theAnchoring = this.findAnchoringComponent(comp);
            if (theAnchoring == null) {
                this.debugAnchoringComponent(comp);
                System.err.println("Cannot find anchoring component for component:  " + comp.toString());
                return;
            }
            if (theAnchoring.anchoring != null) {
                if (theAnchoring.theObject.bAnchoringOff) {
                    theAnchoring.anchoring.anchorInitialized = false;
                    theAnchoring.theObject.bAnchoringOff = false;
                }
                if (theAnchoring.anchoring.anchorInitialized) {
                    if ((theAnchoring.anchoring.anchoring & 4) == 4) {
                        x = theAnchoring.anchoring.anchorLeft;
                        if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                            cx = (int)dimParent.getWidth() - (x + theAnchoring.anchoring.anchorRight);
                        }
                    } else if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                        x = (int)dimParent.getWidth() - (cx + theAnchoring.anchoring.anchorRight);
                    }
                    if ((theAnchoring.anchoring.anchoring & 1) == 1) {
                        y = theAnchoring.anchoring.anchorTop;
                        if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                            cy = (int)dimParent.getHeight() - (y + theAnchoring.anchoring.anchorBottom);
                        }
                    } else if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                        y = (int)dimParent.getHeight() - (cy + theAnchoring.anchoring.anchorBottom);
                    }
                } else {
                    if ((theAnchoring.anchoring.anchoring & 4) == 4) {
                        theAnchoring.anchoring.anchorLeft = x;
                    }
                    if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                        theAnchoring.anchoring.anchorRight = (int)dimParent.getWidth() - (x + (int)dimComponent.getWidth());
                    }
                    if ((theAnchoring.anchoring.anchoring & 1) == 1) {
                        theAnchoring.anchoring.anchorTop = y;
                    }
                    if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                        theAnchoring.anchoring.anchorBottom = (int)dimParent.getHeight() - (y + (int)dimComponent.getHeight());
                    }
                    theAnchoring.anchoring.anchorInitialized = true;
                }
            }
            if (!(comp instanceof Sizebox)) {
                comp.setBounds(x, y, cx, cy);
            }
            if (comp instanceof Sizebox) continue;
            this.theDesignCockpit.setBounds(theAnchoring.theObject, x, y, cx, cy);
        }
    }

    protected Dimension layoutSize(Container parent, int iType) {
        int newWidth;
        int newHeight;
        if (this.width == -1 || this.height == -1) {
            newHeight = 0;
            newWidth = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                DesignAnchoringComponent theAnchoring = this.findAnchoringComponent(comp);
                Dimension dimComponent = iType == 0 ? comp.getPreferredSize() : comp.getMinimumSize();
                Dimension dimParent = parent.getSize();
                Point pt = comp.getLocation();
                int x = (int)dimComponent.getWidth();
                if (theAnchoring != null) {
                    if ((theAnchoring.anchoring.anchoring & 4) == 4) {
                        x += (int)pt.getX();
                    }
                    if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                        x += (int)(dimParent.getWidth() - pt.getX() - dimComponent.getWidth());
                    }
                }
                int y = (int)dimComponent.getHeight();
                if (theAnchoring != null) {
                    if ((theAnchoring.anchoring.anchoring & 1) == 1) {
                        y += (int)pt.getY();
                    }
                    if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                        y += (int)(dimParent.getHeight() - pt.getY() - dimComponent.getHeight());
                    }
                }
                newWidth = Math.max(newWidth, x);
                newHeight = Math.max(newHeight, y);
            }
            if (this.width != -1) {
                newWidth = this.width;
            }
            if (this.height != -1) {
                newHeight = this.height;
            }
        } else {
            newWidth = this.width;
            newHeight = this.height;
        }
        Insets insets = parent.getInsets();
        return new Dimension(newWidth + insets.left + insets.right, newHeight + insets.top + insets.bottom);
    }
}

