/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import javax.swing.JLayeredPane;

public class DesignPanel
extends JLayeredPane {
    public SuperDesignCockpit theDesignCockpit = null;
    public MetaObject theMetaObject = null;

    Color getAppropriateColor(Color theColor) {
        Color newColor = new Color((theColor.getRed() + 128) % 256, (theColor.getGreen() + 128) % 256, (theColor.getBlue() + 128) % 256);
        return newColor;
    }

    public DesignPanel() {
    }

    public DesignPanel(SuperDesignCockpit objDesignCockpit, MetaObject objMetaObject) {
        this.theDesignCockpit = objDesignCockpit;
        this.theMetaObject = objMetaObject;
    }

    public Point getLocationOnScreen() {
        if (this.theMetaObject.isTabPage()) {
            return this.theMetaObject.theParentObject.theVisualObject.getLocationOnScreen();
        }
        return super.getLocationOnScreen();
    }

    public void paintComponent(Graphics g) {
        float[] dash1 = new float[]{1.0f, (float)this.theDesignCockpit.thePreferences.iViewDisplayerGridX - 1.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, dash1, 0.0f);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension theSize = this.theMetaObject.getSize();
        Color theColor = this.theMetaObject.getBackgroundColor();
        if (theColor == null) {
            theColor = SystemColor.control;
        }
        g2.setColor(theColor);
        g2.fillRect(0, 0, (int)theSize.getWidth(), (int)theSize.getHeight());
        if (this.theDesignCockpit.thePreferences.bDisplayGrid) {
            Color thePenColor = this.getAppropriateColor(theColor);
            g2.setColor(thePenColor);
            int cx = (int)theSize.getWidth();
            int cy = (int)theSize.getHeight();
            g2.setStroke(dashed);
            for (int y = this.theDesignCockpit.thePreferences.iViewDisplayerGridY; y < cy; y += this.theDesignCockpit.thePreferences.iViewDisplayerGridY) {
                g2.drawLine(0, y, cx - 1, y);
            }
        }
        g2.setColor(SystemColor.controlShadow);
        g2.setStroke(new BasicStroke());
        g2.drawRect(0, 0, (int)theSize.getWidth() - 1, (int)theSize.getHeight() - 1);
    }
}

