/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEPropertyInspectorController;
import ch.abacus.designcockpit.ide.IDEUndoRedoController;
import ch.abacus.designcockpit.ide.SelectProjectAction;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerJarAccess;
import ch.abacus.lib.ui.renderer.common.HammerLanguagePresentation;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProjectHeader;
import electric.xml.Element;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class DesignProject {
    public SelectProjectAction theAssociatedAction;
    IDEUndoRedoController theUndoRedoController;
    MetaProject theMetaProject;
    MetaObject lastObjectSelected;
    MetaObject theSelectedFrame;
    ArrayList theSelectedObjects = new SelectedObjects(0);
    MetaObject theSelectedContainer;
    DesignProject theNextDesignProject;
    DesignProject thePreviousDesignProject;
    private String sProjectDirectory;

    public DesignProject(MetaProject theMetaProject) {
        this.theMetaProject = theMetaProject;
        this.initializeUndoRedo();
    }

    public void initializeUndoRedo() {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)this.theMetaProject.getMetaDataUser();
        this.theUndoRedoController = new IDEUndoRedoController(theDesignCockpit);
    }

    public IDEUndoRedoController getUndoRedoController() {
        return this.theUndoRedoController;
    }

    public int getInputType() {
        return this.theMetaProject.iInputType;
    }

    public void setInputType(int iInputType) {
        this.theMetaProject.iInputType = iInputType;
    }

    public MetaObject getFirstObject() {
        return this.theMetaProject.getFirstObject();
    }

    public MetaObject getLastObject() {
        return this.theMetaProject.getLastObject();
    }

    public void setFirstObject(MetaObject someObject) {
        this.theMetaProject.setFirstObject(someObject);
    }

    public void setLastObject(MetaObject someObject) {
        this.theMetaProject.setLastObject(someObject);
    }

    public MetaObject getLastObjectSelected() {
        return this.lastObjectSelected;
    }

    public MetaObject getSelectedFrame() {
        return this.theSelectedFrame;
    }

    public void setSelectedFrame(MetaObject theSelectedFrame) {
        this.theSelectedFrame = theSelectedFrame;
    }

    public void setLastObjectSelected(MetaObject theLastObjectSelected) {
        this.lastObjectSelected = theLastObjectSelected;
    }

    public MetaObject getSelectedContainer() {
        return this.theSelectedContainer;
    }

    public void setSelectedContainer(MetaObject theSelectedContainer) {
        this.theSelectedContainer = theSelectedContainer;
    }

    public int getSelectedObjectCount() {
        if (this.theSelectedObjects == null) {
            return 0;
        }
        return this.theSelectedObjects.size();
    }

    public MetaObject getSelectedObject(int iSelection) {
        if (this.theSelectedObjects == null) {
            return null;
        }
        if (iSelection >= this.theSelectedObjects.size()) {
            return null;
        }
        return (MetaObject)this.theSelectedObjects.get(iSelection);
    }

    public MetaObject getSelectedObject() {
        if (this.theSelectedObjects == null || this.theSelectedObjects.size() == 0) {
            return null;
        }
        return (MetaObject)this.theSelectedObjects.get(this.theSelectedObjects.size() - 1);
    }

    public void setSelectedObject(MetaObject theSelectedObject) {
        this.theSelectedObjects.add(theSelectedObject);
        if (theSelectedObject != null) {
            theSelectedObject.bringForward();
        }
    }

    public boolean isSelected(MetaObject theMetaObject) {
        return this.theSelectedObjects.contains(theMetaObject);
    }

    public void deselectObject(MetaObject theSelectedObject) {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)this.theMetaProject.getMetaDataUser();
        this.theSelectedObjects.remove(theSelectedObject);
        theDesignCockpit.theSizeboxes.kill(theSelectedObject);
    }

    public void deselectObjects() {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)this.theMetaProject.getMetaDataUser();
        this.theSelectedObjects.clear();
        if (theDesignCockpit.theSizeboxes != null) {
            theDesignCockpit.theSizeboxes.kill();
        }
    }

    public void dragSelected(MetaObject theMetaObject, Point ptViewDisplayerOrigin, Point ptObjectOrigin, Point ptInObject, int left, int top) {
        MetaObject testObject;
        int i;
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)this.theMetaProject.getMetaDataUser();
        boolean bFound = false;
        for (i = 0; i < this.theSelectedObjects.size(); ++i) {
            testObject = (MetaObject)this.theSelectedObjects.get(i);
            testObject.bAnchoringOff = true;
        }
        for (i = 0; i < this.theSelectedObjects.size(); ++i) {
            testObject = (MetaObject)this.theSelectedObjects.get(i);
            if (testObject.equals(theMetaObject)) {
                bFound = true;
            }
            if (testObject.isAbalet() || testObject.isFrame() || testObject.isJMenuSeparator() || testObject.isJToolBarButton() || testObject.isJMenuItem() || testObject.isJMenu()) continue;
            theDesignCockpit.doDragging(testObject, testObject.theVisualObject, ptViewDisplayerOrigin, ptObjectOrigin, ptInObject, left, top);
        }
        if (!bFound) {
            theDesignCockpit.SelectObject(theMetaObject, true);
        }
    }

    public void setCurrentLanguage(int theLanguage) {
        this.theMetaProject.setCurrentLanguage(theLanguage);
    }

    public HammerLanguagePresentation getLanguage(int iLang) {
        return this.theMetaProject.getLanguage(iLang);
    }

    public MetaObject Pasting(MetaObject thePastedObject, SuperDesignCockpit theDesignCockpit) {
        String sObjectName = thePastedObject.getName();
        if (this.findObject(sObjectName) != null) {
            sObjectName = this.getNewObjectName(thePastedObject.theType.theName);
            thePastedObject.setPropertyValue("Text", 0, 0, (Object)sObjectName, true);
        }
        thePastedObject.setName(sObjectName);
        MetaObject theNewObject = new MetaObject(thePastedObject, null, this.theMetaProject, 1);
        if (theNewObject != null) {
            this.addObject(theNewObject);
            theNewObject.create();
            boolean bTest = theDesignCockpit.theViewDisplayer.testObject(theNewObject);
            if (bTest) {
                theDesignCockpit.SelectContainer(null);
                theDesignCockpit.theObjectTreeViewPane.addObjects(theNewObject);
                theDesignCockpit.SelectContainer(theNewObject);
                return theNewObject;
            }
            theNewObject.DeleteObject(this.theMetaProject, (AbaMetaDataUser)theDesignCockpit);
            return null;
        }
        return null;
    }

    public MetaObject PasteChildObject(MetaObject thePastedObject, SuperDesignCockpit theCockpit, boolean bPreserveObjectNames) {
        MetaObject theNewObject = this.Pasting(thePastedObject, theCockpit);
        for (thePastedObject = thePastedObject.getFirstChild(); theNewObject != null && thePastedObject != null; thePastedObject = thePastedObject.getNextObject()) {
            if (theCockpit.PasteChildObject(theNewObject, thePastedObject, this.theMetaProject, bPreserveObjectNames) != null) continue;
            return null;
        }
        return theNewObject;
    }

    public MetaObject PasteObject(MetaObject thePastedObject, SuperDesignCockpit theDesignCockpit, boolean bPreserveObjectNames) {
        MetaObject theNewObject = this.PasteChildObject(thePastedObject, theDesignCockpit, bPreserveObjectNames);
        if (theNewObject != null) {
            theDesignCockpit.SelectObject(theNewObject, false);
            return theNewObject;
        }
        return null;
    }

    public MetaObject findObject(MetaObject theObject, String sObjectName) {
        while (theObject != null) {
            if (theObject.getName().equals(sObjectName)) {
                return theObject;
            }
            MetaObject theChildMatch = this.findObject(theObject.theFirstChild, sObjectName);
            if (theChildMatch != null) {
                return theChildMatch;
            }
            theObject = theObject.theNextObject;
        }
        return null;
    }

    public ArrayList findObjectsByClass(String sClassName) {
        return this.theMetaProject.findObjectsByClass(sClassName);
    }

    public MetaObject findObject(String sObjectName) {
        return this.theMetaProject.findObject(sObjectName);
    }

    public String getNewObjectName(String sClassName) {
        return this.theMetaProject.getNewObjectName(sClassName);
    }

    public MetaClass findClass(MetaClass theClass, String sClassName) {
        return this.theMetaProject.findClass(theClass, sClassName);
    }

    public MetaClass findClass(String sClassName) {
        return this.theMetaProject.findClass(sClassName);
    }

    MetaClass findListener(MetaClass theListener, String sListenerName) {
        return this.theMetaProject.findListener(theListener, sListenerName);
    }

    MetaClass findListener(String sListenerName) {
        return this.theMetaProject.findListener(sListenerName);
    }

    public MetaClassDetail getNewListener(String sListenerName) {
        return this.theMetaProject.getNewListener(sListenerName);
    }

    public MetaClassDetail getNewDefaultListener(int iIndex) {
        return this.theMetaProject.getNewDefaultListener(iIndex);
    }

    public int getDefaultListenerCount() {
        return this.theMetaProject.getDefaultListenerCount();
    }

    public int getContainerListener() {
        return this.theMetaProject.getContainerListener();
    }

    public boolean findChildObjectByName(String sObjectName) {
        return this.theMetaProject.findChildObjectByName(sObjectName);
    }

    public boolean close(boolean vetoable) {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)this.theMetaProject.getMetaDataUser();
        if (this.theMetaProject.getFirstObject() == null) {
            return true;
        }
        if (!this.theMetaProject.getProjectChangedState()) {
            return true;
        }
        if (!theDesignCockpit.isCustomizing()) {
            int messageType;
            int selection;
            String question = "Do you wish to save the project \"" + this.theMetaProject.sName + "\" before closing?";
            String title = "Close Confirmation Dialog";
            int optionType = 1;
            if (!vetoable) {
                optionType = 0;
            }
            if ((selection = JOptionPane.showConfirmDialog((Component)((Object)theDesignCockpit), question, title, optionType, messageType = 3)) == 2) {
                return false;
            }
            if (selection == 1) {
                return true;
            }
            if (this.theMetaProject.sName == null || this.theMetaProject.sName.startsWith("New Project") || this.theMetaProject.sName.trim().length() == 0) {
                SuperDesignCockpit.theProjectName = null;
            }
        } else {
            int selection = theDesignCockpit.theCustomizer.querySaveOnExit();
            if (selection == 2) {
                return false;
            }
            if (selection == 1) {
                return true;
            }
        }
        theDesignCockpit.setCurrentDesignProject(this);
        theDesignCockpit.SaveProject(false);
        return true;
    }

    public boolean store(boolean vetoable) {
        int messageType;
        int selection;
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)this.theMetaProject.getMetaDataUser();
        if (this.theMetaProject.getFirstObject() == null) {
            return true;
        }
        if (!this.theMetaProject.getProjectChangedState()) {
            return true;
        }
        String question = "Do you wish to save the project \"" + this.theMetaProject.sName + "\"?";
        String title = "Confirmation Dialog";
        int optionType = 1;
        if (!vetoable) {
            optionType = 0;
        }
        if ((selection = JOptionPane.showConfirmDialog((Component)((Object)theDesignCockpit), question, title, optionType, messageType = 3)) == 2) {
            return false;
        }
        if (selection == 1) {
            return true;
        }
        if (this.theMetaProject.sName == null || this.theMetaProject.sName.startsWith("New Project") || this.theMetaProject.sName.trim().length() == 0) {
            SuperDesignCockpit.theProjectName = null;
        }
        theDesignCockpit.setCurrentDesignProject(this);
        theDesignCockpit.SaveProject(false);
        Component[] theProjectWindowMenuItems = theDesignCockpit.getIDEMenuBar().getWindowMenu().getMenuComponents();
        for (int i = 0; i < theProjectWindowMenuItems.length; ++i) {
            JMenuItem theMenuItem;
            if (!(theProjectWindowMenuItems[i] instanceof JMenuItem) || !(theMenuItem = (JMenuItem)theProjectWindowMenuItems[i]).getText().equals(this.theMetaProject.sName)) continue;
            theMenuItem.setText(SuperDesignCockpit.theProjectName);
            break;
        }
        return true;
    }

    public boolean save(MetaProjectHeader progInfo, Element theParent) {
        return this.theMetaProject.save(progInfo, theParent);
    }

    public boolean load(Element theElement) {
        return this.theMetaProject.load(theElement);
    }

    public void addObject(MetaObject theNewObject) {
        this.theMetaProject.addObject(theNewObject);
    }

    public MetaConstantGroup findConstantGroup(String sGroupName) {
        return this.theMetaProject.findConstantGroup(sGroupName);
    }

    public MetaConstantGroupCollection findConstantGroupCollection(String sGroupName) {
        return this.theMetaProject.findConstantGroupCollection(sGroupName);
    }

    public boolean loadMeta(String sSystemDocument) {
        return this.theMetaProject.getMetadataDispenser().theMetadataDocument.loadMeta(sSystemDocument);
    }

    public boolean loadResource(String sResource) throws HammerException {
        return this.theMetaProject.loadResource(sResource);
    }

    public boolean loadXML(String sData) {
        return this.theMetaProject.loadXML(sData);
    }

    public boolean load(HammerJarAccess theJarAccess) {
        return this.theMetaProject.load(theJarAccess);
    }

    public boolean load(String sProjectDocument) {
        return this.theMetaProject.load(sProjectDocument);
    }

    public void setMetaDataUser(AbaMetaDataUser objUser) {
        this.theMetaProject.setMetaDataUser(objUser);
    }

    public AbaMetaDataUser getMetaDataUser() {
        return this.theMetaProject.getMetaDataUser();
    }

    public String getProjectDirectory() {
        return this.theMetaProject.getProjectDirectory();
    }

    public String getGenCodeLAF() {
        return this.theMetaProject.getGenCodeLAF();
    }

    public void setGenCodeLAF(String codeLAF) {
        this.theMetaProject.setGenCodeLAF(codeLAF);
    }

    public void setProjectDirectory(String sProjectDirectory) {
        this.theMetaProject.setProjectDirectory(sProjectDirectory);
    }

    private class SelectedObjects
    extends ArrayList {
        public SelectedObjects(int initialCapacity) {
            super(initialCapacity);
        }

        public boolean add(Object o) {
            boolean bAdd = super.add(o);
            SuperDesignCockpit cockpit = (SuperDesignCockpit)DesignProject.this.theMetaProject.getMetaDataUser();
            IDEPropertyInspectorController propertyInspectorController = cockpit.getPropertyInspectorController();
            if (propertyInspectorController != null) {
                propertyInspectorController.refreshPropertyInspector();
            }
            return bAdd;
        }

        public boolean remove(Object o) {
            boolean bRemove = super.remove(o);
            SuperDesignCockpit cockpit = (SuperDesignCockpit)DesignProject.this.theMetaProject.getMetaDataUser();
            cockpit.getPropertyInspectorController().refreshPropertyInspector();
            return bRemove;
        }

        public void clear() {
            super.clear();
            SuperDesignCockpit cockpit = (SuperDesignCockpit)DesignProject.this.theMetaProject.getMetaDataUser();
            cockpit.getPropertyInspectorController().refreshPropertyInspector();
        }
    }
}

