/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEArrayValueDescriptor;
import ch.abacus.designcockpit.ide.IDEArrayValueEditorTable;
import ch.abacus.designcockpit.ide.IDEArrayValueEditorTableModel;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;

public class IDEArrayValueEditor
extends JADialog {
    String sPropertyName;
    MetaObject theObject;
    IDEArrayValueEditorTableModel theModel;
    IDEArrayValueEditorTable theArrayValueTable;
    JScrollPane theArrayValueScrollPane;
    UpButtonAction theUpAction;
    DownButtonAction theDownAction;
    DeleteButtonAction theDeleteAction;
    OKButtonAction theOKAction;
    InsertButtonAction theInsertAction;
    AppendButtonAction theAppendAction;
    CancelButtonAction theCancelAction;
    JButton theUpButton;
    JButton theDownButton;
    JButton theDeleteButton;
    JButton theOKButton;
    JButton theCancelButton;
    JButton theInsertButton;
    JButton theAppendButton;
    SuperDesignCockpit theDesignCockpit;

    public IDEArrayValueEditor(MetaObject theObject, String sPropertyName, SuperDesignCockpit theDesignCockpit) {
        super((JAFrame)theDesignCockpit, "Array Value Editor for " + sPropertyName, true, false);
        this.theObject = theObject;
        this.theDesignCockpit = theDesignCockpit;
        this.sPropertyName = sPropertyName;
        this.theModel = new IDEArrayValueEditorTableModel();
        this.theModel.theMetaObject = theObject;
        this.theArrayValueTable = new IDEArrayValueEditorTable(this.theModel, sPropertyName);
        this.theArrayValueScrollPane = new JScrollPane((Component)((Object)this.theArrayValueTable));
        this.theArrayValueTable.Load();
        this.theUpAction = new UpButtonAction(this, theObject);
        this.theDownAction = new DownButtonAction(this, theObject);
        this.theDeleteAction = new DeleteButtonAction(this, theObject);
        this.theOKAction = new OKButtonAction(this, theObject);
        this.theCancelAction = new CancelButtonAction(this, theObject);
        this.theInsertAction = new InsertButtonAction(this, theObject);
        this.theAppendAction = new AppendButtonAction(this, theObject);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlTable = new JAPanel((LayoutManager)new FlowLayout());
        pnlTable.setLayout((LayoutManager)new BorderLayout());
        pnlTable.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JAPanel pnlButtons = new JAPanel((LayoutManager)new GridLayout(7, 1, 10, 10));
        pnlTable.add((Component)this.theArrayValueScrollPane, (Object)"Center");
        this.theUpButton = new JButton(this.theUpAction);
        this.theDownButton = new JButton(this.theDownAction);
        this.theInsertButton = new JButton(this.theInsertAction);
        this.theDeleteButton = new JButton(this.theDeleteAction);
        this.theAppendButton = new JButton(this.theAppendAction);
        this.theOKButton = new JButton(this.theOKAction);
        this.theCancelButton = new JButton(this.theCancelAction);
        pnlButtons.add((Component)this.theUpButton);
        pnlButtons.add((Component)this.theDownButton);
        pnlButtons.add((Component)this.theInsertButton);
        pnlButtons.add((Component)this.theDeleteButton);
        pnlButtons.add((Component)this.theAppendButton);
        pnlButtons.add((Component)this.theOKButton);
        pnlButtons.add((Component)this.theCancelButton);
        JAPanel pnlTopButtons = new JAPanel();
        pnlTopButtons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pnlTopButtons.add((Component)pnlButtons);
        pane.add((Component)pnlTable, "Center");
        pane.add((Component)pnlTopButtons, "East");
        this.setSize(400, 300);
        this.setLocation(48, 120);
        this.setLocationRelativeTo(null);
        this.show(null);
    }

    void Load(String sPropertyName, MetaObject theObject) {
        this.setTitle("Array Value Editor for " + sPropertyName);
        this.theObject = theObject;
        this.sPropertyName = sPropertyName;
        this.theModel = new IDEArrayValueEditorTableModel();
        this.theModel.theMetaObject = theObject;
        this.theModel.thePropertyName = sPropertyName;
        this.theArrayValueTable.setModel(this.theModel);
        this.theArrayValueTable.Load();
    }

    class CancelButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDEArrayValueEditor theEditor;

        public CancelButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Cancel");
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theEditor.removeAll();
            this.theEditor.hide();
            this.theEditor = null;
        }
    }

    class OKButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDEArrayValueEditor theEditor;

        public OKButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("OK");
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = this.theEditor.theArrayValueTable;
            int iValueCount = theTable.theModel.getRowCount();
            this.theEditor.theDesignCockpit.getDesignProject().theUndoRedoController.createChangePropertyEvent(this.theMetaObject, IDEArrayValueEditor.this.sPropertyName);
            for (int i = 0; i < iValueCount; ++i) {
                this.theMetaObject.setPropertyValue(this.theEditor.sPropertyName, i, 0, theTable.theModel.getValueAt(i, 1), true);
            }
            this.theEditor.removeAll();
            this.theEditor.hide();
            this.theEditor = null;
        }
    }

    class AppendButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDEArrayValueEditor theEditor;

        public AppendButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Add");
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = this.theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = this.theEditor.theModel;
            IDEArrayValueDescriptor newCellData = new IDEArrayValueDescriptor("");
            theModel.theArrayValues.add(newCellData);
            theTable.updateUI();
            this.theEditor.theAppendButton.setSelected(false);
        }
    }

    class InsertButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDEArrayValueEditor theEditor;

        public InsertButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Insert");
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = this.theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = this.theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow != -1) {
                IDEArrayValueDescriptor newCellData = new IDEArrayValueDescriptor("");
                theModel.theArrayValues.add(iRow, newCellData);
                theTable.updateUI();
            }
            this.theEditor.theInsertButton.setSelected(false);
        }
    }

    class DeleteButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDEArrayValueEditor theEditor;

        public DeleteButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Delete");
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = this.theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = this.theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow != -1) {
                theModel.theArrayValues.remove(iRow);
                theTable.updateUI();
            }
            this.theEditor.theDeleteButton.setSelected(false);
        }
    }

    class DownButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDEArrayValueEditor theEditor;

        public DownButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Down");
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = this.theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = this.theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            int iRowCount = theTable.getRowCount();
            if (iRow != -1 && iRow < iRowCount - 1) {
                Object objToRaise = theModel.theArrayValues.get(iRow + 1);
                Object objToLower = theModel.theArrayValues.get(iRow);
                theModel.theArrayValues.set(iRow + 1, objToLower);
                theModel.theArrayValues.set(iRow, objToRaise);
                theTable.repaint();
            }
            this.theEditor.theDownButton.setFocusPainted(false);
        }
    }

    class UpButtonAction
    extends AbstractAction {
        MetaObject theMetaObject;
        IDEArrayValueEditor theEditor;

        public UpButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Up");
            this.theMetaObject = null;
            this.theEditor = null;
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = this.theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = this.theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow > 0) {
                Object objToRaise = theModel.theArrayValues.get(iRow);
                Object objToLower = theModel.theArrayValues.get(iRow - 1);
                theModel.theArrayValues.set(iRow, objToLower);
                theModel.theArrayValues.set(iRow - 1, objToRaise);
                theTable.repaint();
            }
            this.theEditor.theUpButton.setFocusPainted(false);
        }
    }
}

