/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaCloneMode;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public class IDEClipboardController {
    static final int CLIPBOARD_NONE = 0;
    static final int CLIPBOARD_TEXT = 1;
    static final int CLIPBOARD_OBJECT = 2;
    int clipboardContent = 0;
    public int theCloneMode = 0;
    ArrayList theMetaObjects = new ArrayList(0);
    SuperDesignCockpit theDesignCockpit;
    AbstractAction lastClipboardBufferingAction = null;

    public IDEClipboardController(SuperDesignCockpit theDesignCockpit) {
        this.theDesignCockpit = theDesignCockpit;
    }

    public void setClipboardContent(int content) {
        this.clipboardContent = content;
    }

    public int getClipboardContent() {
        return this.clipboardContent;
    }

    public void removeAllClipboardObjects() {
        this.theMetaObjects.clear();
    }

    public void removeClipboardObject(MetaObject theMetaObject) {
        this.theMetaObjects.remove(theMetaObject);
    }

    public IDEClipboardController getClone() {
        IDEClipboardController theReturnValue = new IDEClipboardController(this.theDesignCockpit);
        for (int i = 0; i < this.getClipboardObjectCount(); ++i) {
            theReturnValue.addClipboardObject(this.getClipboardObject(i).Clone(new MetaCloneMode(0), null, false));
        }
        return theReturnValue;
    }

    public void addClipboardObject(MetaObject theMetaObject) {
        theMetaObject.attachToProject(this.theDesignCockpit.getDesignProject().theMetaProject);
        this.theMetaObjects.add(theMetaObject);
    }

    public int getClipboardObjectCount() {
        return this.theMetaObjects.size();
    }

    public MetaObject getClipboardObject(int i) {
        return (MetaObject)this.theMetaObjects.get(i);
    }

    public Point getOriginTopSelection() {
        Point pt = new Point(65535, 65535);
        for (int i = 0; i < this.theMetaObjects.size(); ++i) {
            MetaObject testObject = (MetaObject)this.theMetaObjects.get(i);
            if (testObject.isAbalet() || testObject.isFrame()) continue;
            Point ptLocation = new Point(testObject.iXLocation, testObject.iYLocation);
            if (pt.y > ptLocation.y) {
                pt = ptLocation;
                continue;
            }
            if (pt.y != ptLocation.y || pt.x <= ptLocation.x) continue;
            pt = ptLocation;
        }
        return pt;
    }

    public Point getOriginClipboardObject(MetaObject theTargetObject, int i, Point ptActualStrike, Point ptLastPopupLocation) {
        Point pt = this.getOriginTopSelection();
        MetaObject testObject = (MetaObject)this.theMetaObjects.get(i);
        Point ptLocation = testObject.getLocation();
        return new Point(ptLastPopupLocation.x + ptLocation.x - pt.x, ptLastPopupLocation.y + ptLocation.y - pt.y);
    }

    public void setClipboardBufferingAction(AbstractAction theAction) {
        this.lastClipboardBufferingAction = theAction;
    }

    public AbstractAction getClipboardBufferingAction() {
        return this.lastClipboardBufferingAction;
    }
}

