/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.CustomTreeCellRenderer;
import ch.abacus.designcockpit.ide.DriveComboListener;
import ch.abacus.designcockpit.ide.FileTreeNode;
import ch.abacus.designcockpit.ide.HierarchyBrowserUpdater;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JACheckBox;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JATree;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.HammerConfigurationManager;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import com.sun.java.swing.plaf.windows.WindowsTreeUI;
import electric.xml.Child;
import electric.xml.Document;
import electric.xml.Element;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class IDEImporter
extends JAFrame
implements WindowListener {
    public static final String JAVALIBRARYEXT = new String(".jar");
    public static final String JAVALIBRARYCLASS = new String(".class");
    protected JAButton btnImport = new JAButton("Import");
    protected JAButton btnCancelImport = new JAButton("Cancel");
    protected SuperDesignCockpit theDesignCockpit = null;
    protected JTree tree = null;
    protected JScrollPane treeView = null;
    protected JScrollPane propListView = null;
    protected JScrollPane classListView = null;
    protected JComboBox driveCombo;
    protected JAList propList = new JAList();
    protected ClassTree classList = new ClassTree();
    protected ImageIcon impIcon;
    protected ImageIcon impStopIcon;
    protected HammerConfigurationManager theConfigurationManager = null;
    protected HammerImageIconFactory theIconFactory = null;
    protected String sImageDirectory;
    private JScrollPane eventListView;
    public JAList eventList = new JAList();
    private JACheckBox compositeCheckbox;
    JPanel panel2 = new JPanel();
    JAButton btnBack = new JAButton("<< Back");
    JPanel drivePanel;
    int btnNextX = 190;
    int btnBackX = 190;
    int btnImportX = 5;
    int btnCancelX = 100;

    public IDEImporter(SuperDesignCockpit objDesignCockpit) {
        this.setTitle("Class Importer");
        this.theDesignCockpit = objDesignCockpit;
        AnchoringLayoutManager layoutManagerJAFrameXSubclass0Subclass01 = new AnchoringLayoutManager();
        this.getContentPane().setLayout((LayoutManager)layoutManagerJAFrameXSubclass0Subclass01);
        Border loweredetched = BorderFactory.createEtchedBorder();
        this.setSize(700, 320);
        this.btnNextX = (int)this.getSize().getWidth() - ((int)this.btnBack.getPreferredSize().getWidth() + this.getInsets().right + 20);
        this.btnBackX = (int)this.getSize().getWidth() - ((int)this.btnBack.getPreferredSize().getWidth() + this.getInsets().right + 20);
        this.btnCancelX = this.btnBackX - ((int)this.btnCancelImport.getPreferredSize().getWidth() + this.getInsets().right + 20);
        this.btnImportX = this.btnCancelX - ((int)this.btnImport.getPreferredSize().getWidth() + this.getInsets().right + 20);
        this.panel2.setLayout(new GridLayout(1, 4, 5, 5));
        this.panel2.setSize(new Dimension(700, 250));
        this.panel2.setVisible(false);
        this.getContentPane().add((Component)this.panel2, "panel2");
        SuperDesignCockpit jParContainer = objDesignCockpit;
        Dimension dm = ((Component)((Object)jParContainer)).getSize();
        Double wLoc = new Double(dm.getWidth() / 2.0 - (double)(this.getWidth() / 2));
        Double hLoc = new Double(dm.getHeight() / 2.0 - (double)(this.getHeight() / 2));
        this.setLocation(wLoc.intValue(), hLoc.intValue());
        this.addWindowListener(this);
        this.SetIcons();
        this.btnImport.setEnabled(false);
        this.btnImport.setLocation(this.btnNextX, 260);
        this.btnImport.setText("Next >>");
        this.getContentPane().add((Component)this.btnImport, "btnImport");
        layoutManagerJAFrameXSubclass0Subclass01.setAnchoring((Component)this.btnImport, false, false, false, false);
        this.btnCancelImport.setLocation(this.btnCancelX, 260);
        this.btnCancelImport.setText("Cancel");
        this.getContentPane().add((Component)this.btnCancelImport, "btnCancelImport");
        layoutManagerJAFrameXSubclass0Subclass01.setAnchoring((Component)this.btnCancelImport, false, false, false, false);
        this.driveCombo = new JComboBox();
        String sdefaultdir = this.getRepositoryPath(this.theDesignCockpit.getDesignProject().theMetaProject);
        this.driveCombo.addItem(sdefaultdir);
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            this.driveCombo.addItem(roots[i].toString());
        }
        DefaultTreeModel treemodel = this.setJListModel(sdefaultdir);
        this.tree = new JTree(treemodel);
        this.tree.setDoubleBuffered(true);
        FileTreeNode root = (FileTreeNode)treemodel.getRoot();
        HierarchyBrowserUpdater upd = new HierarchyBrowserUpdater(this.tree, root, treemodel, this);
        this.tree.addTreeExpansionListener(upd);
        this.tree.addTreeSelectionListener(upd);
        CustomTreeCellRenderer customCellRenderer = new CustomTreeCellRenderer(this.theIconFactory, this.sImageDirectory);
        this.tree.setCellRenderer(customCellRenderer);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayout(1, 3, 10, 5));
        panel1.setPreferredSize(new Dimension(690, 250));
        panel1.setMaximumSize(new Dimension(690, 250));
        this.drivePanel = this.createClassFilePanel();
        this.drivePanel.setBorder(BorderFactory.createEtchedBorder());
        this.drivePanel.setPreferredSize(new Dimension(500, 250));
        this.drivePanel.setMinimumSize(new Dimension(500, 250));
        panel1.add(this.drivePanel);
        this.classListView = new JScrollPane((Component)((Object)this.classList));
        this.classListView.setViewportView((Component)((Object)this.classList));
        JPanel classListPanel = new JPanel();
        classListPanel.setLayout(new BorderLayout());
        classListPanel.add((Component)new JLabel("Import under"), "North");
        classListPanel.add((Component)this.classListView, "Center");
        classListPanel.setBorder(loweredetched);
        panel1.add(classListPanel);
        String labelText1 = "<html><TABLE><TR valign=top><TD valign=top align=left><OL><LI>Select the Component class file from the File selection dialog.</LI><LI>Select the Section name to import your component under.</LI><LI>Click on the Next button to continue the import or Cancel to exit.</LI><P></OL></TD></TR></TABLE></html>";
        JLabel label1 = new JLabel(labelText1, 2);
        label1.setBorder(BorderFactory.createTitledBorder("Instructions"));
        panel1.add(label1);
        this.getContentPane().add((Component)panel1, "panel1");
        this.propListView = new JScrollPane((Component)this.propList);
        this.propListView.setViewportView((Component)this.propList);
        JPanel propListPanel = new JPanel();
        propListPanel.setLayout(new BorderLayout());
        propListPanel.add((Component)new JLabel("Properties"), "North");
        propListPanel.add((Component)this.propListView, "Center");
        propListPanel.setPreferredSize(new Dimension(130, 200));
        propListPanel.setBorder(loweredetched);
        this.panel2.add(propListPanel);
        this.propList.addMouseListener((MouseListener)upd);
        this.eventListView = new JScrollPane((Component)this.eventList);
        this.eventListView.setViewportView((Component)this.eventList);
        JPanel eventListPanel = new JPanel();
        eventListPanel.setLayout(new BorderLayout());
        eventListPanel.add((Component)new JLabel("Events"), "North");
        eventListPanel.add((Component)this.eventListView, "Center");
        eventListPanel.setPreferredSize(new Dimension(130, 200));
        eventListPanel.setBorder(loweredetched);
        this.panel2.add(eventListPanel);
        this.eventList.addMouseListener((MouseListener)upd);
        Vector metaVector = null;
        MetaProject mtProj = this.theDesignCockpit.getDesignProject().theMetaProject;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("New Section");
        rootNode.add(node);
        for (MetaClass topClass = this.theDesignCockpit.getDesignProject().theMetaProject.getFirstClass(); topClass != null; topClass = topClass.getNextSibling()) {
            node = new DefaultMutableTreeNode(topClass.theMetadata.sClassName);
            metaVector = mtProj.getMetadataDispenser().getMetaClassesList(topClass);
            for (int i = 0; i < metaVector.size(); ++i) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(metaVector.get(i));
                node.add(child);
            }
            rootNode.add(node);
        }
        this.classList.setModel(new DefaultTreeModel(rootNode));
        this.classList.expandAll();
        this.btnImport.addActionListener((ActionListener)new OKListener(this, this.theDesignCockpit, this.tree));
        this.btnCancelImport.addActionListener((ActionListener)new CancelListener(this));
        this.compositeCheckbox = new JACheckBox("Composite");
        this.compositeCheckbox.setToolTipText("Display child components in design mode");
        JPanel compositePanel = new JPanel();
        compositePanel.setLayout(new BorderLayout());
        compositePanel.add((Component)this.compositeCheckbox, "North");
        String labelText = "<html><TABLE><TR valign=top><TD><OL><LI>Select the section to import your component under.</LI><LI>Choose the Properties you would like to import from the Properties list.</LI><LI>Choose all Listeners you would like to import from the Event list.</LI><LI>Click on the Import button to complete the process.</LI><OL></TD></TR></TABLE></html>";
        JLabel label = new JLabel(labelText, 0);
        label.setBorder(BorderFactory.createTitledBorder("Instructions"));
        label.setPreferredSize(new Dimension(215, 200));
        compositePanel.add((Component)label, "West");
        this.panel2.add(compositePanel);
        this.btnBack.setVisible(false);
        this.getContentPane().add((Component)this.btnBack, "btnBack");
        this.btnBack.setLocation(this.btnBackX, 260);
        this.btnBack.addActionListener((ActionListener)new BackListener(this, this.theDesignCockpit, this.tree));
        this.show();
    }

    private ComponentSelectDialog createComponentSelectDialog(JPanel drivePanel) {
        final ComponentSelectDialog componentSelectDialog = new ComponentSelectDialog();
        componentSelectDialog.setLayout(new BorderLayout());
        componentSelectDialog.add((Component)drivePanel, "North");
        JPanel okCancelPanel = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                componentSelectDialog.setVisible(false);
            }
        });
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                componentSelectDialog.okSelected = true;
                componentSelectDialog.setVisible(false);
            }
        });
        okCancelPanel.add(okButton);
        okCancelPanel.add(cancelButton);
        componentSelectDialog.add((Component)okCancelPanel, "Center");
        return componentSelectDialog;
    }

    private JPanel createClassFilePanel() {
        JPanel drivePanel = new JPanel();
        drivePanel.setLayout(new BorderLayout());
        JLabel alabel = new JLabel("Component Selection", 2);
        alabel.setSize(new Dimension(300, 20));
        drivePanel.add((Component)alabel, "North");
        DriveComboListener actionListener = new DriveComboListener(this);
        this.driveCombo.addActionListener(actionListener);
        this.driveCombo.setSize(new Dimension(300, 15));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.setSize(new Dimension(300, 200));
        this.treeView.setFocusable(true);
        this.treeView.setViewportView(this.tree);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.driveCombo, "North");
        contentPanel.add((Component)this.treeView, "Center");
        drivePanel.add((Component)contentPanel, "Center");
        return drivePanel;
    }

    public DefaultTreeModel setJListModel(String driveLetter) {
        FileTreeNode root = (FileTreeNode)this.buildTree(driveLetter);
        DefaultTreeModel treemodel = new DefaultTreeModel(root);
        return treemodel;
    }

    protected void SetIcons() {
        this.theConfigurationManager = this.theDesignCockpit.getConfigurationManager();
        this.sImageDirectory = this.theConfigurationManager.getConfigurationVariable("ImagePath");
        if (this.sImageDirectory == null) {
            this.sImageDirectory = "";
        } else if (!this.sImageDirectory.endsWith("/") && !this.sImageDirectory.endsWith("\\")) {
            this.sImageDirectory = this.sImageDirectory + "/";
        }
        this.theIconFactory = new HammerImageIconFactory(this.theDesignCockpit.theClassLoader);
        this.impIcon = this.theIconFactory.getHammerImageIcon(this.sImageDirectory + "import1.png");
        this.impStopIcon = this.theIconFactory.getHammerImageIcon(this.sImageDirectory + "media_stop_red.png");
    }

    public TreeNode buildTree(String dir) {
        FileTreeNode aroot = null;
        try {
            aroot = new FileTreeNode(new File(dir));
            aroot.readTree(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aroot;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            // empty if block
        }
    }

    boolean Import(MetaProject theDesignProject) throws ClassNotFoundException {
        int iretval;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        Object oUserObject = node.getUserObject();
        String UnClassesToImport = oUserObject.toString();
        String sClassToImport = UnClassesToImport.replace(File.separator, ".").substring(0, UnClassesToImport.length() - 6);
        Metafier theMetafier = new Metafier(sClassToImport);
        if (!theMetafier.processClass()) {
            return false;
        }
        String repositoryPath = this.getRepositoryPath(theDesignProject);
        String xmlFilename = repositoryPath + File.separator + sClassToImport + ".xml";
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(xmlFilename));
        if (fc.showSaveDialog((Component)((Object)this)) != 0) {
            return false;
        }
        File selFile = fc.getSelectedFile();
        if (selFile.exists() && (iretval = JOptionPane.showConfirmDialog((Component)((Object)this), "File exists, overwrite?\n", "Message", 0)) != 0) {
            return false;
        }
        try {
            theMetafier.theDocument.write(selFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't write to file:\n" + selFile.getAbsolutePath() + "\n" + e, "Error", 0);
            return false;
        }
        repositoryPath = selFile.getParent();
        this.theDesignCockpit.thePreferences.setRepositPath(repositoryPath);
        DefaultMutableTreeNode pnode = (DefaultMutableTreeNode)node.getParent();
        String additionalPath = pnode.getUserObject().toString();
        String oldPath = this.theDesignCockpit.thePreferences.getAdditionalClasspath();
        if (oldPath == null) {
            this.theDesignCockpit.thePreferences.setAdditionalClasspath(additionalPath);
        } else if (oldPath.indexOf(additionalPath) == -1) {
            this.theDesignCockpit.thePreferences.setAdditionalClasspath(oldPath + ";" + additionalPath);
        }
        this.theDesignCockpit.thePreferences.save(this.theDesignCockpit);
        this.theDesignCockpit.getDesignProject().theMetaProject.resetMetadata();
        this.theDesignCockpit.getDesignProject().theMetaProject.loadMeta("ch.abacus.lib.ui.renderer.deploy.metadata.meta");
        this.theDesignCockpit.theComponentPalettePane.clear();
        this.theDesignCockpit.getDesignProject().theMetaProject.loadCustomMeta("ch.abacus.lib.ui.renderer.deploy.metadata.meta", repositoryPath);
        this.theDesignCockpit.theComponentPalettePane.load(this.theDesignCockpit.getDesignProject().theMetaProject.getFirstClass(), null);
        this.theDesignCockpit.setbMetadataDirty(true);
        return true;
    }

    private String getRepositoryPath(MetaProject theDesignProject) {
        String repositoryPath = theDesignProject.getMetaDataUser().getConfigurationManager().getConfigurationVariable("RepositoryPath");
        if ((repositoryPath = new File(repositoryPath).getAbsolutePath()) == null || repositoryPath.length() == 0) {
            repositoryPath = theDesignProject.getProjectDirectory();
        }
        if (repositoryPath == null || repositoryPath.length() == 0) {
            repositoryPath = System.getProperty("user.home");
        }
        return repositoryPath;
    }

    public void show() {
        super.show();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
    }

    class Metafier {
        public String sClassName = "default";
        public String sShortName = "";
        Class theClass = null;
        Class theJAComponentClass = null;
        Class theJAPanelClass = null;
        Class theJAFrameClass = null;
        Class theJAScrollPaneClass = null;
        Class theJATabbedPaneClass = null;
        Class theScrollBarClass = null;
        Class theSliderClass = null;
        Class theListClass = null;
        Class theTextAreaClass = null;
        Class theRadioClass = null;
        Class theCheckBoxClass = null;
        Class theComboBoxClass = null;
        Class theTextFieldClass = null;
        Class theLabelClass = null;
        public Document theDocument = null;
        public Element theRootElement = null;
        String[] theSkippedProperties = new String[]{"Size", "Location"};

        public Metafier() {
        }

        public Metafier(String theClassName) {
            this.sClassName = theClassName;
        }

        boolean processClass() throws ClassNotFoundException {
            this.loadClass();
            boolean bTest = this.initializeMetadata();
            if (bTest) {
                bTest = this.processClassHeaderInformation();
            }
            if (bTest) {
                bTest = this.addDefaultProperties();
            }
            if (bTest) {
                bTest = this.addClassProperties();
            }
            return bTest;
        }

        void loadClass() throws ClassNotFoundException {
            this.theClass = Class.forName(this.sClassName);
            int iLastDot = this.sClassName.lastIndexOf(".");
            this.sShortName = this.sClassName.substring(iLastDot + 1);
            try {
                this.theJAComponentClass = Class.forName("javax.swing.JAComponent");
                this.theJAFrameClass = Class.forName("javax.swing.JAFrame");
                this.theJAPanelClass = Class.forName("javax.swing.JAPanel");
                this.theJAScrollPaneClass = Class.forName("javax.swing.JAScrollPane");
                this.theJATabbedPaneClass = Class.forName("javax.swing.JATabbedPane");
                this.theScrollBarClass = Class.forName("javax.swing.JAScrollBar");
                this.theSliderClass = Class.forName("javax.swing.JASlider");
                this.theListClass = Class.forName("javax.swing.JAList");
                this.theTextAreaClass = Class.forName("javax.swing.JATextArea");
                this.theRadioClass = Class.forName("javax.swing.JARadioButton");
                this.theCheckBoxClass = Class.forName("javax.swing.JACheckBox");
                this.theComboBoxClass = Class.forName("javax.swing.JAComboBox");
                this.theTextFieldClass = Class.forName("javax.swing.JATextField");
                this.theLabelClass = Class.forName("javax.swing.JALabel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        boolean initializeMetadata() {
            String classSectionName;
            if (IDEImporter.this.classList.getSelectionPath() == null) {
                JOptionPane.showMessageDialog(null, "Please select a Section", "Error", 0);
                return false;
            }
            this.theDocument = new Document();
            String componentSection = IDEImporter.this.classList.getSelectionPath().getPath()[IDEImporter.this.classList.getSelectionPath().getPath().length - 1].toString();
            if (componentSection.equalsIgnoreCase("New Section")) {
                componentSection = "Custom";
            }
            if ((classSectionName = IDEImporter.this.classList.getSelectionPath().getPath()[IDEImporter.this.classList.getSelectionPath().getPath().length - 1].toString()) == null) {
                JOptionPane.showMessageDialog(null, "Please select a Section", "Error", 0);
                return false;
            }
            this.theRootElement = new Element(componentSection);
            this.theDocument.setRoot(this.theRootElement);
            Element rootClassesTag = new Element("Classes");
            this.theRootElement.addElement(rootClassesTag);
            if (componentSection.equalsIgnoreCase("Custom")) {
                classSectionName = JOptionPane.showInputDialog(null, "Component Section Name", "New Component Section", 0);
            }
            Element sectionTag = new Element(classSectionName);
            rootClassesTag.addElement(sectionTag);
            this.addClassEvents(sectionTag);
            Element classTag = new Element("Classes");
            sectionTag.addElement(classTag);
            Element shortName = new Element(this.sShortName);
            classTag.addElement(shortName);
            Element theFullClassName = new Element("FullClassName");
            theFullClassName.addText(this.sClassName);
            shortName.addElement(theFullClassName);
            this.theRootElement = shortName;
            return true;
        }

        boolean IsSubclass(Class theTestClass, Class thePossibleSuper) {
            if (theTestClass == null) {
                return false;
            }
            if (theTestClass.equals(thePossibleSuper)) {
                return true;
            }
            theTestClass = theTestClass.getSuperclass();
            return this.IsSubclass(theTestClass, thePossibleSuper);
        }

        boolean processClassHeaderInformation() {
            Element theCodeGenerator;
            Class theSuperclass = this.theClass.getSuperclass();
            if (theSuperclass != null) {
                Element theSuperclassElement = new Element("Superclass");
                Element theName = new Element("Name");
                Element theFullPath = new Element("FullPath");
                String sSuperClassName = theSuperclass.getName();
                theFullPath.setText(sSuperClassName);
                int iLastDot = sSuperClassName.lastIndexOf(".");
                sSuperClassName = sSuperClassName.substring(iLastDot + 1);
                theName.setText(sSuperClassName);
                this.theRootElement.addElement(theSuperclassElement);
                theSuperclassElement.addElement(theName);
                theSuperclassElement.addElement(theFullPath);
            }
            boolean bIsJAComponent = this.IsSubclass(this.theClass, this.theJAComponentClass);
            boolean bIsJAFrame = this.IsSubclass(this.theClass, this.theJAFrameClass);
            boolean bIsJAPanel = this.IsSubclass(this.theClass, this.theJAPanelClass);
            boolean bIsJATabbedPane = this.IsSubclass(this.theClass, this.theJATabbedPaneClass);
            boolean bIsJAScrollPane = this.IsSubclass(this.theClass, this.theJAScrollPaneClass);
            boolean bIsJAScrollBar = this.IsSubclass(this.theClass, this.theScrollBarClass);
            boolean bIsJASlider = this.IsSubclass(this.theClass, this.theSliderClass);
            boolean bIsJAList = this.IsSubclass(this.theClass, this.theListClass);
            boolean bIsJATextArea = this.IsSubclass(this.theClass, this.theTextAreaClass);
            boolean bIsJARadio = this.IsSubclass(this.theClass, this.theRadioClass);
            boolean bIsJACheckBox = this.IsSubclass(this.theClass, this.theCheckBoxClass);
            boolean bIsJAComboBox = this.IsSubclass(this.theClass, this.theComboBoxClass);
            boolean bIsJATextField = this.IsSubclass(this.theClass, this.theTextFieldClass);
            boolean bIsJALabel = this.IsSubclass(this.theClass, this.theLabelClass);
            if (bIsJAFrame) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("FrameCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theContainerType = new Element("ContainerType");
                theContainerType.setText("frame");
                this.theRootElement.addElement(theContainerType);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("ch.abacus.designcockpit.ide.DesignPanel");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJAScrollPane) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("SwingCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theContainerType = new Element("ContainerType");
                theContainerType.setText("scrollpane");
                this.theRootElement.addElement(theContainerType);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JAPanel");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJAPanel) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("PanelCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theContainerType = new Element("ContainerType");
                theContainerType.setText("panel");
                this.theRootElement.addElement(theContainerType);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JAPanel");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJATabbedPane) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("SwingCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theContainerType = new Element("ContainerType");
                theContainerType.setText("tabbedpane");
                this.theRootElement.addElement(theContainerType);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JATabbedPane");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJAScrollBar) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("ScrollBarCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JAScrollBar");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJASlider) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("SliderCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JASlider");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJAList) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("ListCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JAList");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJATextArea) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("TextAreaCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JATextArea");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJARadio) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("RadioButtonCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JARadioButton");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJACheckBox) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("CheckBoxCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JACheckBox");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJAComboBox) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("ComboBoxCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JAComboBox");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJATextField) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("ControlCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JATextField");
                this.theRootElement.addElement(theDisplayClass);
            } else if (bIsJALabel) {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("ControlCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText("javax.swing.JALabel");
                this.theRootElement.addElement(theDisplayClass);
            } else {
                theCodeGenerator = new Element("Custom");
                theCodeGenerator.setText("SwingCodeGenerator");
                this.theRootElement.addElement(theCodeGenerator);
                Element theDisplayClass = new Element("Display");
                theDisplayClass.setText(this.sClassName);
                this.theRootElement.addElement(theDisplayClass);
            }
            if (IDEImporter.this.compositeCheckbox.isSelected()) {
                Element aCompositeComponent = new Element("CompositeComponent");
                this.theRootElement.addElement(aCompositeComponent);
            }
            return true;
        }

        boolean addMemberData() {
            Field[] theFields = this.theClass.getFields();
            Modifier mod = new Modifier();
            for (int i = 0; i < theFields.length; ++i) {
                Class<?> clsType = theFields[i].getType();
                String sName = theFields[i].getName();
                int iModifiers = theFields[i].getModifiers();
                Element theMemberData = new Element("MemberData");
                Element theName = new Element("Name");
                theName.setText(sName);
                Element theType = new Element("Type");
                theType.setText(clsType.getName());
                theMemberData.addElement(theName);
                theMemberData.addElement(theType);
                if (Modifier.isFinal(iModifiers)) {
                    theMemberData.addElement(new Element("final"));
                }
                if (Modifier.isStatic(iModifiers)) {
                    theMemberData.addElement(new Element("static"));
                }
                this.theRootElement.addElement(theMemberData);
            }
            return true;
        }

        Element createPointPropertyElement(String sPropertyName, Point aPoint) {
            return this.createPointPropertyElement(sPropertyName, aPoint, "x", "y");
        }

        Element createPointPropertyElement(String sPropertyName, Point aPoint, String xLabel, String yLabel) {
            int leftDefault = (int)aPoint.getX();
            int topDefault = (int)aPoint.getY();
            boolean bVisible = true;
            String sClassName = aPoint.getClass().getName();
            String sTypeName = "Class";
            Element theProperty = new Element("Property");
            Element theName = new Element("Name");
            theName.setText(sPropertyName);
            Element theGet = new Element("Get");
            theGet.setText("get" + sPropertyName);
            Element theSet = new Element("Set");
            theSet.setText("set" + sPropertyName);
            Element theClassElement = new Element("Class");
            theClassElement.setText(sClassName != null ? sClassName : sTypeName);
            Element theType = new Element("Type");
            theType.setText(sClassName != null ? "Class" : sTypeName);
            theProperty.addElement(theName);
            theProperty.addElement(theGet);
            theProperty.addElement(theSet);
            theProperty.addElement(theClassElement);
            theProperty.addElement(theType);
            Element subProp = new Element("Property");
            Element subPropName = new Element("Name");
            subPropName.setText(xLabel);
            subProp.addElement(subPropName);
            Element subPropDefaultValue = new Element("DefaultValue");
            subPropDefaultValue.setText(String.valueOf(leftDefault));
            subProp.addElement(subPropDefaultValue);
            if (bVisible) {
                subProp.addElement(new Element("Visible"));
            }
            Element subPropClass = new Element("Class");
            subPropClass.setText("int");
            subProp.addElement(subPropClass);
            Element subPropType = new Element("Type");
            subPropType.setText("Class");
            subProp.addElement(subPropType);
            theProperty.addElement(subProp);
            subProp = new Element("Property");
            subPropName = new Element("Name");
            subPropName.setText(yLabel);
            subProp.addElement(subPropName);
            subPropDefaultValue = new Element("DefaultValue");
            subPropDefaultValue.setText(String.valueOf(topDefault));
            subProp.addElement(subPropDefaultValue);
            if (bVisible) {
                subProp.addElement(new Element("Visible"));
            }
            subPropClass = new Element("Class");
            subPropClass.setText("int");
            subProp.addElement(subPropClass);
            subPropType = new Element("Type");
            subPropType.setText("Class");
            subProp.addElement(subPropType);
            theProperty.addElement(subProp);
            return theProperty;
        }

        Element createDimensionPropertyElement(String sPropertyName, Dimension aPoint) {
            int wDefault = (int)aPoint.getWidth();
            int hDefault = (int)aPoint.getHeight();
            boolean bVisible = true;
            String sClassName = aPoint.getClass().getName();
            String sTypeName = "Class";
            Element theProperty = new Element("Property");
            Element theName = new Element("Name");
            theName.setText(sPropertyName);
            Element theGet = new Element("Get");
            theGet.setText("get" + sPropertyName);
            Element theSet = new Element("Set");
            theSet.setText("set" + sPropertyName);
            Element theClassElement = new Element("Class");
            theClassElement.setText(sClassName != null ? sClassName : sTypeName);
            Element theType = new Element("Type");
            theType.setText(sClassName != null ? "Class" : sTypeName);
            theProperty.addElement(theName);
            theProperty.addElement(theGet);
            theProperty.addElement(theSet);
            theProperty.addElement(theClassElement);
            theProperty.addElement(theType);
            Element subProp = new Element("Property");
            Element subPropName = new Element("Name");
            subPropName.setText("Width");
            subProp.addElement(subPropName);
            Element subPropDefaultValue = new Element("DefaultValue");
            subPropDefaultValue.setText(String.valueOf(wDefault));
            subProp.addElement(subPropDefaultValue);
            if (bVisible) {
                subProp.addElement(new Element("Visible"));
            }
            Element subPropClass = new Element("Class");
            subPropClass.setText("int");
            subProp.addElement(subPropClass);
            Element subPropType = new Element("Type");
            subPropType.setText("Class");
            subProp.addElement(subPropType);
            theProperty.addElement(subProp);
            subProp = new Element("Property");
            subPropName = new Element("Name");
            subPropName.setText("Height");
            subProp.addElement(subPropName);
            subPropDefaultValue = new Element("DefaultValue");
            subPropDefaultValue.setText(String.valueOf(hDefault));
            subProp.addElement(subPropDefaultValue);
            if (bVisible) {
                subProp.addElement(new Element("Visible"));
            }
            subPropClass = new Element("Class");
            subPropClass.setText("int");
            subProp.addElement(subPropClass);
            subPropType = new Element("Type");
            subPropType.setText("Class");
            subProp.addElement(subPropType);
            theProperty.addElement(subProp);
            return theProperty;
        }

        boolean addProperty(String sPropertyName, Object DefaultObjectValue, boolean bVisible, String sClassName, String sTypeName) {
            Element theProperty = null;
            theProperty = DefaultObjectValue instanceof Point && sPropertyName.equalsIgnoreCase("Location") ? this.createPointPropertyElement(sPropertyName, (Point)DefaultObjectValue, "Left", "Top") : (DefaultObjectValue instanceof Point ? this.createPointPropertyElement(sPropertyName, (Point)DefaultObjectValue) : (DefaultObjectValue instanceof Dimension ? this.createDimensionPropertyElement(sPropertyName, (Dimension)DefaultObjectValue) : this.createPropertyElement(sPropertyName, (String)DefaultObjectValue, bVisible, sClassName, sTypeName)));
            if (theProperty == null) {
                return false;
            }
            this.theRootElement.addElement(theProperty);
            return true;
        }

        Element createPropertyElement(String sPropertyName, String sDefaultValue, boolean bVisible, String sClassName, String sTypeName) {
            Element aborder;
            Element theProperty = new Element("Property");
            Element theName = new Element("Name");
            theName.setText(sPropertyName);
            Element theGet = new Element("Get");
            theGet.setText(sClassName != null && sClassName.equals("Boolean") || sTypeName.equals("boolean") ? "is" + sPropertyName : "get" + sPropertyName);
            Element theSet = new Element("Set");
            theSet.setText("set" + sPropertyName);
            Element theClassElement = new Element("Class");
            theClassElement.setText(sClassName != null ? sClassName : sTypeName);
            Element theType = new Element("Type");
            theType.setText(sClassName != null ? "Class" : sTypeName);
            theProperty.addElement(theName);
            theProperty.addElement(theGet);
            theProperty.addElement(theSet);
            theProperty.addElement(theClassElement);
            theProperty.addElement(theType);
            if (sDefaultValue != null) {
                Element theDefaultValue = new Element("DefaultValue");
                theDefaultValue.setText(sDefaultValue);
                theProperty.addElement(theDefaultValue);
            }
            if (bVisible) {
                theProperty.addElement(new Element("Visible"));
            }
            if (sClassName.equals("javax.swing.border.Border") || sTypeName.equals("javax.swing.border.Border")) {
                aborder = new Element("DefaultConstantType");
                aborder.setText("Border");
                theProperty.addElement(aborder);
            } else if (sClassName.equals("java.awt.Font") || sTypeName.equals("java.awt.Font")) {
                aborder = new Element("DefaultConstantType");
                aborder.setText("java.awt.Font");
                theProperty.addElement(aborder);
                aborder = new Element("Helper");
                aborder.setText("ch.abacus.designcockpit.ide.DefaultPropertyHelper");
                theProperty.addElement(aborder);
            } else if (sClassName.equals("java.awt.Color") || sTypeName.equals("java.awt.Color")) {
                aborder = new Element("DefaultConstantType");
                aborder.setText("Color");
                theProperty.addElement(aborder);
                aborder = new Element("Helper");
                aborder.setText("ch.abacus.designcockpit.ide.DefaultPropertyHelper");
                theProperty.addElement(aborder);
            }
            return theProperty;
        }

        boolean isSkippedProperty(String sPropertyName) {
            for (int i = 0; i < this.theSkippedProperties.length; ++i) {
                if (!sPropertyName.equals(this.theSkippedProperties[i])) continue;
                return true;
            }
            return false;
        }

        boolean addDefaultProperties() {
            this.theSkippedProperties = new String[]{"Size", "Location"};
            this.addProperty("Location", new Point(0, 0), true, "java.awt.Point", "Class");
            this.addProperty("Size", new Dimension(80, 22), true, "java.awt.Dimension", "Class");
            return true;
        }

        boolean getBasicType(String sName) {
            int iDot = sName.indexOf(".");
            return iDot == -1;
        }

        String upperCaseFirstLetter(String str) {
            String retStr = str;
            char ch = str.charAt(0);
            if (Character.isLetter(ch)) {
                retStr = Character.valueOf(Character.toUpperCase(ch)).toString() + str.substring(1, str.length());
            }
            return retStr;
        }

        boolean addClassProperties() {
            Object[] selectedProperties = IDEImporter.this.propList.getSelectedValues();
            for (int i = 0; i < selectedProperties.length; ++i) {
                String sPropName = (String)selectedProperties[i];
                if (this.isSkippedProperty(this.upperCaseFirstLetter(sPropName))) continue;
                PropertyDescriptor propDescr = this.getPropertyDescriptor(sPropName);
                Class<?> propClass = propDescr.getPropertyType();
                if (propClass.equals(Boolean.class) || propClass.getName().equals("boolean")) {
                    this.addProperty(this.upperCaseFirstLetter(sPropName), null, true, propClass.getName(), propClass.getName());
                    continue;
                }
                this.addProperty(this.upperCaseFirstLetter(sPropName), null, true, propClass.getName(), "Class");
            }
            return true;
        }

        boolean addClassEvents() {
            return this.addClassEvents(this.theRootElement);
        }

        boolean addClassEvents(Element branchElement) {
            Object[] selectedProperties = IDEImporter.this.eventList.getSelectedValues();
            Element element1 = null;
            if (selectedProperties.length > 0) {
                element1 = new Element("Listeners");
                branchElement.addElement(element1);
            }
            for (int i = 0; i < selectedProperties.length; ++i) {
                String sPropName = (String)selectedProperties[i];
                Element theElement = new Element("Listener");
                theElement.setText(sPropName);
                element1.addChild((Child)theElement);
            }
            return true;
        }

        private PropertyDescriptor getPropertyDescriptor(String sPropName) {
            BeanInfo bi = null;
            try {
                bi = Introspector.getBeanInfo(this.theClass);
            }
            catch (IntrospectionException e) {
                return null;
            }
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int iDescriptor = 0; iDescriptor < pds.length; ++iDescriptor) {
                String propName = pds[iDescriptor].getName();
                if (!propName.equals(sPropName)) continue;
                return pds[iDescriptor];
            }
            return null;
        }

        boolean addClassPropertiesOld() {
            Method[] theMethodList = this.theClass.getMethods();
            for (int i = 0; i < theMethodList.length; ++i) {
                String sMethodName = theMethodList[i].getName();
                if (!sMethodName.startsWith("set")) continue;
                String sRestOfName = sMethodName.substring(3);
                Class<?>[] theParamList = theMethodList[i].getParameterTypes();
                if (theParamList.length != 1) continue;
                Class<?> theExpectedReturnType = theParamList[0];
                try {
                    boolean bIsType;
                    Method m = this.theClass.getMethod("get" + sRestOfName, null);
                    if (this.isSkippedProperty(sRestOfName)) continue;
                    if (m != null) {
                        bIsType = this.getBasicType(theExpectedReturnType.getName());
                        if (bIsType) {
                            this.addProperty(sRestOfName, null, true, null, theExpectedReturnType.getName());
                            continue;
                        }
                        this.addProperty(sRestOfName, null, true, theExpectedReturnType.getName(), "Class");
                        continue;
                    }
                    m = this.theClass.getMethod("is" + sRestOfName, null);
                    bIsType = this.getBasicType(theExpectedReturnType.getName());
                    if (bIsType) {
                        this.addProperty(sRestOfName, null, true, null, theExpectedReturnType.getName());
                        continue;
                    }
                    this.addProperty(sRestOfName, null, true, theExpectedReturnType.getName(), "Class");
                    continue;
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
            }
            return true;
        }

        boolean addClassFields() {
            this.addMemberData();
            return true;
        }
    }

    class CancelListener
    implements ActionListener {
        IDEImporter theImporter = null;

        public CancelListener(IDEImporter objImporter) {
            this.theImporter = objImporter;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theImporter.hide();
        }
    }

    class OKListener
    implements ActionListener {
        IDEImporter theImporter = null;
        SuperDesignCockpit theDesignCockpit = null;

        public OKListener(IDEImporter objImporter, SuperDesignCockpit theDesignCockpit, JTree theJtree) {
            this.theImporter = objImporter;
            this.theDesignCockpit = theDesignCockpit;
            IDEImporter.this.tree = theJtree;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                if (this.theImporter.drivePanel.isVisible()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)IDEImporter.this.tree.getLastSelectedPathComponent();
                    Object oUserObject = node.getUserObject();
                    this.theImporter.setTitle("Class Importer: " + oUserObject.toString());
                    this.theImporter.btnBack.setVisible(true);
                    this.theImporter.btnImport.setLocation(IDEImporter.this.btnImportX, 260);
                    this.theImporter.btnImport.setText("Import");
                    this.theImporter.drivePanel.setVisible(false);
                    this.theImporter.panel2.setVisible(true);
                } else if (this.theImporter.panel2.isVisible() && this.theImporter.Import(this.theDesignCockpit.getDesignProject().theMetaProject)) {
                    this.theImporter.setVisible(false);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e);
            }
        }
    }

    class ClassTree
    extends JATree {
        public ClassTree() {
            this.putClientProperty("JTree.lineStyle", "Angled");
            ((BasicTreeUI)this.getUI()).setRightChildIndent(8);
            ((BasicTreeUI)this.getUI()).setLeftChildIndent(5);
            ((BasicTreeUI)this.getUI()).setExpandedIcon((Icon)new WindowsTreeUI.ExpandedIcon());
            ((BasicTreeUI)this.getUI()).setCollapsedIcon((Icon)new WindowsTreeUI.CollapsedIcon());
            this.setRootVisible(false);
            this.expandAll();
        }

        public void expandAll() {
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.expandRow(row);
            }
        }
    }

    private class ComponentSelectDialog
    extends JDialog {
        public boolean okSelected;

        public ComponentSelectDialog() throws HeadlessException {
            super((Frame)((Object)IDEImporter.this), "Select Component", true);
            this.okSelected = false;
        }
    }

    class BackListener
    implements ActionListener {
        IDEImporter theImporter = null;
        SuperDesignCockpit theDesignCockpit = null;

        public BackListener(IDEImporter objImporter, SuperDesignCockpit theDesignCockpit, JTree theJtree) {
            this.theImporter = objImporter;
            this.theDesignCockpit = theDesignCockpit;
            IDEImporter.this.tree = theJtree;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                this.theImporter.setTitle("Class Importer");
                this.theImporter.btnBack.setVisible(false);
                this.theImporter.btnImport.setLocation(IDEImporter.this.btnNextX, 260);
                this.theImporter.btnImport.setText("Next >>");
                this.theImporter.panel2.setVisible(false);
                this.theImporter.drivePanel.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e);
            }
        }
    }
}

