/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEEditorPopupMenu;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import com.ibm.cf.CodeFormatter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Keymap;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.comedia.text.CAbstractHighlighter;
import org.comedia.text.CJavaHighlighter;
import org.comedia.ui.CSyntaxEditor;

class IDESourceEditorImp
extends CSyntaxEditor {
    SuperDesignCockpit theCockpit;
    Hashtable actions;
    public IDEEditorPopupMenu thePopupMenu = null;
    public static final int UNDO_LIMIT = 1500;
    private UndoManager m_undoManager;

    public IDESourceEditorImp() {
        this.init();
    }

    public IDESourceEditorImp(SuperDesignCockpit objCockpit) {
        this.theCockpit = objCockpit;
        this.init();
    }

    private void init() {
        this.setSyntaxHighlighter((CAbstractHighlighter)new CJavaHighlighter());
        this.createActionTable();
        this.getDocument().addUndoableEditListener((UndoableEditListener)((Object)this));
        this.createUndoMananger();
        this.assignExtraClipboardKeys();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IDESourceEditorImp.this.theCockpit.setLastFocussedComponent((Component)((Object)IDESourceEditorImp.this));
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() instanceof JRootPane) {
                    IDESourceEditorImp.this.theCockpit.setLastFocussedComponent((Component)((Object)IDESourceEditorImp.this));
                } else {
                    IDESourceEditorImp.this.theCockpit.setLastFocussedComponent(null);
                }
            }
        });
    }

    public void setDesignCockpit(SuperDesignCockpit objCockpit) {
        this.theCockpit = objCockpit;
    }

    private void assignExtraClipboardKeys() {
        KeyStroke keyCopy = KeyStroke.getKeyStroke(155, 2, false);
        KeyStroke keyPaste = KeyStroke.getKeyStroke(155, 1, false);
        KeyStroke keyCut = KeyStroke.getKeyStroke(127, 1, false);
        Keymap map = this.getKeymap();
        map.addActionForKeyStroke(keyCopy, this.getActionByName("copy-to-clipboard"));
        map.addActionForKeyStroke(keyPaste, this.getActionByName("paste-from-clipboard"));
        map.addActionForKeyStroke(keyCut, this.getActionByName("cut-to-clipboard"));
    }

    public Container getContainer() {
        return this;
    }

    void setCode(String sText) {
        StringReader theStringReader = new StringReader(sText);
        CodeFormatter theFormatter = new CodeFormatter();
        StringWriter theWriter = new StringWriter(sText.length());
        String sDelims = this.theCockpit.thePreferences.sDelimiters;
        String sStickyDelims = this.theCockpit.thePreferences.sStickyDelimiters;
        int iIndentation = this.theCockpit.thePreferences.iIndentation;
        int iMaxLineLength = this.theCockpit.thePreferences.iMaxLineLength;
        if (sDelims != null) {
            theFormatter.setDelimiters(sDelims);
        }
        if (sStickyDelims != null) {
            theFormatter.setStickyDelimiters(sStickyDelims);
        }
        theFormatter.setIndentationStep(iIndentation);
        if (iMaxLineLength != 0) {
            theFormatter.setMaxLineLength(iMaxLineLength);
        }
        theFormatter.formatCode((Reader)theStringReader, (Writer)theWriter);
        theStringReader = new StringReader(theWriter.getBuffer().toString());
        try {
            this.read(theStringReader, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void createActionTable() {
        this.actions = new Hashtable();
        Action[] actionsArray = this.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            Action a = actionsArray[i];
            String sActionName = (String)a.getValue("Name");
            this.actions.put(sActionName, a);
        }
    }

    public Action getActionByName(String name) {
        return (Action)this.actions.get(name);
    }

    private void createUndoMananger() {
        this.m_undoManager = new UndoManager();
        this.m_undoManager.setLimit(1500);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.m_undoManager.addEdit(e.getEdit());
    }

    public void undo() {
        try {
            this.m_undoManager.undo();
        }
        catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        try {
            this.m_undoManager.redo();
        }
        catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

