/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.JarContentsFilter;
import ch.abacus.designcockpit.ide.JarContentsTreeJarAccess;
import ch.abacus.designcockpit.ide.JarContentsTreeNode;
import ch.abacus.lib.ui.renderer.common.HammerJarAccess;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class JarContentsTree
extends JTree {
    DefaultTreeModel theModel;
    JarContentsTreeNode baseNode;
    JarContentsFilter theFilter;
    String sJarName;

    public JarContentsTree(String sJarName, JarContentsFilter theFilter) {
        this.sJarName = sJarName;
        this.theFilter = theFilter;
        this.baseNode = new JarContentsTreeNode("Jar Projects");
        this.theModel = new DefaultTreeModel(this.baseNode, true);
        this.setModel(this.theModel);
    }

    public boolean load() {
        HashMap<String, JarContentsTreeJarAccess> theMap = new HashMap<String, JarContentsTreeJarAccess>();
        try {
            JarFile jarf = new JarFile(this.sJarName);
            Enumeration<JarEntry> allentries = jarf.entries();
            while (allentries.hasMoreElements()) {
                JarEntry entry = allentries.nextElement();
                String sTestName = entry.getName();
                if (!this.theFilter.checkFile(sTestName)) continue;
                HammerJarAccess theAccess = new HammerJarAccess(jarf, entry);
                JarContentsTreeJarAccess theLink = new JarContentsTreeJarAccess(theAccess, null, sTestName);
                theMap.put(sTestName, theLink);
            }
        }
        catch (IOException e1) {
            return false;
        }
        TreeMap theMatchingEntries = new TreeMap(theMap);
        for (JarContentsTreeJarAccess objStored : theMatchingEntries.values()) {
            this.createNodes(objStored);
        }
        this.repaint();
        return true;
    }

    private JarContentsTreeNode createNode(DefaultMutableTreeNode theNode, JarContentsTreeJarAccess theAccess, String sKey) {
        boolean bAllowsChildren = true;
        JarContentsTreeNode theNewNode = new JarContentsTreeNode(theAccess, bAllowsChildren, sKey);
        this.theModel.insertNodeInto(theNewNode, theNode, theNode.getChildCount());
        return theNewNode;
    }

    private JarContentsTreeNode createNode(DefaultMutableTreeNode theNode, String sKey) {
        JarContentsTreeNode theNewNode = new JarContentsTreeNode(sKey);
        this.theModel.insertNodeInto(theNewNode, theNode, theNode.getChildCount());
        return theNewNode;
    }

    private JarContentsTreeNode findNode(DefaultMutableTreeNode theParent, String sKey) {
        if (theParent.getChildCount() <= 0) {
            return null;
        }
        for (JarContentsTreeNode theChild = (JarContentsTreeNode)this.theModel.getChild(theParent, 0); theChild != null; theChild = (JarContentsTreeNode)theChild.getNextSibling()) {
            String sCompareKey = (String)theChild.getUserObject();
            if (!sCompareKey.equals(sKey)) continue;
            return theChild;
        }
        return null;
    }

    private void createNodes(JarContentsTreeJarAccess nodeInformation) {
        JarContentsTreeNode theNewNode;
        String sKey = nodeInformation.sKey;
        int iIndex = sKey.indexOf("/");
        JarContentsTreeNode theNode = this.baseNode;
        while (iIndex != -1) {
            String sSegment = sKey.substring(0, iIndex);
            JarContentsTreeNode theNewNode2 = this.findNode(theNode, sSegment);
            theNode = theNewNode2 == null ? this.createNode(theNode, sSegment) : theNewNode2;
            sKey = sKey.substring(iIndex + 1);
            iIndex = sKey.indexOf("/");
        }
        if (sKey.length() > 0 && (theNewNode = this.findNode(theNode, sKey)) == null) {
            this.createNode(theNode, nodeInformation, sKey);
        }
    }
}

