/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEArrayValueEditor;
import ch.abacus.designcockpit.ide.PropertyTable;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyTableMouseListener
implements MouseListener {
    PropertyTable thePropertyTable;

    public PropertyTableMouseListener(PropertyTable thePropertyTable) {
        this.thePropertyTable = thePropertyTable;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (this.thePropertyTable.theModel.theMetaObject == null) {
            return;
        }
        Point pt = evt.getPoint();
        int iRow = this.thePropertyTable.rowAtPoint(pt);
        int iCol = this.thePropertyTable.columnAtPoint(pt);
        this.showHelper(iRow, iCol);
    }

    private void showHelper(int iRow, int iCol) {
        MetaPropertyDescriptor theProp;
        String sPropertyName = (String)this.thePropertyTable.getValueAt(iRow, 0);
        int iEqual = sPropertyName.indexOf("=");
        if (iEqual != -1) {
            sPropertyName = sPropertyName.substring(0, iEqual);
        }
        if ((theProp = this.thePropertyTable.theModel.theMetaObject.theClass.getProperty(sPropertyName = sPropertyName.trim(), true)) != null) {
            String sHelperClass = theProp.getHelperClass();
            if (iCol == 0 && sHelperClass != null && sHelperClass.length() > 0) {
                try {
                    Class<?> helperClass = Class.forName(sHelperClass);
                    Constructor<?> helperConstructor = helperClass.getConstructor(null);
                    Object helper = helperConstructor.newInstance(null);
                    Class[] paramClasses = new Class[]{MetaObject.class, String.class, SuperDesignCockpit.class};
                    Method executeMethod = helperClass.getMethod("execute", paramClasses);
                    Object[] paramValues = new Object[]{this.thePropertyTable.theModel.theMetaObject, sPropertyName, this.thePropertyTable.theDesignCockpit};
                    boolean bProjectModified = (Boolean)executeMethod.invoke(helper, paramValues);
                    if (bProjectModified) {
                        this.thePropertyTable.theDesignCockpit.getPropertyInspectorController().refreshPropertyInspector();
                        this.thePropertyTable.theDesignCockpit.theCurrentDesignProject.theMetaProject.setProjectChangedState(true);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else if (theProp.bAllowMultipleValues) {
                if (this.thePropertyTable.theArrayValueEditor != null) {
                    this.thePropertyTable.theArrayValueEditor.close();
                }
                this.thePropertyTable.theArrayValueEditor = new IDEArrayValueEditor(this.thePropertyTable.theModel.theMetaObject, sPropertyName, this.thePropertyTable.theDesignCockpit);
            }
        }
    }

    private void showHelperOrig(int iRow, int iCol) {
        MetaPropertyDescriptor theProp;
        String sPropertyName = (String)this.thePropertyTable.getValueAt(iRow, 0);
        int iEqual = sPropertyName.indexOf("=");
        if (iEqual != -1) {
            sPropertyName = sPropertyName.substring(0, iEqual);
        }
        if ((theProp = this.thePropertyTable.theModel.theMetaObject.theClass.getProperty(sPropertyName = sPropertyName.trim(), true)) != null) {
            String sHelperClass = theProp.getHelperClass();
            if (iCol == 0 && sHelperClass != null && sHelperClass.length() > 0) {
                try {
                    Class<?> theHelperClass = Class.forName(sHelperClass);
                    Class[] theParamClass = new Class[3];
                    Object[] theParamObject = new Object[3];
                    theParamObject[0] = this.thePropertyTable.theModel.theMetaObject;
                    theParamClass[0] = this.thePropertyTable.theModel.theMetaObject.getClass();
                    theParamObject[1] = sPropertyName;
                    theParamClass[1] = sPropertyName.getClass();
                    theParamObject[2] = this.thePropertyTable.theDesignCockpit;
                    theParamClass[2] = SuperDesignCockpit.class;
                    Constructor<?> theConstructor = theHelperClass.getConstructor(theParamClass);
                    theConstructor.newInstance(theParamObject);
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoSuchMethodException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
            } else if (theProp.bAllowMultipleValues) {
                if (this.thePropertyTable.theArrayValueEditor != null) {
                    this.thePropertyTable.theArrayValueEditor.close();
                }
                this.thePropertyTable.theArrayValueEditor = new IDEArrayValueEditor(this.thePropertyTable.theModel.theMetaObject, sPropertyName, this.thePropertyTable.theDesignCockpit);
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }
}

