/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SizeboxMouseListener;
import ch.abacus.designcockpit.ide.SizeboxMouseMotionListener;
import ch.abacus.designcockpit.ide.Sizeboxes;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComponent;

public class Sizebox
extends Box {
    public static final int NORTH = 0;
    public static final int NORTHEAST = 1;
    public static final int EAST = 2;
    public static final int SOUTHEAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHWEST = 5;
    public static final int WEST = 6;
    public static final int NORTHWEST = 7;
    public int theOrientation = 0;
    public MetaObject theMetaObject = null;
    public int width = 4;
    public int height = 4;
    public Point ptDragFrom = null;
    SizeboxMouseMotionListener theMouseMotionListener = null;
    SizeboxMouseListener theMouseListener = null;
    Sizeboxes theController = null;
    public SuperDesignCockpit theDesignCockpit = null;

    public Sizebox(MetaObject objMetaObject, int iOrientation, Sizeboxes objController, SuperDesignCockpit theDesignCockpit) {
        super(0);
        this.theMetaObject = objMetaObject;
        this.theOrientation = iOrientation;
        this.theController = objController;
        this.theMouseListener = new SizeboxMouseListener(this);
        this.theMouseMotionListener = new SizeboxMouseMotionListener(this);
        this.addMouseListener(this.theMouseListener);
        this.addMouseMotionListener(this.theMouseMotionListener);
        this.theDesignCockpit = theDesignCockpit;
        this.setOpaque(true);
    }

    public void kill() {
        if (this.theMouseListener != null) {
            this.theMouseListener.kill();
        }
    }

    public void locate() {
        JComponent theComponent = this.theMetaObject.theVisualObject;
        if (theComponent == null) {
            return;
        }
        Point ptLocation = theComponent.getLocation();
        Dimension dimSize = theComponent.getSize();
        int x = 0;
        int y = 0;
        switch (this.theOrientation) {
            case 0: {
                x = (int)ptLocation.getX() + ((int)dimSize.getWidth() - this.width) / 2;
                y = (int)ptLocation.getY() - this.height;
                break;
            }
            case 1: {
                x = (int)ptLocation.getX() + (int)dimSize.getWidth();
                y = (int)ptLocation.getY() - this.height;
                break;
            }
            case 2: {
                x = (int)ptLocation.getX() + (int)dimSize.getWidth();
                y = (int)ptLocation.getY() + ((int)dimSize.getHeight() - this.height) / 2;
                break;
            }
            case 3: {
                x = (int)ptLocation.getX() + (int)dimSize.getWidth();
                y = (int)ptLocation.getY() + (int)dimSize.getHeight();
                break;
            }
            case 4: {
                x = (int)ptLocation.getX() + ((int)dimSize.getWidth() - this.width) / 2;
                y = (int)ptLocation.getY() + (int)dimSize.getHeight();
                break;
            }
            case 5: {
                x = (int)ptLocation.getX() - this.width;
                y = (int)ptLocation.getY() + (int)dimSize.getHeight();
                break;
            }
            case 6: {
                x = (int)ptLocation.getX() - this.width;
                y = (int)ptLocation.getY() + ((int)dimSize.getHeight() - this.height) / 2;
                break;
            }
            case 7: {
                x = (int)ptLocation.getX() - this.width;
                y = (int)ptLocation.getY() - this.height;
            }
        }
        this.setLocation(x, y);
        this.setSize(this.width, this.height);
    }

    void dragAction(MouseEvent evt) {
        JComponent theComponent = this.theMetaObject.theVisualObject;
        if (theComponent == null) {
            return;
        }
        Point ptLocation = theComponent.getLocation();
        Dimension dimSize = theComponent.getSize();
        Point ptDragTo = evt.getPoint();
        int x = 0;
        int y = 0;
        int cx = 0;
        int cy = 0;
        switch (this.theOrientation) {
            case 0: {
                x = (int)ptLocation.getX();
                y = (int)ptLocation.getY() - (int)this.ptDragFrom.getY() + (int)ptDragTo.getY();
                cx = (int)dimSize.getWidth();
                cy = (int)dimSize.getHeight() + (int)(this.ptDragFrom.getY() - ptDragTo.getY());
                break;
            }
            case 1: {
                x = (int)ptLocation.getX() - (int)this.ptDragFrom.getX() + (int)ptDragTo.getX();
                y = (int)ptLocation.getY() - (int)this.ptDragFrom.getY() + (int)ptDragTo.getY();
                cx = (int)dimSize.getWidth() + (int)(ptDragTo.getX() - this.ptDragFrom.getX());
                cy = (int)dimSize.getHeight() + (int)(this.ptDragFrom.getY() - ptDragTo.getY());
                break;
            }
            case 2: {
                x = (int)ptLocation.getX();
                y = (int)ptLocation.getY();
                cx = (int)dimSize.getWidth() + (int)(ptDragTo.getX() - this.ptDragFrom.getX());
                cy = (int)dimSize.getHeight();
                break;
            }
            case 3: {
                x = (int)ptLocation.getX();
                y = (int)ptLocation.getY();
                cx = (int)dimSize.getWidth() + (int)(ptDragTo.getX() - this.ptDragFrom.getX());
                cy = (int)dimSize.getHeight() + (int)(ptDragTo.getY() - this.ptDragFrom.getY());
                break;
            }
            case 4: {
                x = (int)ptLocation.getX();
                y = (int)ptLocation.getY();
                cx = (int)dimSize.getWidth();
                cy = (int)dimSize.getHeight() + (int)(ptDragTo.getY() - this.ptDragFrom.getY());
                break;
            }
            case 5: {
                x = (int)ptLocation.getX() + (int)(ptDragTo.getX() - this.ptDragFrom.getX());
                y = (int)ptLocation.getY();
                cx = (int)dimSize.getWidth() + (int)(this.ptDragFrom.getX() - ptDragTo.getX());
                cy = (int)dimSize.getHeight() + (int)(ptDragTo.getY() - this.ptDragFrom.getY());
                break;
            }
            case 6: {
                x = (int)ptLocation.getX() + (int)(ptDragTo.getX() - this.ptDragFrom.getX());
                y = (int)ptLocation.getY();
                cx = (int)dimSize.getWidth() + (int)(this.ptDragFrom.getX() - ptDragTo.getX());
                cy = (int)dimSize.getHeight();
                break;
            }
            case 7: {
                x = (int)ptLocation.getX() - (int)this.ptDragFrom.getX() + (int)ptDragTo.getX();
                y = (int)ptLocation.getY() - (int)this.ptDragFrom.getY() + (int)ptDragTo.getY();
                cx = (int)dimSize.getWidth() + (int)(this.ptDragFrom.getX() - ptDragTo.getX());
                cy = (int)dimSize.getHeight() + (int)(this.ptDragFrom.getY() - ptDragTo.getY());
            }
        }
        if (!this.theController.theMetaObject.bResizing) {
            this.beginResizing(this.theMetaObject);
        }
        this.theController.relocate(x, y, cx, cy, true, true, true);
    }

    public void paint(Graphics g) {
        g.setColor(new Color(0, 0, 0));
        g.fillRect(0, 0, this.width, this.height);
    }

    void beginResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = true;
        this.theDesignCockpit.getDesignProject().theUndoRedoController.createChangeSizeEvent(theMetaObject);
    }

    void beginDragging(MetaObject theMetaObject) {
        int iSelectedObjectCount = this.theDesignCockpit.getDesignProject().getSelectedObjectCount();
        ArrayList<MetaObject> theObjects = new ArrayList<MetaObject>(iSelectedObjectCount);
        for (int i = 0; i < iSelectedObjectCount; ++i) {
            theObjects.add(this.theDesignCockpit.getDesignProject().getSelectedObject(i));
        }
        this.theDesignCockpit.getDesignProject().theUndoRedoController.createChangeLocationEvent(theObjects);
        theMetaObject.bDragged = true;
    }

    void endResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = false;
    }

    void endDragging(MetaObject theMetaObject) {
        theMetaObject.bDragged = false;
    }

    boolean isResizingHorizontal() {
        return this.theOrientation != 0 && this.theOrientation != 4;
    }

    boolean isResizingVertical() {
        return this.theOrientation != 6 && this.theOrientation != 2;
    }
}

