/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide.languages;

import ch.abacus.lib.ui.JAFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;

public class VerifyLanguageFiles
extends JAFrame {
    ResourceBundle theFirstBundle = null;
    ResourceBundle theSecondBundle = null;
    boolean bError = false;
    String sDirLanguageFile = null;

    public VerifyLanguageFiles() {
        this.addWindowListener(new CloseWindow());
    }

    public void verify() {
        this.processFiles();
        if (this.bError) {
            System.out.println("\n***ERRORS WERE FOUND ***");
        } else {
            System.out.println("\nEveything ok");
        }
    }

    private boolean hasSameKeys() {
        boolean bErrors = false;
        HashSet<String> firstSet = new HashSet<String>();
        Enumeration<String> firstBundleKeys = this.theFirstBundle.getKeys();
        while (firstBundleKeys.hasMoreElements()) {
            String sKey = firstBundleKeys.nextElement();
            firstSet.add(sKey);
        }
        Enumeration<String> secondBundleKeys = this.theSecondBundle.getKeys();
        while (secondBundleKeys.hasMoreElements()) {
            String sKey = secondBundleKeys.nextElement();
            if (firstSet.contains(sKey)) {
                firstSet.remove(sKey);
                continue;
            }
            System.out.println("Error: The \"" + sKey + "\" key in the German file is missing in the English file");
            bErrors = true;
        }
        for (String sKey : firstSet) {
            System.out.println("Error: The \"" + sKey + "\" key in the English file is missing in the German file");
            bErrors = true;
        }
        return bErrors;
    }

    private boolean hasSameStrings() {
        boolean bErrors = false;
        Enumeration<String> firstBundleKeys = this.theFirstBundle.getKeys();
        while (firstBundleKeys.hasMoreElements()) {
            String sKey = firstBundleKeys.nextElement();
            try {
                String sValue = this.theFirstBundle.getString(sKey);
                String sSecondValue = this.theSecondBundle.getString(sKey);
                if (sValue.equals(sSecondValue)) {
                    if (sKey.endsWith(".image") || sKey.endsWith(".mnemonic") || sKey.endsWith(".accelerator")) continue;
                    System.out.println("Warning: The \"" + sKey + "\" key has the same value of \"" + sValue + "\" in both language files");
                    continue;
                }
                if (!sKey.endsWith(".image")) continue;
                System.out.println("Warning: The \"" + sKey + "\" key has a value of \"" + sValue + "\" in the English file, but \"" + sSecondValue + "\" in the German file");
            }
            catch (MissingResourceException e) {}
        }
        return bErrors;
    }

    private boolean hasValidMnemonics() {
        boolean bErrors = false;
        Enumeration<String> firstBundleKeys = this.theFirstBundle.getKeys();
        while (firstBundleKeys.hasMoreElements()) {
            String sKey = firstBundleKeys.nextElement();
            try {
                if (!sKey.endsWith(".mnemonic")) continue;
                String sFirstMnemonic = this.theFirstBundle.getString(sKey);
                String sLabelKey = sKey.substring(0, sKey.lastIndexOf(".mnemonic")) + ".label";
                String sFirstLabel = null;
                try {
                    sFirstLabel = this.theFirstBundle.getString(sLabelKey);
                    if (sFirstLabel.toUpperCase().indexOf(sFirstMnemonic) == -1) {
                        System.out.println("Error (English File): The mnemonic of the key \"" + sKey + "\" (Value =\"" + sFirstMnemonic + "\") is not contained in the associated label, \"" + sLabelKey + "\" (Value = \"" + sFirstLabel + "\")");
                        bErrors = true;
                    }
                }
                catch (MissingResourceException e) {
                    System.out.println("Error (English File): The key \"" + sKey + "\" does not have an associated \"" + sLabelKey + "\" key");
                    bErrors = true;
                }
                String sSecondMnemonic = this.theSecondBundle.getString(sKey);
                String sSecondLabel = null;
                try {
                    sSecondLabel = this.theSecondBundle.getString(sLabelKey);
                    if (sSecondLabel.toUpperCase().indexOf(sSecondMnemonic) != -1) continue;
                    System.out.println("Error (German File): The mnemonic of the key \"" + sKey + "\" (Value =\"" + sSecondMnemonic + "\") is not contained in the associated label, \"" + sLabelKey + "\" (Value = \"" + sSecondLabel + "\")");
                    bErrors = true;
                }
                catch (MissingResourceException e) {
                    System.out.println("Error (German File): The key \"" + sKey + "\" does not have an associated \"" + sLabelKey + "\" key");
                    bErrors = true;
                }
            }
            catch (MissingResourceException e) {}
        }
        return bErrors;
    }

    private void processFiles() {
        System.out.println("Examining the Action files...");
        String sBundleName = this.sDirLanguageFile;
        sBundleName = sBundleName + "actions";
        try {
            this.theFirstBundle = ResourceBundle.getBundle(sBundleName, new Locale("en", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find actions_en (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        try {
            this.theSecondBundle = ResourceBundle.getBundle(sBundleName, new Locale("de", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find actions_de (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        boolean bTestError = this.hasSameKeys();
        if (bTestError) {
            this.bError = true;
        }
        if (bTestError = this.hasSameStrings()) {
            this.bError = true;
        }
        if (bTestError = this.hasValidMnemonics()) {
            this.bError = true;
        }
        System.out.println("\nExamining the Frame Components files...");
        sBundleName = this.sDirLanguageFile;
        sBundleName = sBundleName + "frameComponents";
        try {
            this.theFirstBundle = ResourceBundle.getBundle(sBundleName, new Locale("en", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find frameComponents_en (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        try {
            this.theSecondBundle = ResourceBundle.getBundle(sBundleName, new Locale("de", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find frameComponents_de (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        bTestError = this.hasSameKeys();
        if (bTestError) {
            this.bError = true;
        }
        if (bTestError = this.hasSameStrings()) {
            this.bError = true;
        }
        if (bTestError = this.hasValidMnemonics()) {
            this.bError = true;
        }
        System.out.println("\nExamining the Dialog files...");
        sBundleName = this.sDirLanguageFile;
        sBundleName = sBundleName + "dialogs";
        try {
            this.theFirstBundle = ResourceBundle.getBundle(sBundleName, new Locale("en", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find dialogs_en (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        try {
            this.theSecondBundle = ResourceBundle.getBundle(sBundleName, new Locale("de", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find dialogs_de (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        bTestError = this.hasSameKeys();
        if (bTestError) {
            this.bError = true;
        }
        if (bTestError = this.hasSameStrings()) {
            this.bError = true;
        }
        if (bTestError = this.hasValidMnemonics()) {
            this.bError = true;
        }
        System.out.println("\nExamining the Error-Message files...");
        sBundleName = this.sDirLanguageFile;
        sBundleName = sBundleName + "errors";
        try {
            this.theFirstBundle = ResourceBundle.getBundle(sBundleName, new Locale("en", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find errors_en (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        try {
            this.theSecondBundle = ResourceBundle.getBundle(sBundleName, new Locale("de", "", ""));
        }
        catch (MissingResourceException e) {
            System.out.println("Could not find errors_de (Using path: " + this.sDirLanguageFile + ")");
            System.exit(2);
        }
        bTestError = this.hasSameKeys();
        if (bTestError) {
            this.bError = true;
        }
        if (bTestError = this.hasSameStrings()) {
            this.bError = true;
        }
        if (bTestError = this.hasValidMnemonics()) {
            this.bError = true;
        }
    }

    File pickLanguageFile(JFileChooser chooser, String sLabel) {
        chooser.setDialogTitle(sLabel);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static void main(String[] args) {
        VerifyLanguageFiles verifyLanguageFiles = new VerifyLanguageFiles();
        if (args.length > 0) {
            String sPath = args[0];
            if (!sPath.endsWith(File.separator)) {
                sPath = sPath + File.separator;
            }
            verifyLanguageFiles.sDirLanguageFile = sPath;
        } else {
            System.out.println("Cannot continue. You must pass the path containing the files (this path must be in the Class Path)");
        }
        verifyLanguageFiles.verify();
    }

    private class CloseWindow
    extends WindowAdapter {
        private CloseWindow() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

