/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.designcockpit.ide.DesignProject;
import ch.abacus.designcockpit.ide.IDEPropertyInspectorController;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.designcockpit.ide.propertyinspector.PropertyRegistry;
import ch.abacus.lib.ui.propertyinspector.core.Group;
import ch.abacus.lib.ui.propertyinspector.core.Groups;
import ch.abacus.lib.ui.propertyinspector.core.Property;
import ch.abacus.lib.ui.propertyinspector.display.PropertyEditorEvent;
import ch.abacus.lib.ui.propertyinspector.display.PropertyEditorInterface;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import java.util.HashMap;

public class PropertyFactory {
    private HashMap<SimpleProperty, Property> m_properties;
    private HashMap<String, Group> m_groups;
    private PropertyRegistry m_propertyRegistry;
    private final IDEPropertyInspectorController m_idePropertyInspectorController;
    private final SuperDesignCockpit m_cockpit;
    private MyPropertyEditorInterface m_myPropertyEditorInterface;

    public PropertyFactory(PropertyRegistry propertyRegistry, IDEPropertyInspectorController idePropertyInspectorController) {
        this.m_propertyRegistry = propertyRegistry;
        this.m_idePropertyInspectorController = idePropertyInspectorController;
        this.m_cockpit = idePropertyInspectorController.getSuperDesignCockpit();
        this.m_properties = new HashMap();
        this.m_groups = new HashMap();
        this.m_myPropertyEditorInterface = new MyPropertyEditorInterface();
    }

    private Property createObjectReferenceProperty(String sFullName, String sName, String sHint, String sGroup, String sType, String sConstants, boolean bSingleSelection, boolean bReadOnly, boolean bHelper, boolean bObjectRef) {
        SimpleProperty simpleProperty = new SimpleProperty(sName, sType, null);
        Property property = this.m_properties.get(simpleProperty);
        Group group = this.getGroup(sGroup);
        PropertyValueEditorInterface editor = this.m_propertyRegistry.getEditor(sName, null);
        if (property == null) {
            property = new Property((Enum)PropertyIds.Dummy, sName, sHint, group, this.m_propertyRegistry.getRenderer(sType, sConstants), editor, (PropertyEditorInterface)this.m_myPropertyEditorInterface);
            property.setData((Object)sFullName);
            this.m_properties.put(simpleProperty, property);
        }
        return property;
    }

    private Property createObjectDataAwareProperty(String sFullName, String sName, String sHint, String sGroup, String sType, String sConstants, boolean bSingleSelection, boolean bReadOnly, boolean bHelper, boolean bObjectDataAware) {
        SimpleProperty simpleProperty = new SimpleProperty(sName, sType, null);
        Property property = this.m_properties.get(simpleProperty);
        Group group = this.getGroup(sGroup);
        PropertyValueEditorInterface editor = this.m_propertyRegistry.getEditor(sName, null);
        if (property == null) {
            property = new Property((Enum)PropertyIds.Dummy, sName, sHint, group, this.m_propertyRegistry.getRenderer(sType, sConstants), editor, (PropertyEditorInterface)this.m_myPropertyEditorInterface);
            if (bSingleSelection) {
                property.setSingleSelection(true);
            }
            property.setData((Object)sFullName);
            this.m_properties.put(simpleProperty, property);
        }
        return property;
    }

    private Property getProperty(String sFullName, String sName, String sHint, String sGroup, String sType, String sConstants, boolean bSingleSelection, boolean bReadOnly, boolean bHelper) {
        SimpleProperty simpleProperty = new SimpleProperty(sFullName, sType, sConstants);
        Property property = this.m_properties.get(simpleProperty);
        if (property == null) {
            Group group = this.getGroup(sGroup);
            PropertyValueEditorInterface editor = this.m_propertyRegistry.getEditor(sType, sConstants);
            property = new Property((Enum)PropertyIds.Dummy, sName, sHint, group, this.m_propertyRegistry.getRenderer(sType, sConstants), editor, (PropertyEditorInterface)this.m_myPropertyEditorInterface);
            if (bSingleSelection) {
                property.setSingleSelection(true);
            }
            if (bReadOnly) {
                if (this.m_cockpit.isCustomizing() && bHelper) {
                    property.setValueEditorReadOnly(true);
                } else {
                    property.setReadOnly(true);
                }
            }
            property.setData((Object)sFullName);
            this.m_properties.put(simpleProperty, property);
        }
        return property;
    }

    public Property getProperty(MetaPropertyDescriptor metaPropertyDescriptor) {
        String sFullName = this.getFullPropertyName(metaPropertyDescriptor);
        String sName = this.getPropertyName(metaPropertyDescriptor);
        String sGroup = this.getGroupFromName(sFullName);
        String sHint = null;
        String sType = metaPropertyDescriptor.getClassName();
        String sConstants = metaPropertyDescriptor.getIncludeTypeConstants();
        boolean bSingleSelect = sName.equalsIgnoreCase("Name");
        boolean bReadOnly = metaPropertyDescriptor.isReadOnly();
        boolean bObjectRef = metaPropertyDescriptor.bObjectReference;
        boolean bObjectPromptList = metaPropertyDescriptor.bObjectPromptList;
        boolean bDataAwarePromptList = metaPropertyDescriptor.getDataAwareness();
        String sHelperClass = metaPropertyDescriptor.getHelperClass();
        boolean bHelper = sHelperClass != null && sHelperClass.length() > 0;
        Property passProp = null;
        passProp = metaPropertyDescriptor.bObjectReference ? this.createObjectReferenceProperty(sFullName, sName, sHint, sGroup, sType, sConstants, bSingleSelect, bReadOnly, bHelper, bObjectRef) : (metaPropertyDescriptor.getDataAwareness() ? this.createObjectDataAwareProperty(sFullName, sName, sHint, sGroup, sType, sConstants, bSingleSelect, bReadOnly, bHelper, bDataAwarePromptList) : this.getProperty(sFullName, sName, sHint, sGroup, sType, sConstants, bSingleSelect, bReadOnly, bHelper));
        return passProp;
    }

    private String getGroupFromName(String sName) {
        String sGroup = "General";
        int iIndex = sName.lastIndexOf(46);
        if (iIndex > 0) {
            sGroup = sName.substring(0, iIndex);
        }
        return sGroup;
    }

    private String getFullPropertyName(MetaPropertyDescriptor metaPropertyDescriptor) {
        String sName = metaPropertyDescriptor.getName();
        while ((metaPropertyDescriptor = metaPropertyDescriptor.theSuperProperty) != null) {
            sName = metaPropertyDescriptor.getName() + "." + sName;
        }
        return sName;
    }

    private String getPropertyName(MetaPropertyDescriptor metaPropertyDescriptor) {
        String sName = metaPropertyDescriptor.getName();
        return sName;
    }

    private Group getGroup(String sGroup) {
        Group group = this.m_groups.get(sGroup);
        if (group == null) {
            String[] sGroups = sGroup.split("\\.");
            if (sGroups.length == 1) {
                group = new Group(null, sGroup, null, null);
                this.m_groups.put(sGroup, group);
            } else {
                Group parentGroup = this.getGroup(sGroups[0]);
                Groups groups = parentGroup.getGroups();
                for (int iGroup = 0; iGroup < groups.size(); ++iGroup) {
                    Group childGroup = groups.get(iGroup);
                    if (!childGroup.getName().equals(sGroups[1])) continue;
                    return childGroup;
                }
                group = new Group(parentGroup, sGroups[1], null, null);
            }
        }
        return group;
    }

    private class SimpleProperty {
        private String m_name;
        private String m_type;
        private String m_constants;

        public SimpleProperty(String sName, String sType, String sConstants) {
            this.m_name = sName;
            this.m_type = sType;
            this.m_constants = sConstants;
        }

        public boolean equals(Object obj) {
            boolean bSame;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleProperty other = (SimpleProperty)obj;
            boolean bl = bSame = this.m_name.equals(other.m_name) && this.m_type.equals(other.m_type);
            if (bSame) {
                bSame = this.m_constants == null ? other.m_constants == null : this.m_constants.equals(other.m_constants);
            }
            return bSame;
        }

        public int hashCode() {
            int iHashCode = 7 * this.m_name.hashCode() + 11 * this.m_type.hashCode();
            if (this.m_constants != null) {
                iHashCode += 13 * this.m_constants.hashCode();
            }
            return iHashCode;
        }

        public String toString() {
            return this.m_name + " " + this.m_type + " " + this.m_constants;
        }
    }

    private class MyPropertyEditorInterface
    implements PropertyEditorInterface {
        private MyPropertyEditorInterface() {
        }

        public void edit(PropertyEditorEvent event) {
            DesignProject designProject = PropertyFactory.this.m_cockpit.getDesignProject();
            Property property = event.getDisplayProperty().getProperty();
            MetaObject mo = designProject.getSelectedObject();
            PropertyFactory.this.m_idePropertyInspectorController.showHelper(mo, (String)property.getData());
        }

        public boolean isVisible(Property property) {
            DesignProject designProject = PropertyFactory.this.m_cockpit.getDesignProject();
            if (designProject.getSelectedObjectCount() > 1) {
                return false;
            }
            MetaObject metaObject = designProject.getSelectedObject();
            if (metaObject != null) {
                MetaPropertyDescriptor theProp = metaObject.theClass.getProperty((String)property.getData(), true);
                return theProp.getHelperClass() != null && theProp.getHelperClass().length() > 0;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyIds {
        Dummy;

    }
}

