/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.AboutDialog;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class ActionManager {
    private final MetadataEditor theEditor;
    private AboutAction aboutAction;
    private SaveAction saveAction;
    private ExitAction exitAction;

    public ActionManager(MetadataEditor editor) {
        this.theEditor = editor;
        this.initializeActions();
    }

    private void initializeActions() {
        ActionInitializer initializer = new ActionInitializer();
        this.aboutAction = initializer.initAboutAction();
        this.saveAction = initializer.initSaveAction();
        this.exitAction = initializer.initExitAction();
    }

    public AboutAction getAboutAction() {
        return this.aboutAction;
    }

    public SaveAction getSaveAction() {
        return this.saveAction;
    }

    public ExitAction getExitAction() {
        return this.exitAction;
    }

    class ActionDescription {
        private String theLabel;
        private char theMnemonic;
        private KeyStroke theAccelerator;
        private String theImageName;
        private String theTooltip;

        ActionDescription() {
        }

        public String getLabel() {
            return this.theLabel;
        }

        public void setLabel(String theLabel) {
            this.theLabel = theLabel;
        }

        public char getMnemonic() {
            return this.theMnemonic;
        }

        public void setMnemonic(char mnemonic) {
            this.theMnemonic = mnemonic;
        }

        public KeyStroke getAccelerator() {
            return this.theAccelerator;
        }

        public void setAccelerator(String sAccelerator) {
            this.theAccelerator = KeyStroke.getKeyStroke(sAccelerator);
        }

        public void setAccelerator(KeyStroke keyStroke) {
            this.theAccelerator = keyStroke;
        }

        public String getImageName() {
            return this.theImageName;
        }

        public void setImageName(String theImageName) {
            this.theImageName = theImageName;
        }

        public String getTooltip() {
            return this.theTooltip;
        }

        public void setTooltip(String theTooltip) {
            this.theTooltip = theTooltip;
        }
    }

    private class ActionInitializer {
        private ActionInitializer() {
        }

        ExitAction initExitAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Exit");
            actionDescription.setMnemonic('X');
            actionDescription.setTooltip("Exits the program");
            return new ExitAction(actionDescription);
        }

        SaveAction initSaveAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Save");
            actionDescription.setMnemonic('S');
            actionDescription.setAccelerator("ctrl S");
            actionDescription.setTooltip("Save Metadata");
            return new SaveAction(actionDescription);
        }

        AboutAction initAboutAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("About");
            actionDescription.setMnemonic('A');
            return new AboutAction(actionDescription);
        }
    }

    class ExitAction
    extends InterfaceAction {
        public ExitAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            ActionManager.this.theEditor.exitApplication();
        }
    }

    class SaveAction
    extends InterfaceAction {
        public SaveAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            ActionManager.this.theEditor.saveMetadata();
        }
    }

    class AboutAction
    extends InterfaceAction {
        public AboutAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            AboutDialog dialog = new AboutDialog(ActionManager.this.theEditor);
            dialog.show(null);
        }
    }

    private abstract class InterfaceAction
    extends AbstractAction {
        public InterfaceAction(String sLabel, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(sLabel);
            if (mnemonic != '\u0000') {
                this.setMnemonicKey(mnemonic);
            }
            if (sDescription != null && sDescription.length() > 0) {
                this.setShortDescription(sDescription);
            }
            if (keyStroke != null) {
                this.setAcceleratorKey(keyStroke);
            }
        }

        public InterfaceAction(ActionDescription desc) {
            this(desc.getLabel(), desc.getMnemonic(), desc.getAccelerator(), desc.getImageName(), desc.getTooltip());
        }

        private void setMnemonicKey(char mnemonic) {
            this.putValue("MnemonicKey", new Integer(mnemonic));
        }

        private void setShortDescription(String sDescription) {
            this.putValue("ShortDescription", sDescription);
        }

        protected void setAcceleratorKey(KeyStroke keyStroke) {
            this.putValue("AcceleratorKey", keyStroke);
        }

        public String getLabel() {
            return (String)this.getValue("Name");
        }

        public char getMnemonicKey() {
            return (char)((Integer)this.getValue("MnemonicKey")).intValue();
        }
    }
}

