/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.BufferedAction;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageConstants;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ManageConstantGroupsDialog
extends JDialog {
    final MetadataEditor editor;
    JAList lstGroups = null;
    ArrayList bufferedActionCollection = new ArrayList();
    ManageConstantGroupsDialog thisObject;

    public ManageConstantGroupsDialog(MetadataEditorPageConstants pageConstants, String sCaption, String sGroupTitle) {
        super((Frame)((Object)pageConstants.editor), sCaption, true);
        this.lstGroups = new JAList();
        this.editor = pageConstants.editor;
        this.initDisplay(sGroupTitle, (JComponent)this.lstGroups);
        this.displayGroups(this.getGroups(), (String)pageConstants.lstGroups.getSelectedValue());
        this.thisObject = this;
    }

    private void initDisplay(String sCaption, JComponent list) {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlConstants = new JAPanel((LayoutManager)new BorderLayout());
        pnlConstants.setBorder((Border)BorderFactory.createTitledBorder(sCaption));
        pnlConstants.add((Component)new JScrollPane(list), (Object)"Center");
        JAButton btnAdd = new JAButton("Add");
        JAButton btnRename = new JAButton("Rename");
        JAButton btnDelete = new JAButton("Delete");
        btnAdd.addActionListener((ActionListener)new AddGroupAction(this));
        btnRename.addActionListener((ActionListener)new RenameGroupAction(this));
        btnDelete.addActionListener((ActionListener)new DeleteGroupAction(this));
        JAPanel pnlButtons = new JAPanel((LayoutManager)new FlowLayout(0, 5, 5));
        pnlButtons.add((Component)btnAdd);
        pnlButtons.add((Component)btnRename);
        pnlButtons.add((Component)btnDelete);
        pnlConstants.add((Component)pnlButtons, (Object)"South");
        pane.add((Component)pnlConstants, "Center");
        JAPanel pnlDialogButtons = new JAPanel((LayoutManager)new FlowLayout(2, 5, 5));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener((ActionListener)new OkAction(this));
        btnCancel.addActionListener((ActionListener)new CancelAction(this));
        pnlDialogButtons.add((Component)btnOK);
        pnlDialogButtons.add((Component)btnCancel);
        pane.add((Component)pnlDialogButtons, "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageConstantGroupsDialog.this.thisObject);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    Object[] getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        MetaConstantGroup group = this.editor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            groups.add(group.sClassName);
            group = group.theNextSibling;
        }
        return groups.toArray();
    }

    void displayGroups(Object[] groups, String selectedGroup) {
        this.lstGroups.setListData(groups);
        if (selectedGroup != null) {
            this.lstGroups.setSelectedValue((Object)selectedGroup, true);
        } else if (this.lstGroups.getModel().getSize() > 0) {
            this.lstGroups.setSelectedIndex(0);
        }
    }

    class OkAction
    implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public OkAction(ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            MetadataDispenser theMetadataDispenser = this.dialog.editor.theMetadataDispenser;
            if (this.dialog.bufferedActionCollection.size() == 0) {
                return;
            }
            block5: for (int iAction = 0; iAction < this.dialog.bufferedActionCollection.size(); ++iAction) {
                BufferedAction bufferedAction = (BufferedAction)this.dialog.bufferedActionCollection.get(iAction);
                switch (bufferedAction.getActionType()) {
                    case 1: {
                        MetaConstantGroup group = theMetadataDispenser.findConstantGroup(bufferedAction.getOldName());
                        if (group != null) {
                            group.sClassName = bufferedAction.getNewName();
                            continue block5;
                        }
                        System.out.println("Cannot Rename Group " + bufferedAction.getOldName() + ", as it cannot be found");
                        continue block5;
                    }
                    case 3: {
                        MetaConstantGroup group = new MetaConstantGroup(bufferedAction.getNewName(), theMetadataDispenser);
                        MetaConstantGroup theLastGroup = theMetadataDispenser.getLastMetaConstantGroup();
                        if (theLastGroup == null) {
                            theMetadataDispenser.setFirstMetaConstantGroup(group);
                        } else {
                            theLastGroup.theNextSibling = group;
                            group.thePrevSibling = theLastGroup;
                        }
                        theMetadataDispenser.setLastMetaConstantGroup(group);
                        continue block5;
                    }
                    case 2: {
                        MetaConstantGroup group = theMetadataDispenser.findConstantGroup(bufferedAction.getOldName());
                        if (group != null) {
                            MetaConstantGroup theFirstGroup = theMetadataDispenser.getFirstMetaConstantGroup();
                            MetaConstantGroup theLastGroup = theMetadataDispenser.getLastMetaConstantGroup();
                            if (group == theFirstGroup) {
                                theMetadataDispenser.setFirstMetaConstantGroup(theFirstGroup.theNextSibling);
                                if (theFirstGroup != theLastGroup) {
                                    theMetadataDispenser.getFirstMetaConstantGroup().thePrevSibling = null;
                                } else {
                                    theMetadataDispenser.setLastMetaConstantGroup(null);
                                }
                            } else if (group == theLastGroup) {
                                theMetadataDispenser.setLastMetaConstantGroup(theLastGroup.thePrevSibling);
                                theMetadataDispenser.getLastMetaConstantGroup().theNextSibling = null;
                            } else {
                                group.thePrevSibling.theNextSibling = group.theNextSibling;
                                group.theNextSibling.thePrevSibling = group.thePrevSibling;
                            }
                            group.removeGroupFromCollections();
                            continue block5;
                        }
                        System.out.println("Cannot Delete Group \"" + bufferedAction.getOldName() + "\", as it cannot be found");
                        continue block5;
                    }
                }
            }
            this.dialog.hide();
        }
    }

    class CancelAction
    implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public CancelAction(ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog.bufferedActionCollection.size() > 0) {
                String sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = 0;
                int messageType = 3;
                int iChoice = JOptionPane.showConfirmDialog(this.dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == 0) {
                    this.dialog.hide();
                }
            } else {
                ManageConstantGroupsDialog.this.hide();
            }
        }
    }

    class DeleteGroupAction
    implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public DeleteGroupAction(ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            int messageType;
            int optionType;
            String sConfirmationTitle;
            int iSelectedIndex = this.dialog.lstGroups.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(this.dialog, "You must select a group before you can delete it.", "No Group Selected", 0);
                return;
            }
            String sOldName = (String)this.dialog.lstGroups.getSelectedValue();
            String sConfirmationText = "Are you sure you want to delete the group  \"" + sOldName + "\" ?";
            int iChoice = JOptionPane.showConfirmDialog(this.dialog, sConfirmationText, sConfirmationTitle = "Delete Constant Group", optionType = 0, messageType = 3);
            if (iChoice == 0) {
                this.addBufferedAction(sOldName);
                int iNumNames = this.dialog.lstGroups.getModel().getSize();
                Object[] names = new String[iNumNames - 1];
                int iName = 0;
                for (int iLoop = 0; iLoop < iNumNames; ++iLoop) {
                    if (iLoop == iSelectedIndex) continue;
                    names[iName] = (String)this.dialog.lstGroups.getModel().getElementAt(iLoop);
                    ++iName;
                }
                String sGroupToSelect = null;
                if (iSelectedIndex != iNumNames - 1) {
                    sGroupToSelect = (String)this.dialog.lstGroups.getModel().getElementAt(iSelectedIndex + 1);
                }
                ManageConstantGroupsDialog.this.displayGroups(names, sGroupToSelect);
            }
        }

        void addBufferedAction(String sOldName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionDelete(sOldName);
            ManageConstantGroupsDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }

    class AddGroupAction
    implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public AddGroupAction(ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            String sNewName = JOptionPane.showInputDialog("Add New Group:");
            if (sNewName != null) {
                this.addBufferedAction(sNewName);
                int iNumNames = this.dialog.lstGroups.getModel().getSize();
                Object[] names = new String[iNumNames + 1];
                for (int iName = 0; iName < iNumNames; ++iName) {
                    names[iName] = (String)this.dialog.lstGroups.getModel().getElementAt(iName);
                }
                names[iNumNames] = sNewName;
                ManageConstantGroupsDialog.this.displayGroups(names, sNewName);
            }
        }

        void addBufferedAction(String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionAdd(sNewName);
            ManageConstantGroupsDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }

    class RenameGroupAction
    implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public RenameGroupAction(ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            int iSelectedIndex = this.dialog.lstGroups.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(this.dialog, "You must select a group before you can rename it.", "No Group Selected", 0);
                return;
            }
            String sOldName = (String)this.dialog.lstGroups.getSelectedValue();
            String sNewName = JOptionPane.showInputDialog("Rename Group \"" + sOldName + "\"\n\nPlease enter new name:");
            if (sNewName != null) {
                this.addBufferedAction(sOldName, sNewName);
                int iNumNames = this.dialog.lstGroups.getModel().getSize();
                Object[] names = new String[iNumNames];
                for (int iName = 0; iName < iNumNames; ++iName) {
                    names[iName] = (String)this.dialog.lstGroups.getModel().getElementAt(iName);
                }
                names[iSelectedIndex] = sNewName;
                ManageConstantGroupsDialog.this.displayGroups(names, sNewName);
            }
        }

        void addBufferedAction(String sOldName, String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionRename(sOldName, sNewName);
            ManageConstantGroupsDialog.this.bufferedActionCollection.add(bufferedAction);
        }
    }
}

