/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.ManageConstantGroupsDialog;
import ch.abacus.designcockpit.metadataEditor.ManageGroupConstantsDialog;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JASplitPane;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class MetadataEditorPageConstants
extends JAPanel {
    final MetadataEditor editor;
    JAList lstGroups = new JAList();
    JATable lstConstants = new JATable();
    ListSelectionListener selectionListener = new SelectionListener();
    public TableModel tableModel = null;
    ArrayList groups = new ArrayList();
    JAButton btnModifyGroups = new JAButton("Modify Groups");

    public MetadataEditorPageConstants(MetadataEditor editor) {
        this.editor = editor;
        this.initInterface();
        this.populateDisplay();
    }

    private void populateDisplay() {
        this.groups.clear();
        MetaConstantGroup group = this.editor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            this.groups.add(group.sClassName);
            group = group.theNextSibling;
        }
        this.lstGroups.setListData(this.groups.toArray());
        if (this.groups.size() != 0) {
            this.lstGroups.setSelectedIndex(0);
        }
    }

    void initInterface() {
        this.setLayout(new BorderLayout());
        JAPanel pnlGroups = new JAPanel((LayoutManager)new BorderLayout());
        JAPanel pnlConstants = new JAPanel((LayoutManager)new BorderLayout());
        pnlGroups.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        pnlConstants.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JASplitPane splitPane = new JASplitPane(1, (Component)pnlGroups, (Component)pnlConstants);
        splitPane.setDividerLocation(200);
        Dimension minimumSize = new Dimension(100, 50);
        pnlGroups.setMinimumSize(minimumSize);
        pnlConstants.setMinimumSize(minimumSize);
        JALabel lblGroups = new JALabel("Groups");
        pnlGroups.add((Component)lblGroups, (Object)"North");
        pnlGroups.add((Component)new JScrollPane((Component)this.lstGroups), (Object)"Center");
        JAPanel pnlModifyGroups = new JAPanel((LayoutManager)new FlowLayout(0, 0, 5));
        pnlModifyGroups.add((Component)this.btnModifyGroups);
        pnlGroups.add((Component)pnlModifyGroups, (Object)"South");
        JALabel lblConstants = new JALabel("Constants in Group");
        pnlConstants.add((Component)lblConstants, (Object)"North");
        pnlConstants.add((Component)new JAScrollPane((Component)this.lstConstants), (Object)"Center");
        JAButton btnModifyConstants = new JAButton("Modify Constants");
        JAPanel pnlModifyConstants = new JAPanel((LayoutManager)new FlowLayout(0, 0, 5));
        pnlModifyConstants.add((Component)btnModifyConstants);
        pnlConstants.add((Component)pnlModifyConstants, (Object)"South");
        this.add((Component)splitPane);
        this.lstConstants.setSelectionMode(0);
        this.lstGroups.addListSelectionListener(this.selectionListener);
        btnModifyConstants.addActionListener((ActionListener)new ModifyConstantsAction(this.editor));
        this.btnModifyGroups.addActionListener((ActionListener)new ModifyGroupsAction(this));
    }

    void showConstantsOfTheGroup(String sGroup) {
        MetaConstantGroup group = this.editor.theMetadataDispenser.findConstantGroup(sGroup);
        this.tableModel = new TableModel(group);
        this.lstConstants.setModel((javax.swing.table.TableModel)this.tableModel);
    }

    class ModifyGroupsAction
    implements ActionListener {
        private final MetadataEditorPageConstants pageConstants;

        public ModifyGroupsAction(MetadataEditorPageConstants pageConstants) {
            this.pageConstants = pageConstants;
        }

        public void actionPerformed(ActionEvent e) {
            ManageConstantGroupsDialog dialog = new ManageConstantGroupsDialog(this.pageConstants, "Manage Constant Groups", "Groups");
            dialog.show();
            MetadataEditorPageConstants.this.populateDisplay();
            this.pageConstants.editor.pageCollections.populateDisplay();
        }
    }

    class ModifyConstantsAction
    implements ActionListener {
        private final MetadataEditor editor;

        public ModifyConstantsAction(MetadataEditor editor) {
            this.editor = editor;
        }

        public void actionPerformed(ActionEvent e) {
            MetaConstantGroup group = this.editor.theMetadataDispenser.findConstantGroup((String)MetadataEditorPageConstants.this.lstGroups.getSelectedValue());
            ManageGroupConstantsDialog dialog = new ManageGroupConstantsDialog(this.editor, group);
            dialog.show();
            MetadataEditorPageConstants.this.populateDisplay();
        }
    }

    class TableModel
    extends AbstractTableModel {
        private MetaConstantGroup group;
        private int rowCount;

        public TableModel(MetaConstantGroup group) {
            this.group = group;
            if (group == null) {
                this.rowCount = 0;
            } else {
                ArrayList constants = group.getConstantList();
                this.rowCount = constants.size();
            }
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            return "Value";
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String sConstantName = (String)this.group.getConstantList().get(rowIndex);
            String sConstantValue = this.group.get(sConstantName);
            if (columnIndex == 0) {
                return sConstantName;
            }
            return sConstantValue;
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                MetadataEditorPageConstants.this.showConstantsOfTheGroup((String)MetadataEditorPageConstants.this.lstGroups.getSelectedValue());
            }
        }
    }
}

