/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.AWTConverters;
import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.NumberConverters;
import java.util.HashMap;
import java.util.Map;

public class ConverterRegistry
implements Converter {
    private static ConverterRegistry sharedInstance = new ConverterRegistry();
    private Map fromMap = new HashMap();

    public ConverterRegistry() {
        new AWTConverters().register(this);
        new NumberConverters().register(this);
    }

    public void addConverter(Class from, Class to, Converter converter) {
        HashMap<Class, Converter> toMap = (HashMap<Class, Converter>)this.fromMap.get(from);
        if (toMap == null) {
            toMap = new HashMap<Class, Converter>();
            this.fromMap.put(from, toMap);
        }
        toMap.put(to, converter);
    }

    public Converter getConverter(Class from, Class to) {
        Map toMap = (Map)this.fromMap.get(from);
        if (toMap != null) {
            return (Converter)toMap.get(to);
        }
        return null;
    }

    public Object convert(Class targetType, Object value) {
        if (value == null) {
            return null;
        }
        Converter converter = this.getConverter(value.getClass(), targetType);
        if (converter == null) {
            throw new IllegalArgumentException("No converter from " + value.getClass() + " to " + targetType.getName());
        }
        return converter.convert(targetType, value);
    }

    public static ConverterRegistry instance() {
        return sharedInstance;
    }
}

