/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.comedia.util.scanner.CXmlScanner;
import org.comedia.util.xml.CXmlElement;
import org.comedia.util.xml.CXmlException;

public class CDefaultXmlElement
implements CXmlElement {
    protected String tagName = "";
    protected Hashtable props = new Hashtable();
    protected ArrayList childs = new ArrayList();

    public CDefaultXmlElement() {
    }

    public CDefaultXmlElement(String string) {
        this.tagName = string.toUpperCase();
    }

    public void clear() {
        this.props.clear();
        this.childs.clear();
    }

    public void parseElement(CXmlScanner cXmlScanner) throws CXmlException {
        while (true) {
            String string;
            if (cXmlScanner.getTokenType() == 32) {
                String string2 = cXmlScanner.getToken();
                cXmlScanner.gotoNextToken();
                if (string2.equals("/>")) {
                    return;
                }
                if (string2.endsWith(">")) break;
                throw new CXmlException("Incorrent XML structure at line: " + cXmlScanner.getLineNo());
            }
            if (cXmlScanner.getTokenType() != 2) {
                throw new CXmlException("Incorrent XML structure at line: " + cXmlScanner.getLineNo());
            }
            String string3 = cXmlScanner.getToken();
            cXmlScanner.gotoNextToken();
            if (cXmlScanner.getTokenType() == 16) {
                cXmlScanner.gotoNextToken();
                string = CXmlScanner.unwrapString(cXmlScanner.getToken());
                cXmlScanner.gotoNextToken();
            } else {
                string = null;
            }
            this.props.put(string3.toUpperCase(), string);
        }
        this.parseChildElements(cXmlScanner);
    }

    public void parseChildElements(CXmlScanner cXmlScanner) throws CXmlException {
        String string = "";
        while (cXmlScanner.getTokenType() != 32768) {
            String string2 = cXmlScanner.getToken();
            if (string2.equals("<?")) {
                while (!cXmlScanner.getToken().equals("?>")) {
                    if (cXmlScanner.getTokenType() == 32768) {
                        throw new CXmlException("Incorrent XML structure at line: " + cXmlScanner.getLineNo());
                    }
                    cXmlScanner.gotoNextToken();
                }
                cXmlScanner.gotoNextToken();
                continue;
            }
            if (string2.equals("<!")) {
                while (!cXmlScanner.getToken().equals(">")) {
                    if (cXmlScanner.getTokenType() == 32768) {
                        throw new CXmlException("Incorrent XML structure at line: " + cXmlScanner.getLineNo());
                    }
                    cXmlScanner.gotoNextToken();
                }
                cXmlScanner.gotoNextToken();
                continue;
            }
            if (string2.equals("<")) {
                if (string.length() > 0) {
                    this.childs.add(string);
                    string = "";
                }
                cXmlScanner.gotoNextToken();
                string2 = cXmlScanner.getToken();
                if (cXmlScanner.getTokenType() != 2) {
                    throw new CXmlException("Incorrent XML structure at line: " + cXmlScanner.getLineNo());
                }
                cXmlScanner.gotoNextToken();
                CXmlElement cXmlElement = this.createChildElement(string2.toUpperCase());
                this.childs.add(cXmlElement);
                cXmlElement.parseElement(cXmlScanner);
                continue;
            }
            if (string2.equals("</")) {
                cXmlScanner.gotoNextToken();
                string2 = cXmlScanner.getToken().toUpperCase();
                if (string2.equals(this.tagName)) {
                    cXmlScanner.gotoNextToken();
                    if (cXmlScanner.getToken().equals(">")) {
                        cXmlScanner.gotoNextToken();
                        break;
                    }
                }
                throw new CXmlException("Incorrent XML structure at line: " + cXmlScanner.getLineNo());
            }
            if (cXmlScanner.getTokenType() == 32) {
                throw new CXmlException("Incorrent XML structure at line: " + cXmlScanner.getLineNo());
            }
            if (string.length() > 0) {
                string = string + " ";
            }
            string = string + CXmlScanner.unwrapValue(string2);
            cXmlScanner.gotoNextToken();
        }
        if (string.length() > 0) {
            this.childs.add(string);
        }
    }

    protected String createIndent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + " ";
            ++n2;
        }
        return string;
    }

    public void writeElement(Writer writer, int n) throws IOException {
        writer.write(this.createIndent(n) + "<" + this.tagName);
        Enumeration enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.props.get(k);
            writer.write(" " + k.toString());
            if (v == null) continue;
            writer.write("=" + CXmlScanner.wrapString(v.toString()));
        }
        if (this.childs.size() == 0) {
            writer.write("/>\n");
        } else {
            writer.write(">\n");
            this.writeChildElements(writer, n);
            writer.write(this.createIndent(n) + "</" + this.tagName + ">\n");
        }
    }

    public void writeChildElements(Writer writer, int n) throws IOException {
        int n2 = 0;
        while (n2 < this.childs.size()) {
            Object e = this.childs.get(n2);
            if (e instanceof CXmlElement) {
                ((CXmlElement)e).writeElement(writer, n + 2);
            } else {
                writer.write(this.createIndent(n) + "  " + CXmlScanner.wrapValue(e.toString()) + "\n");
            }
            ++n2;
        }
    }

    public CXmlElement createChildElement(String string) {
        return new CDefaultXmlElement(string.toUpperCase());
    }
}

