/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.plaf.generic.GenericIconFactory;
import ch.abacus.lib.ui.plaf.generic.GenericLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalCheckBoxUI;

public class GenericCheckBoxUI
extends MetalCheckBoxUI {
    private static final GenericCheckBoxUI checkBoxUI = new GenericCheckBoxUI();
    private CheckBoxPLAFListener mCheckBoxPLAFListener;

    public static ComponentUI createUI(JComponent b) {
        ((JCheckBox)b).setIcon(GenericIconFactory.getCheckBoxIcon());
        return checkBoxUI;
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
        g.setColor(GenericLookAndFeel.getDarkGray());
        g.drawRect(t.x - 1, t.y - 1, t.width + 1, t.height + 1);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.mCheckBoxPLAFListener == null) {
            this.mCheckBoxPLAFListener = new CheckBoxPLAFListener();
        }
        c.addMouseListener(this.mCheckBoxPLAFListener);
        c.addFocusListener(this.mCheckBoxPLAFListener);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicButtonListener(b);
    }

    private class CheckBoxPLAFListener
    extends MouseAdapter
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            if (((JCheckBox)e.getSource()).isEnabled()) {
                ((JCheckBox)e.getSource()).setIcon(GenericIconFactory.getFocusedCheckBoxIcon());
                ((JCheckBox)e.getSource()).repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            if (((JCheckBox)e.getSource()).isEnabled()) {
                ((JCheckBox)e.getSource()).setIcon(GenericIconFactory.getCheckBoxIcon());
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (((JCheckBox)e.getSource()).isEnabled()) {
                ((JCheckBox)e.getSource()).setIcon(GenericIconFactory.getFocusedCheckBoxIcon());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (((JCheckBox)e.getSource()).isEnabled()) {
                ((JCheckBox)e.getSource()).setIcon(GenericIconFactory.getCheckBoxIcon());
            }
        }
    }
}

