/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.plaf.generic.GenericLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.UIManager;

public class GenericUtils {
    static void drawFlushBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.drawRect(0, 0, w - 1, h - 1);
        g.translate(-x, -y);
    }

    static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(GenericLookAndFeel.getDisabledColor());
        g.drawRect(0, 0, w, h);
    }

    static void drawPressedBorder(Graphics g, int x, int y, int w, int h, boolean isFocused) {
        if (isFocused) {
            g.setColor(GenericLookAndFeel.getSelectBorderColor());
        } else {
            g.setColor(GenericLookAndFeel.getBorderNormal());
        }
        g.translate(x, y);
        GenericUtils.drawFlushBorder(g, 0, 0, w, h);
        g.translate(-x, -y);
    }

    static void drawButtonBorder(Graphics g, int x, int y, int w, int h, boolean active, boolean isFocused) {
        if (active) {
            GenericUtils.drawActiveButtonBorder(g, x, y, w, h);
        } else {
            if (isFocused) {
                g.setColor(GenericLookAndFeel.getSelectBorderColor());
            } else {
                g.setColor(GenericLookAndFeel.getBorderNormal());
            }
            GenericUtils.drawFlushBorder(g, x, y, w, h);
        }
    }

    static void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
        g.setColor(GenericLookAndFeel.getSelectBorderColor());
        GenericUtils.drawFlushBorder(g, x, y, w, h);
    }

    static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean active, boolean isFocused) {
        GenericUtils.drawButtonBorder(g, x + 1, y + 1, w - 1, h - 1, active, isFocused);
        if (isFocused) {
            g.setColor(GenericLookAndFeel.getSelectBorderColor());
        } else {
            g.setColor(GenericLookAndFeel.getBorderNormal());
        }
        g.drawRect(x, y, w - 1, h - 1);
        g.drawRect(x, y, w - 2, h - 2);
        g.drawLine(w - 1, 0, w - 1, 0);
        g.drawLine(0, h - 1, 0, h - 1);
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

