/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.core;

import ch.abacus.lib.ui.propertyinspector.core.Clazzes;
import ch.abacus.lib.ui.propertyinspector.core.Properties;

public class Clazz {
    private Properties properties = new Properties(this);
    private Class origin;
    private String originClass;
    private Clazz parent;
    private Clazzes inheritance = new Clazzes();

    public Clazz(Clazz parent, Class origin, String originClass) {
        this.parent = parent;
        if (parent != null) {
            parent.inheritance.add(this);
        }
        this.origin = origin;
        this.originClass = originClass;
    }

    public Clazz(Clazz parent, String originClass) {
        this(parent, null, originClass);
    }

    public Clazz(Clazz parent, Class origin) {
        this(parent, origin, null);
    }

    public Clazz findByInstance(Object object) {
        if (this.isClazzObject(object, this)) {
            return this;
        }
        for (int i = 0; i < this.inheritance.size(); ++i) {
            Clazz clazz = this.inheritance.get(i).findByInstance(object);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private boolean isClazzObject(Object object, Clazz clazz) {
        boolean ok;
        if (this.originClass != null) {
            ok = clazz.originClass.equals(object);
        } else {
            boolean bl = ok = clazz.origin == object.getClass();
        }
        if (!ok && this.originClass == null) {
            Class<?>[] interfaces = object.getClass().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] != clazz.origin) continue;
                return true;
            }
        }
        return ok;
    }

    public Clazzes getInheritance() {
        return this.inheritance;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Clazz getParent() {
        return this.parent;
    }
}

