/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;

public class CompressedProjectDocument {
    private boolean bOpen = false;
    private MetaProject theMetaProject;
    private GZIPInputStream zinputStream;
    private InputStream inputStream;
    private int iBytesLastRead = 0;
    private int iBytesLastWritten = 0;
    private RandomAccessFile outputFile;
    private int inputPosition = 0;
    CompressedProjectDocumentHeader theHeader = new CompressedProjectDocumentHeader();

    CompressedProjectDocument(MetaProject theMetaProject) {
        this.theMetaProject = theMetaProject;
    }

    void setInputStream(GZIPInputStream zinputStream) {
        this.zinputStream = zinputStream;
    }

    InputStream getInputStream() {
        return this.zinputStream;
    }

    void setOutputFile(RandomAccessFile outputFile) {
        this.outputFile = outputFile;
    }

    RandomAccessFile getOutputFile() {
        return this.outputFile;
    }

    int getBytesLastWritten() {
        return this.iBytesLastWritten;
    }

    int getBytesLastRead() {
        return this.iBytesLastRead;
    }

    boolean open(InputStream inputStream) throws HammerException {
        this.inputStream = inputStream;
        this.outputFile = null;
        try {
            if (!this.bOpen) {
                boolean bRetVal = this.readHeader();
                this.bOpen = true;
                return bRetVal;
            }
            return true;
        }
        catch (IOException e1) {
            return false;
        }
    }

    void open(RandomAccessFile outputFile) {
        this.outputFile = outputFile;
        this.zinputStream = null;
        this.inputStream = null;
        this.theHeader.iWatermark = 43948;
        this.theHeader.iHeaderSize = 256;
        this.theHeader.iVersion = this.theMetaProject.getMetaDataUser().getVersionNumber();
        this.theHeader.iRevision = this.theMetaProject.getMetaDataUser().getRevisionNumber();
        this.theHeader.iSubrevision = this.theMetaProject.getMetaDataUser().getSubRevisionNumber();
        this.theHeader.iBuild = this.theMetaProject.getMetaDataUser().getBuildNumber();
        this.inputPosition = 0;
    }

    boolean close() {
        if (this.zinputStream != null) {
            try {
                this.zinputStream.close();
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    boolean close(String sFileName, OutputStream os) {
        File fileOutput = null;
        if (this.outputFile != null) {
            boolean bStreamProvided = os != null;
            try {
                this.writeHeader();
                this.outputFile.close();
                File fileInput = new File(sFileName);
                if (!bStreamProvided) {
                    fileOutput = new File(sFileName + ".zzz");
                    os = new BufferedOutputStream(new FileOutputStream(fileOutput));
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(sFileName));
                byte[] headerBytes = new byte[this.theHeader.iHeaderSize];
                is.read(headerBytes);
                os.write(headerBytes);
                GZIPOutputStream fgzipOutput = new GZIPOutputStream(os, 8192);
                int iSize = 16384;
                byte[] tmpbuf = new byte[iSize];
                while (is.available() != 0) {
                    int b = is.read(tmpbuf);
                    fgzipOutput.write(tmpbuf);
                }
                fgzipOutput.close();
                if (!bStreamProvided) {
                    os.close();
                }
                is.close();
                fileInput.delete();
                if (!bStreamProvided) {
                    fileOutput.renameTo(fileInput);
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    boolean close(String sFileName) {
        if (this.outputFile != null) {
            try {
                this.writeHeader();
                this.outputFile.close();
                File fileInput = new File(sFileName);
                File fileOutput = new File(sFileName + ".zzz");
                FileOutputStream os = new FileOutputStream(sFileName + ".zzz");
                FileInputStream fin = new FileInputStream(sFileName);
                byte[] tmpHeadBuf = new byte[this.theHeader.iHeaderSize];
                fin.read(tmpHeadBuf);
                os.write(tmpHeadBuf);
                GZIPOutputStream fgzipOutput = new GZIPOutputStream(os);
                int iSize = 16384;
                byte[] tmpbuf = new byte[iSize];
                while (fin.available() != 0) {
                    int b = fin.read(tmpbuf);
                    fgzipOutput.write(tmpbuf);
                }
                fgzipOutput.close();
                os.close();
                fin.close();
                fileInput.delete();
                fileOutput.renameTo(fileInput);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    byte[] read(int iOffset, int iBytesToRead) throws IOException {
        int totalbytes;
        int bytesread;
        while (this.inputPosition < iOffset) {
            this.zinputStream.read();
            ++this.inputPosition;
        }
        if (iBytesToRead == 0) {
            iBytesToRead = 65535;
        }
        byte[] prozBytes = new byte[iBytesToRead];
        for (totalbytes = 0; totalbytes != iBytesToRead && this.zinputStream.available() != 0; totalbytes += bytesread) {
            int iBytesToReadThisTime = 512;
            if (iBytesToRead - totalbytes < 512) {
                iBytesToReadThisTime = iBytesToRead - totalbytes;
            }
            bytesread = this.zinputStream.read(prozBytes, totalbytes, iBytesToReadThisTime);
        }
        this.iBytesLastRead = totalbytes;
        return prozBytes;
    }

    void write(int iOffset, byte[] bytes) throws IOException {
        this.outputFile.write(bytes);
        this.iBytesLastWritten = bytes.length;
    }

    boolean readHeader() throws IOException, HammerException {
        DataInputStream dataIn = new DataInputStream(this.inputStream);
        this.theHeader.iWatermark = dataIn.readInt();
        if (this.theHeader.iWatermark != 43948) {
            throw new HammerException(HammerException.BAD_COMPRESSED_PROJECT_FILE_FORMAT, "Watermark bad - does not equal 0xabac");
        }
        this.inputPosition += 4;
        this.theHeader.iVersion = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iRevision = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iSubrevision = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iBuild = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iHeaderSize = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iProjOffset = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iClassOffset = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iJavaOffset = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iProjSize = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iClassSize = dataIn.readInt();
        this.inputPosition += 4;
        this.theHeader.iJavaSize = dataIn.readInt();
        this.inputPosition += 4;
        while (this.inputPosition < this.theHeader.iHeaderSize) {
            dataIn.readInt();
            this.inputPosition += 4;
        }
        this.zinputStream = new GZIPInputStream(this.inputStream);
        if (this.theHeader.iWatermark == 43948) {
            return this.theHeader.iHeaderSize == 256;
        }
        return false;
    }

    void writeHeader() throws IOException {
        byte[] filler = new byte[this.theHeader.iHeaderSize];
        this.outputFile.write(filler);
        this.outputFile.seek(0L);
        this.outputFile.writeInt(this.theHeader.iWatermark);
        this.outputFile.writeInt(this.theHeader.iVersion);
        this.outputFile.writeInt(this.theHeader.iRevision);
        this.outputFile.writeInt(this.theHeader.iSubrevision);
        this.outputFile.writeInt(this.theHeader.iBuild);
        this.outputFile.writeInt(this.theHeader.iHeaderSize);
        this.outputFile.writeInt(this.theHeader.iProjOffset);
        this.outputFile.writeInt(this.theHeader.iClassOffset);
        this.outputFile.writeInt(this.theHeader.iJavaOffset);
        this.outputFile.writeInt(this.theHeader.iProjSize);
        this.outputFile.writeInt(this.theHeader.iClassSize);
        this.outputFile.writeInt(this.theHeader.iJavaSize);
    }

    String readJavaSource() throws IOException {
        return null;
    }

    byte[] readProjSource() throws IOException {
        if (this.theHeader.iProjSize == 0) {
            return null;
        }
        byte[] projSrc = this.read(this.theHeader.iProjOffset, this.theHeader.iProjSize);
        return projSrc;
    }

    Class readRenderingClass(InputStream inputStream, String sClassName) throws IOException, HammerException {
        try {
            this.theMetaProject.renderingClass = !this.theMetaProject.getMetaDataUser().getOpenSourceState() ? this.theMetaProject.getMetaDataUser().getClassLoader().theLoader.loadLoadedClass(sClassName) : this.theMetaProject.getMetaDataUser().getClassLoader().getLoader().loadClass(sClassName);
        }
        catch (ClassNotFoundException e1) {
            this.open(inputStream);
            if (this.theHeader.iClassSize == 0) {
                return null;
            }
            byte[] classBytes = this.read(this.theHeader.iClassOffset, this.theHeader.iClassSize);
            this.close();
            if (classBytes == null) {
                return null;
            }
            this.theMetaProject.renderingClass = this.theMetaProject.getMetaDataUser().getClassLoader().getLoader().defineClass(sClassName, classBytes);
        }
        return this.theMetaProject.renderingClass;
    }

    void writeJavaSource(String sSource) throws IOException {
    }

    void writeProjSource(byte[] bytes) throws IOException {
        this.theHeader.iProjSize = 0;
        if (bytes == null) {
            return;
        }
        this.theHeader.iProjOffset = this.theHeader.iHeaderSize + this.theHeader.iClassSize;
        this.outputFile.seek(this.theHeader.iProjOffset);
        this.outputFile.write(bytes);
        this.theHeader.iProjSize = bytes.length;
    }

    void writeClass(byte[] bytes) throws IOException {
        this.theHeader.iClassSize = 0;
        if (bytes == null) {
            return;
        }
        this.theHeader.iClassOffset = this.theHeader.iHeaderSize + this.inputPosition;
        this.outputFile.seek(this.theHeader.iClassOffset);
        this.outputFile.write(bytes);
        this.theHeader.iClassSize = bytes.length;
        this.inputPosition += bytes.length;
    }

    protected boolean writeCustomMetadata(String customMetadataPath) throws IOException {
        int c;
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        String[] dirRepositories = customMetadataPath.split(";");
        for (c = 0; c < dirRepositories.length; ++c) {
            File dir = new File(dirRepositories[c]);
            String[] children = dir.list(filter);
            if (children != null) continue;
            return false;
        }
        for (c = 0; c < dirRepositories.length; ++c) {
            String dirSeparator = System.getProperty("file.separator");
            File dir = new File(dirRepositories[c]);
            String[] children = dir.list(filter);
            if (children == null) {
                return false;
            }
            FileOutputStream fostream = null;
            JarOutputStream jarOutputStream = null;
            boolean singleFileSepa = dirRepositories[c].contains("/");
            if (singleFileSepa) {
                dirSeparator = "/";
            }
            String customJarName = dirRepositories[c].substring(3, dirRepositories[c].length()).replace(dirSeparator, ".");
            File newJarFile = null;
            String sNewJarName = new String(dirRepositories[c] + dirSeparator + customJarName + "." + "AbacusCustom" + ".jar");
            if (!this.isXMLTouched(dirRepositories[c], children, sNewJarName)) continue;
            try {
                newJarFile = new File(sNewJarName);
                if (newJarFile.exists()) {
                    newJarFile.delete();
                }
                newJarFile.createNewFile();
            }
            catch (IOException e0) {
                System.err.println("Cannot create jar file " + sNewJarName + ".tmp" + ".jar");
            }
            try {
                fostream = new FileOutputStream(newJarFile);
                try {
                    jarOutputStream = new JarOutputStream(fostream);
                }
                catch (IOException e1) {
                    System.err.println("Cannot create output stream for jar file " + sNewJarName + " " + e1);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            for (int i = 0; i < children.length; ++i) {
                String filename = dirRepositories[c] + dirSeparator + children[i];
                Object repoHammerMetadataStream = null;
                try {
                    ZipEntry ze = new ZipEntry("ch\\abacus\\components\\imported\\" + children[i]);
                    jarOutputStream.putNextEntry(ze);
                    File fileInput = new File(filename);
                    FileInputStream xin = null;
                    try {
                        xin = new FileInputStream(fileInput);
                    }
                    catch (FileNotFoundException e) {
                        return false;
                    }
                    BufferedInputStream xinStr = new BufferedInputStream(xin);
                    int iSize = new Long(fileInput.length()).intValue();
                    byte[] tmpbuf = new byte[iSize];
                    try {
                        int b;
                        while ((b = xinStr.read(tmpbuf)) != -1) {
                            jarOutputStream.write(tmpbuf);
                        }
                        xin.close();
                        continue;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            jarOutputStream.close();
            fostream.close();
        }
        return false;
    }

    private boolean isXMLTouched(String path, String[] files, String jarName) {
        boolean bFlag = false;
        File jarFile = new File(jarName);
        if (!jarFile.exists()) {
            return true;
        }
        long jarModDate = jarFile.lastModified();
        for (int c = 0; c < files.length; ++c) {
            String sXmlFile;
            File xmlFile;
            long modDate;
            if (files[c] == null || (modDate = (xmlFile = new File(sXmlFile = path + "\\" + files[c])).lastModified()) <= jarModDate) continue;
            bFlag = true;
            break;
        }
        return bFlag;
    }

    class CompressedProjectDocumentHeader {
        public static final int WATERMARK_VALUE = 43948;
        public static final int HEADER_SIZE = 256;
        public static final int COMPRESSION_BUFFER_SIZE = 16384;
        int iWatermark;
        int iVersion;
        int iRevision;
        int iSubrevision;
        int iBuild;
        int iHeaderSize;
        int iProjOffset;
        int iClassOffset;
        int iJavaOffset;
        int iProjSize;
        int iClassSize;
        int iJavaSize;

        CompressedProjectDocumentHeader() {
        }
    }
}

