/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerClassLoader;
import ch.abacus.lib.ui.renderer.common.HammerInputStream;
import ch.abacus.lib.ui.renderer.common.HammerNLSAccess;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.File;
import java.util.ArrayList;

public class HammerConfigurationManager {
    Document theConfigurationDocument = null;
    Element theRootElement = null;
    String sBaseDir = "";
    String sUserHome = "";
    ArrayList theNLSDocuments = new ArrayList(0);
    public boolean bConfigured = false;
    public String thePathName;
    public String theJarName;
    public int theMode = 0;

    public HammerConfigurationManager(String sBaseDir, String sUserHome, HammerClassLoader theLoader, String sConfigXMLDocument) {
        try {
            this.sBaseDir = sBaseDir;
            this.sUserHome = sUserHome;
            HammerInputStream fileInput = theLoader.theLoader.getFileInPathAsStream(sConfigXMLDocument);
            if (fileInput != null && fileInput.theStream != null) {
                this.theConfigurationDocument = new Document(fileInput.theStream);
                if (this.theConfigurationDocument != null) {
                    this.theRootElement = this.theConfigurationDocument.getRoot();
                    if (this.theRootElement != null) {
                        this.bConfigured = true;
                    }
                }
                this.thePathName = fileInput.sFullPathName;
                this.theJarName = fileInput.sJarName;
                this.theMode = fileInput.mode;
            }
        }
        catch (ParseException e2) {
            // empty catch block
        }
    }

    String doAllTranslations(String sValue, String sKey, String sReplace) {
        if (sKey == null) {
            return sValue;
        }
        if (sValue == null) {
            return sValue;
        }
        int iMatch;
        while ((iMatch = sValue.indexOf(sKey)) != -1) {
            String sLeft = sValue.substring(0, iMatch);
            String sRight = sValue.substring(iMatch + sKey.length());
            sValue = sLeft + sReplace + sRight;
        }
        return sValue;
    }

    public String getTranslatedValue(String sValue) {
        if (sValue != null) {
            sValue = this.doAllTranslations(sValue, "%BaseDir%", this.sBaseDir);
            sValue = this.doAllTranslations(sValue, "%UserHome%", this.sUserHome);
            sValue = this.doAllTranslations(sValue, "\\\\", "\\");
        }
        return sValue;
    }

    public boolean checkConfigurationSetting(String sTagName) {
        if (this.theRootElement != null) {
            Element theConfigurationElement = this.theRootElement.getElement(sTagName);
            return theConfigurationElement != null;
        }
        return false;
    }

    public String getConfigurationVariable(String sTagName) {
        if (this.theRootElement != null) {
            Element theConfigurationElement = this.theRootElement.getElement(sTagName);
            if (theConfigurationElement != null) {
                return this.getTranslatedValue(theConfigurationElement.getTextString());
            }
            return null;
        }
        return null;
    }

    public String getConfigurationVariable(String sTagName, String sDefaultValue) {
        if (this.theRootElement != null) {
            Element theConfigurationElement = this.theRootElement.getElement(sTagName);
            if (theConfigurationElement != null) {
                return this.getTranslatedValue(theConfigurationElement.getTextString());
            }
            return sDefaultValue;
        }
        return sDefaultValue;
    }

    public String getConfiguredDirectory(String sDirectoryPath) {
        File temp;
        String sSeparator = System.getProperties().getProperty("file.separator");
        String sRootDirectory = this.getConfigurationVariable("RootDirectory");
        String sReturnValue = sDirectoryPath;
        if (sRootDirectory != null) {
            sReturnValue = sRootDirectory.endsWith(sSeparator) ? (sDirectoryPath.substring(0, 0).equals(sSeparator) ? sRootDirectory + sDirectoryPath.substring(1) : sRootDirectory + sDirectoryPath) : (sDirectoryPath.substring(0, 0).equals(sSeparator) ? sRootDirectory + sDirectoryPath : sRootDirectory + sSeparator + sDirectoryPath);
        }
        if (!(temp = new File(sReturnValue)).exists()) {
            temp.mkdirs();
        }
        return sReturnValue + sSeparator;
    }

    public String getCacheDirectory() {
        String sCacheDir = this.getConfigurationVariable("CacheDirectory");
        if (sCacheDir == null) {
            sCacheDir = this.getConfiguredDirectory("cache");
        }
        return sCacheDir;
    }

    public String getLogDirectory() {
        String sLogDir = this.getConfigurationVariable("LogDirectory");
        if (sLogDir == null) {
            sLogDir = this.getConfiguredDirectory("log");
        }
        return sLogDir;
    }

    public String getResourcesDirectory() {
        String sResourcesDir = this.getConfigurationVariable("ResourcesDirectory");
        if (sResourcesDir == null) {
            sResourcesDir = this.getConfiguredDirectory("resources");
        }
        return sResourcesDir;
    }

    public String[] getConfigurationVariableSet(String sTag) {
        if (this.theRootElement != null) {
            Elements theConfigurationElements = this.theRootElement.getElements(sTag);
            if (theConfigurationElements.size() < 1) {
                return null;
            }
            String[] theReturnValue = new String[theConfigurationElements.size()];
            Element theConfigurationElement = theConfigurationElements.next();
            for (int i = 0; i < theConfigurationElements.size(); ++i) {
                theReturnValue[i] = this.getTranslatedValue(theConfigurationElement.getTextString());
                theConfigurationElement = theConfigurationElements.next();
            }
            return theReturnValue;
        }
        return null;
    }

    public boolean loadNLSDocuments() {
        if (this.theRootElement != null) {
            Elements theConfigurationElements = this.theRootElement.getElements("NLSDocument");
            if (theConfigurationElements.size() < 1) {
                return false;
            }
            for (int i = 0; i < theConfigurationElements.size(); ++i) {
                Element theNLSPath = theConfigurationElements.next();
                Element xmlNLSDocumentKey = theNLSPath.getElement("Key");
                Element xmlNLSDocumentPath = theNLSPath.getElement("Path");
                String sDocumentKey = xmlNLSDocumentKey.getTextString();
                String sDocumentPath = xmlNLSDocumentPath.getTextString();
                HammerNLSAccess theNLSDoc = new HammerNLSAccess(sDocumentKey, sDocumentPath);
                this.theNLSDocuments.add(theNLSDoc);
            }
            return true;
        }
        return false;
    }

    public int getNLSDocCount() {
        if (this.theNLSDocuments != null) {
            return this.theNLSDocuments.size();
        }
        return 0;
    }

    public String getNLSDocKey(int i) {
        if (this.theNLSDocuments != null) {
            return ((HammerNLSAccess)this.theNLSDocuments.get((int)i)).sKey;
        }
        return null;
    }

    public String getNLSDocName(int i) {
        if (this.theNLSDocuments != null) {
            return ((HammerNLSAccess)this.theNLSDocuments.get((int)i)).sDocument;
        }
        return null;
    }
}

