/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.renderer.common.HammerLogConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

class HammerConsoleAboutBox
extends JAFrame {
    public HammerConsoleAboutBox(HammerLogConsole theIDELogConsole) {
        JATabbedPane theAboutBoxPane = new JATabbedPane();
        ProductInformationPanel theProductInfoPanel = new ProductInformationPanel(theIDELogConsole);
        SystemInformationPanel theSystemInfoPanel = new SystemInformationPanel(theIDELogConsole);
        theAboutBoxPane.addTab("Version Information", theProductInfoPanel);
        theAboutBoxPane.addTab("System Information", theSystemInfoPanel);
        this.getContentPane().setLayout(new GridLayout(2, 1, 0, 5));
        this.getContentPane().add(theAboutBoxPane);
        JAPanel theButtonPanel = new JAPanel(new GridBagLayout());
        GridBagConstraints theConstraints = new GridBagConstraints(4, 3, 4, 2, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.getContentPane().add(theButtonPanel);
        JButton theButton = new JButton("Ok");
        theButtonPanel.add((Component)theButton, theConstraints);
        theButton.addActionListener(new AboutBoxButtonListener(this));
        this.setResizable(true);
        this.setSize(new Dimension(600, 320));
        this.show();
    }

    class SystemInformationPanel
    extends JAPanel {
        private HammerLogConsole theIDELogConsole;

        public SystemInformationPanel(HammerLogConsole theIDELogConsole) {
            this.theIDELogConsole = theIDELogConsole;
            Properties sysprops = System.getProperties();
            SystemPropertyModel thePropertyModel = new SystemPropertyModel();
            Enumeration<?> e = sysprops.propertyNames();
            while (e.hasMoreElements()) {
                String sPropName = (String)e.nextElement();
                String sPropValue = System.getProperty(sPropName);
                thePropertyModel.addPair(sPropName, sPropValue);
            }
            JATable thePropertyTable = new JATable(thePropertyModel);
            this.setLayout(new BorderLayout());
            this.add(new JAScrollPane(thePropertyTable));
        }
    }

    class SystemPropertyModel
    extends AbstractTableModel {
        int iRowCount = 0;
        ArrayList ColumnOneValues = new ArrayList(0);
        ArrayList ColumnTwoValues = new ArrayList(0);

        public void addPair(String sName, String sValue) {
            this.ColumnOneValues.add(sName);
            this.ColumnTwoValues.add(sValue);
        }

        public int getRowCount() {
            return this.ColumnOneValues.size();
        }

        public Object getValueAt(int iRow, int iCol) {
            if (iCol == 0) {
                return this.ColumnOneValues.get(iRow);
            }
            return this.ColumnTwoValues.get(iRow);
        }

        public String getColumnName(int iCol) {
            if (iCol == 0) {
                return "Property";
            }
            return "Value";
        }

        public int getColumnCount() {
            return 2;
        }
    }

    class ProductInformationPanel
    extends JAPanel {
        public ProductInformationPanel(HammerLogConsole theIDELogConsole) {
            this.setLayout(new GridLayout(5, 1));
            this.add(new JALabel("Hammer Console", 0));
            this.add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getVersionNumber(), 0));
            this.add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getRevisionNumber(), 0));
            this.add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getSubRevisionNumber(), 0));
            this.add(new JALabel("Version: " + theIDELogConsole.theCreator.theUser.getBuildNumber(), 0));
        }
    }

    class AboutBoxButtonListener
    implements ActionListener {
        JAFrame theFrame;

        public AboutBoxButtonListener(JAFrame objFrame) {
            this.theFrame = objFrame;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theFrame.hide();
        }
    }
}

