/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common.generator;

import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerNLSAccess;
import ch.abacus.lib.ui.renderer.common.ListenerCollection;
import ch.abacus.lib.ui.renderer.common.ListenerDiscriminator;
import ch.abacus.lib.ui.renderer.common.ListenerEntry;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetaMethodLinkage;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaParameter;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.ProjectDocument;
import ch.abacus.lib.ui.renderer.common.generator.BufferCollection;
import ch.abacus.lib.ui.renderer.common.generator.ProjectCodeGenerator;
import com.ibm.cf.CodeFormatter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class DropletCodeGenerator
implements ProjectCodeGenerator {
    ProjectDocument theDocument;
    public Vector vectorConstants = new Vector(0);
    HashMap Variables = new HashMap();
    HashMap VariableClasses = new HashMap();
    BufferCollection theBufferCollection = new BufferCollection();
    HashMap theLookupTable = new HashMap();
    ListenerCollection theListenerCollection = new ListenerCollection();
    static String sFindString = "X_X__X___X_";
    static String sStub = "X_X__X___X_";

    public DropletCodeGenerator(ProjectDocument theDocument) {
        this.theDocument = theDocument;
    }

    public ProjectDocument getProjectDocument() {
        return this.theDocument;
    }

    public void setProjectDocument(ProjectDocument theDocument) {
        this.theDocument = theDocument;
    }

    private String getValue(MetaObject theObject, String sKey) {
        sKey = theObject.getName() + "|" + sKey;
        return (String)this.theLookupTable.get(sKey);
    }

    private void setValue(MetaObject theObject, String sKey, String sValue) {
        sKey = theObject.getName() + "|" + sKey;
        this.theLookupTable.put(sKey, sValue);
    }

    private String getIdentifier(MetaObject theObject) {
        return this.getValue(theObject, "Identifier");
    }

    private void setIdentifier(MetaObject theObject, String value) {
        this.setValue(theObject, "Identifier", value);
    }

    private String getContainerName(MetaObject theObject) {
        return this.getValue(theObject, "ContainerName");
    }

    private void setContainerName(MetaObject theObject, String value) {
        this.setValue(theObject, "ContainerName", value);
    }

    private String getLayoutName(MetaObject theObject) {
        return this.getValue(theObject, "LayoutName");
    }

    private void setLayoutName(MetaObject theObject, String value) {
        this.setValue(theObject, "LayoutName", value);
    }

    private String getGroupName(MetaObject theObject) {
        return this.getValue(theObject, "GroupName");
    }

    private void setGroupName(MetaObject theObject, String value) {
        this.setValue(theObject, "GroupName", value);
    }

    public void generateObjectCode(MetaObject theObject) throws HammerException {
        String sProjectName = theObject.theDesignProject.getName();
        int iIndex = sProjectName.indexOf(".");
        sProjectName = sProjectName.substring(0, iIndex);
        if (!theObject.isFrame() && !theObject.isAbalet()) {
            this.setIdentifier(theObject, theObject.getName());
            this.generateMember(theObject);
            this.generateAccessor(theObject);
            this.generateBuilder(theObject);
            this.generatePropertySettings(theObject);
            this.generateAttachmentCode(theObject);
        } else {
            this.generateAccessor(theObject);
            this.generateAttachmentCode(theObject);
        }
        MetaObject objTest = theObject.theFirstChild;
        while (objTest != null) {
            this.generateObjectCode(objTest);
            objTest = objTest.theNextObject;
        }
    }

    public void generateMember(MetaObject theObject) {
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sClassName.lastIndexOf(".");
        sClassName = sClassName.substring(iLastDot + 1);
        String sDeclaration = "    private DropletCustomComponent " + this.getIdentifier(theObject) + ";";
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + sDeclaration;
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "\r\n";
    }

    public void generateAccessor(MetaObject theObject) {
        String sAccessorCode;
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sClassName.lastIndexOf(".");
        sClassName = sClassName.substring(iLastDot + 1);
        if (theObject.equals(theObject.theDesignProject.getFirstObject())) {
            sAccessorCode = "public Object getRenderingDestination() {\r\n";
            sAccessorCode = sAccessorCode + "return this.thePanel;\r\n}\r\n\r\n";
            this.theBufferCollection.sAccessorBuffer = this.theBufferCollection.sAccessorBuffer + sAccessorCode;
        }
        sAccessorCode = "public DropletCustomComponent get" + theObject.getName() + "() {\r\n";
        sAccessorCode = sAccessorCode + "return " + this.getIdentifier(theObject) + ";\r\n}\r\n\r\n";
        this.theBufferCollection.sAccessorBuffer = this.theBufferCollection.sAccessorBuffer + sAccessorCode;
    }

    public void generateBuilder(MetaObject theObject) {
        String sClassName = theObject.theClass.theMetadata.sFullClassName;
        int iLastDot = sClassName.lastIndexOf(".");
        sClassName = sClassName.substring(iLastDot + 1);
        String sBuildCode = this.getIdentifier(theObject) + " = (DropletCustomComponent) theRenderer.createInterfaceObject(\"" + theObject.getName() + "\", \"" + theObject.theClass.theMetadata.sClassName + "\");";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sBuildCode;
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "\r\n";
    }

    public void generatePropertySettings(MetaObject theObject) throws HammerException {
        String sSetCode = "";
        MetaProperty theProperty = theObject.theFirstProperty;
        String metaClassName = theProperty.theObject.theType.theName;
        while (theProperty != null) {
            String sPropertySet = this.generatePropertyCode(theProperty);
            if (theProperty.thePropertyInfo != null) {
                String sSetMethod = theProperty.thePropertyInfo.getSetMethod();
                boolean bIsObjReference = theProperty.thePropertyInfo.bObjectReference;
                String sObjectPrefix = "";
                if (sSetMethod.equals("setSize")) {
                    sSetCode = sSetCode + sObjectPrefix + this.getIdentifier(theObject) + ".setSize(" + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                } else if (sSetMethod.equals("setLocation")) {
                    sSetCode = sSetCode + sObjectPrefix + this.getIdentifier(theObject) + ".setLocation(" + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                } else if (sSetMethod.equals("setBackground")) {
                    sSetCode = sSetCode + sObjectPrefix + this.getIdentifier(theObject) + ".setBackground(" + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                } else if (sSetMethod.equals("setForeground")) {
                    sSetCode = sSetCode + sObjectPrefix + this.getIdentifier(theObject) + ".setForeground(" + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                } else if (sSetMethod.equals("setFont")) {
                    sSetCode = sSetCode + sObjectPrefix + this.getIdentifier(theObject) + ".setFont(" + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                } else if (sSetMethod != null && sSetMethod.length() > 0 && !bIsObjReference) {
                    sSetCode = sSetCode + this.getIdentifier(theObject) + ".setRemoteAttributeValue(\"" + theProperty.thePropertyInfo.getName() + "\"," + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                } else if (sSetMethod != null && sSetMethod.length() > 0 && bIsObjReference) {
                    String sProjectName = theObject.theDesignProject.getName();
                    int iIndex = sProjectName.indexOf(".");
                    sProjectName = sProjectName.substring(0, iIndex);
                    sSetCode = sSetCode + this.getIdentifier(theObject) + ".setRemoteAttributeObjectReference(" + theProperty.thePropertyInfo.getName() + sPropertySet + ")";
                    sSetCode = sSetCode + ";\r\n";
                }
            }
            theProperty = theProperty.theNextProperty;
        }
        sSetCode = this.generateObjectEventClasses(sSetCode, theObject);
        this.theBufferCollection.sPropertyMethodBuffer = this.theBufferCollection.sPropertyMethodBuffer + "\r\nvoid set_" + this.getIdentifier(theObject) + "_properties(AbaRendererInterface theRenderer) {\r\n" + sSetCode + "\r\n}\r\n";
        this.theBufferCollection.sPropertyBuffer = metaClassName.equalsIgnoreCase("JSSDataSource") ? "set_" + this.getIdentifier(theObject) + "_properties(theRenderer);\r\n" + this.theBufferCollection.sPropertyBuffer : this.theBufferCollection.sPropertyBuffer + "set_" + this.getIdentifier(theObject) + "_properties(theRenderer);\r\n";
    }

    public void generateAttachmentCode(MetaObject theObject) {
        int iContainerType = theObject.getContainerType();
        String sLayoutConstruction = "";
        switch (iContainerType) {
            case 4: {
                this.setContainerName(theObject, this.getIdentifier(theObject));
                break;
            }
            case 6: {
                break;
            }
            case 2: 
            case 7: {
                this.setLayoutName(theObject, this.getIdentifier(theObject));
                this.setContainerName(theObject, this.getIdentifier(theObject));
                break;
            }
            case 3: 
            case 5: {
                this.setLayoutName(theObject, "this.thePanel");
                this.setContainerName(theObject, "thePanel");
                sLayoutConstruction = sLayoutConstruction + "theRenderer.addFocus(null," + this.getIdentifier(theObject) + ");\r\n";
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            case 8: 
            case 9: {
                this.setContainerName(theObject, this.getIdentifier(theObject));
                break;
            }
            case 10: {
                this.setContainerName(theObject, this.getIdentifier(theObject));
            }
        }
        String sVariableToAttach = this.getIdentifier(theObject);
        String sAttachmentCode = "";
        MetaObject theParentContainer = theObject.getVisualContainerObject(true);
        if (theParentContainer != null) {
            int iParentContainerType = theParentContainer.getContainerType();
            switch (iParentContainerType) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 10: {
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    sAttachmentCode = sAttachmentCode + this.getContainerName(theParentContainer) + ".addComponent(" + sVariableToAttach + ");\r\n";
                    String sAnchoringValue = "";
                    if (theObject.bLeftAnchoring) {
                        sAnchoringValue = sAnchoringValue + "Component.ANCHOR_WEST +";
                    }
                    if (theObject.bRightAnchoring) {
                        sAnchoringValue = sAnchoringValue + "Component.ANCHOR_EAST +";
                    }
                    if (theObject.bTopAnchoring) {
                        sAnchoringValue = sAnchoringValue + "Component.ANCHOR_TOP +";
                    }
                    if (theObject.bBottomAnchoring) {
                        sAnchoringValue = sAnchoringValue + "Component.ANCHOR_SOUTH +";
                    }
                    if (sAnchoringValue.length() > 0) {
                        sAttachmentCode = sAttachmentCode + this.getIdentifier(theObject) + ".setAnchor(" + sAnchoringValue + ");\r\n";
                    }
                    sAttachmentCode = sAttachmentCode + "theRenderer.addFocus(" + this.getIdentifier(theParentContainer) + "," + sVariableToAttach + ");\r\n";
                    break;
                }
                case 4: {
                    break;
                }
                case 8: {
                    break;
                }
            }
        }
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sLayoutConstruction;
        this.theBufferCollection.sAttachmentBuffer = this.theBufferCollection.sAttachmentBuffer + sAttachmentCode;
    }

    public void generateProjectCode(String sClassName, MetaProject theProject) throws HammerException {
        this.Variables = new HashMap(0);
        this.VariableClasses = new HashMap(0);
        this.vectorConstants = new Vector(0);
        this.generatePrologCode(theProject, sClassName);
        MetaObject objTest = theProject.getFirstObject();
        while (objTest != null) {
            this.generateObjectCode(objTest);
            objTest = objTest.theNextObject;
        }
        this.generateEpilogCode(theProject);
    }

    public Vector doImports(MetaProject theProject, MetaClass theClass, Vector vImports) {
        String sSuperClass = theClass.theMetadata.sFullClassName;
        return vImports;
    }

    public String doImports(MetaProject theProject) {
        String sImports = "";
        Vector<String> vImports = new Vector<String>();
        vImports.add("java.util.*");
        vImports.add("ch.abacus.lib.ui.renderer.abaRenderer.AbaRendererInterface");
        vImports.add("ch.abacus.lib.ui.renderer.droplets.DropletRenderer");
        vImports.add("ch.abacus.lib.ui.renderer.droplets.DropletPanel");
        vImports.add("ch.abacus.lib.ui.renderer.droplets.DropletCustomComponent");
        vImports.add("ch.abacus.lib.ui.renderer.common.RenderingProjectInterface");
        vImports.add("com.droplets.api.*");
        for (int i = 0; i < vImports.size(); ++i) {
            String sImport = (String)vImports.get(i);
            sImports = sImports + "import " + sImport + ";\r\n";
        }
        return sImports;
    }

    public void addLocalNLSDocuments(MetaProject theProject) {
        int iDocCount = theProject.theLocalNLSDocuments.size();
        for (int i = 0; i < iDocCount; ++i) {
            HammerNLSAccess theNLSDoc = (HammerNLSAccess)theProject.theLocalNLSDocuments.get(i);
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "theRenderer.addNLSDocument(\"" + MetaConstantGroup.preserveEscapeSequences(theNLSDoc.sDocument) + "\",\"" + theNLSDoc.sKey + "\");\r\n";
        }
    }

    public void generatePrologCode(MetaProject theProject, String sClassName) {
        String sImports = this.doImports(theProject);
        int iMatch = sClassName.indexOf(46);
        if (iMatch != -1) {
            sClassName = sClassName.substring(0, iMatch);
        }
        this.theBufferCollection.sImportBuffer = sImports + "\r\n";
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "\r\npublic class " + sClassName + " implements RenderingProjectInterface {\r\n";
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "DropletRenderer theRenderer;\r\n";
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "DropletPanel thePanel;\r\n";
        this.theBufferCollection.sAssignmentBuffer = "public " + sClassName + "(DropletRenderer theRenderer, DropletPanel panel) {\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "this.theRenderer = theRenderer;\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "theRenderer.theLog.writeMessage((\"Inside the AbaRenderer_Droplet constructor\"));\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "this.thePanel = thePanel;\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "theRenderer.theLog.writeMessage((\"Invoking add all components for class " + sClassName + "\"));\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "addAllComponents(theRenderer, panel); \r\n}\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "\r\n";
        String sMainObjectIdentifier = theProject.getFirstObject().getName();
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "void addAllComponents(DropletRenderer theRenderer, DropletPanel thePanel) {\r\n";
        this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "theRenderer.theLog.writeMessage((\"Inside add all components for class " + sClassName + "\"));\r\n";
        this.addLocalNLSDocuments(theProject);
    }

    ListenerDiscriminator findDiscriminator(ArrayList theDiscriminators, MetaClassDetail theClass) {
        int iDiscriminators = theDiscriminators.size();
        for (int i = 0; i < iDiscriminators; ++i) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (!theDiscriminator.theClass.equals(theClass)) continue;
            return theDiscriminator;
        }
        return null;
    }

    public void listenerPrint(String sOutputString) {
        this.theBufferCollection.sEventClassBuffer = this.theBufferCollection.sEventClassBuffer + sOutputString;
    }

    public void listenerPrintln(String sOutputString) {
        sOutputString = sOutputString + "\r\n";
        this.listenerPrint(sOutputString);
    }

    public String generateObjectEventClasses(String sSetCode, MetaObject theObject) {
        int i;
        ListenerDiscriminator theDiscriminator;
        MetaMethodLinkage theMethod = theObject.theFirstMethod;
        ArrayList<MetaClassDetail> theListeners = new ArrayList<MetaClassDetail>(0);
        ArrayList<ListenerDiscriminator> theDiscriminators = new ArrayList<ListenerDiscriminator>(0);
        ArrayList<ListenerDiscriminator> theSpecialDiscriminators = new ArrayList<ListenerDiscriminator>(0);
        while (theMethod != null) {
            MetaClassDetail theClass = theMethod.theListener;
            if (!theListeners.contains(theClass)) {
                theListeners.add(theMethod.theListener);
                theDiscriminator = new ListenerDiscriminator(theClass);
                theDiscriminators.add(theDiscriminator);
                theDiscriminator.addMethod(theMethod);
            } else {
                theDiscriminator = this.findDiscriminator(theDiscriminators, theClass);
                theDiscriminator.addMethod(theMethod);
            }
            theMethod = theMethod.theNextMethod;
        }
        for (i = 0; i < theDiscriminators.size(); ++i) {
            theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (!theDiscriminator.isSpecial()) continue;
            theSpecialDiscriminators.add(theDiscriminator);
        }
        for (i = 0; i < theSpecialDiscriminators.size(); ++i) {
            boolean bIsAdapter;
            theDiscriminator = (ListenerDiscriminator)theSpecialDiscriminators.get(i);
            MetaClassDetail theListener = theDiscriminator.theClass;
            String sListenerName = theListener.sClassName;
            String sOutputIdentifier = this.getIdentifier(theObject);
            int iMatchingListener = this.theListenerCollection.getDefaultListenerClass(sListenerName);
            sSetCode = sSetCode + sOutputIdentifier + ".";
            ListenerEntry theEntry = this.theListenerCollection.objDefaultListeners[iMatchingListener];
            sSetCode = sSetCode + theEntry.getAddListenerMethod() + "(";
            sSetCode = sSetCode + "new " + sOutputIdentifier + "$$$" + sListenerName + "());\r\n";
            this.listenerPrintln("/***__@Listener: [" + sOutputIdentifier + "$$$" + sListenerName + "] ***/");
            this.listenerPrint("class " + sOutputIdentifier + "$$$" + sListenerName);
            boolean bl = bIsAdapter = sListenerName.lastIndexOf("Adapter") != -1;
            if (bIsAdapter) {
                this.listenerPrintln(" extends " + sListenerName + "  {");
            } else {
                this.listenerPrintln(" implements " + sListenerName + "  {");
            }
            for (int j = 0; j < theDiscriminator.theMethods.size(); ++j) {
                MetaMethodLinkage theListenerMethodLink = (MetaMethodLinkage)theDiscriminator.theMethods.get(j);
                MetaMethod theListenerMethod = theListenerMethodLink.theMethod;
                String sCode = theListenerMethod.getCode();
                if (sCode.trim().length() != 0) {
                    this.listenerPrintln("/***__@Method: [" + theListenerMethod.getMethodName() + "] ***/");
                    this.listenerPrintln(sCode);
                    this.listenerPrintln("/***__@@Method: [" + theListenerMethod.getMethodName() + "] ***/");
                }
                theListenerMethod = theListenerMethod.getNextMethod();
            }
            this.listenerPrintln("  }");
            this.listenerPrintln("/***__@@Listener: [" + sListenerName + "] ***/");
        }
        return sSetCode;
    }

    public void generateEpilogCode(MetaProject theProject) {
        String sValue;
        String sClassName;
        String sProjectName = theProject.getName();
        int iIndex = sProjectName.indexOf(".");
        sProjectName = sProjectName.substring(0, iIndex);
        this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + "Object oTemp;\r\n";
        for (int i = 0; i < this.vectorConstants.size(); ++i) {
            String sCombinedKey = (String)this.vectorConstants.get(i);
            int iMatch1 = sCombinedKey.indexOf("|?|");
            int iMatch2 = sCombinedKey.indexOf("|?|", iMatch1 + 1);
            sClassName = sCombinedKey.substring(0, iMatch1);
            String sConstantName = sCombinedKey.substring(iMatch1 + 3, iMatch2);
            sValue = sCombinedKey.substring(iMatch2 + 3);
            this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + sClassName + " " + sValue + ";\r\n";
            if (sClassName.equals("int")) {
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "oTemp = theRenderer.createConstantObject(\"" + sValue + "\",\"" + sConstantName + "\");\r\n";
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "if (oTemp instanceof String)\r\n";
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + "oTemp = new Integer((String)oTemp);\r\n";
                this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sValue + " = ((Integer)oTemp).intValue();\r\n";
                continue;
            }
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + sValue + " = (" + sClassName + ") theRenderer.createConstantObject(\"" + sValue + "\",\"" + sConstantName + "\");\r\n";
        }
        Object[] identifiers = this.Variables.keySet().toArray();
        for (int i = 0; i < identifiers.length; ++i) {
            String sKey = (String)identifiers[i];
            int iMatch = sKey.indexOf("|*|");
            sClassName = sKey.substring(0, iMatch);
            String identifier = sKey.substring(iMatch + 3);
            sValue = (String)this.Variables.get(sKey);
            this.theBufferCollection.sDeclBuffer = this.theBufferCollection.sDeclBuffer + sClassName + " " + identifier + ";";
            this.theBufferCollection.sAssignmentBuffer = this.theBufferCollection.sAssignmentBuffer + identifier + " = (" + sClassName + ") theRenderer.resolveConstantValue(\"" + sValue + "\");\r\n";
        }
        this.theBufferCollection.sAccessorBuffer = this.theBufferCollection.sAccessorBuffer + "\r\n" + this.theBufferCollection.sPropertyMethodBuffer;
    }

    public String generatePropertyCode(MetaProperty theProperty) throws HammerException {
        String sReturnValue = "";
        int iSize = theProperty.theIndexedValue.size();
        for (int i = 0; i < iSize; ++i) {
            if (sReturnValue.length() > 0) {
                sReturnValue = sReturnValue + ",";
            }
            MetaParameter theParameter = (MetaParameter)theProperty.theIndexedValue.get(i);
            sReturnValue = sReturnValue + this.generateParameterCode(theParameter, theProperty.thePropertyInfo);
        }
        return sReturnValue;
    }

    public String generateParameterCode(MetaParameter theParameter, MetaPropertyDescriptor thePropDesc) throws HammerException {
        String sTestValue = theParameter.getLiteralValue();
        if (thePropDesc == null) {
            return "";
        }
        if (theParameter.theSimpleType != null && (theParameter.theSimpleType.equalsIgnoreCase("java.lang.String") || theParameter.theSimpleType.equalsIgnoreCase("String"))) {
            sTestValue = sTestValue.indexOf(92) != -1 || sTestValue.indexOf(34) != -1 ? MetaConstantGroup.preserveEscapeSequences("\"" + sTestValue + "\"") : "theRenderer.doNLSTranslation(\"" + sTestValue + "\")";
        } else if (theParameter.getMnemonic() && thePropDesc.getName() != null && thePropDesc.getName().equalsIgnoreCase("mnemonic")) {
            sTestValue = "theRenderer.doNLSMnemonicTranslation(\"" + sTestValue + "\")";
        }
        return this.doCodeGenerationForConstants(theParameter, theParameter.theDesignProject, sTestValue, thePropDesc);
    }

    public String doCodeGenerationForConstants(MetaParameter theParameter, MetaProject theProject, String sTestValue, MetaPropertyDescriptor thePropDesc) throws HammerException {
        String sMatch = null;
        if (thePropDesc != null && thePropDesc.getIncludeTypeConstants() != null) {
            MetaConstantGroup theConstantTable = theProject.findConstantGroup(thePropDesc.getIncludeTypeConstants());
            if (theConstantTable != null) {
                sMatch = theConstantTable.getKey(sTestValue);
            } else {
                MetaConstantGroupCollection theConstantTableCollection = theProject.findConstantGroupCollection(thePropDesc.getIncludeTypeConstants());
                if (theConstantTableCollection != null) {
                    sMatch = theConstantTableCollection.getKey(sTestValue);
                }
            }
            if (sMatch != null) {
                String sCombinedKey = thePropDesc.getClassName() + "|?|" + thePropDesc.getIncludeTypeConstants() + "|?|" + sMatch;
                if (!this.vectorConstants.contains(sCombinedKey)) {
                    this.vectorConstants.add(sCombinedKey);
                }
                sTestValue = sMatch;
            } else {
                Object theThing = MetaConstantGroup.resolve(sTestValue, theParameter.theDesignProject.getMetadataDispenser(), theParameter.theDesignProject.getMetaDataUser().getClassLoader().getLoader());
                String sClass = thePropDesc.getClassName();
                if (!sClass.equals("String") && !(theThing instanceof String)) {
                    sMatch = this.lookupIdentifier(thePropDesc.getClassName(), sTestValue);
                    if (sMatch == null) {
                        sMatch = this.makeIdentifier(thePropDesc.getClassName(), sTestValue);
                    }
                    sTestValue = sMatch;
                }
            }
        } else {
            String sClassName = thePropDesc.getClassName();
            if (!sClassName.endsWith("String") && sTestValue.indexOf("construct") != -1) {
                sMatch = this.lookupIdentifier(thePropDesc.getClassName(), sTestValue);
                if (sMatch == null) {
                    sMatch = this.makeIdentifier(thePropDesc.getClassName(), sTestValue);
                }
                sTestValue = sMatch;
            }
        }
        return sTestValue;
    }

    public String getDeclarationBuffer() {
        return this.theBufferCollection.sDeclBuffer;
    }

    public String getAssignmentBuffer() {
        return this.theBufferCollection.sAssignmentBuffer;
    }

    public BufferCollection getBufferCollection() {
        return this.theBufferCollection;
    }

    public void setAssignmentBuffer(String sAssignmentBuffer) {
        this.theBufferCollection.sAssignmentBuffer = sAssignmentBuffer;
    }

    public void setDeclarationBuffer(String sDeclarationBuffer) {
        this.theBufferCollection.sDeclBuffer = sDeclarationBuffer;
    }

    public String lookupIdentifier(String className, String sTestValue) {
        return (String)this.Variables.get(className + "|*|" + sTestValue);
    }

    public String makeIdentifier(String className, String sTestValue) {
        Integer classVariableCount = (Integer)this.VariableClasses.get(className);
        int iClassVarCount = 0;
        if (classVariableCount != null) {
            try {
                iClassVarCount = classVariableCount + 1;
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
        }
        String sIdentifier = className;
        int iDotPos = sIdentifier.lastIndexOf(".");
        sIdentifier = className.substring(iDotPos + 1) + "_" + iClassVarCount;
        this.Variables.put(className + "|*|" + sIdentifier, sTestValue);
        this.VariableClasses.put(className, new Integer(iClassVarCount));
        return sIdentifier;
    }

    public ListenerCollection getListenerCollection() {
        return this.theListenerCollection;
    }

    public void setListenerCollection(ListenerCollection theListenerCollection) {
        this.theListenerCollection = theListenerCollection;
    }

    public String getFormattedSource() {
        String sSourceCode = this.theBufferCollection.sImportBuffer + "\r\n" + this.theBufferCollection.sDeclBuffer + "\r\n" + this.theBufferCollection.sAccessorBuffer + "\r\n" + this.theBufferCollection.sAssignmentBuffer1 + "\r\n" + "\r\n" + this.theBufferCollection.sAssignmentBuffer2 + "\r\n" + "\r\n" + this.theBufferCollection.sAssignmentBuffer3 + "\r\n" + this.theBufferCollection.sEventClassBuffer + "\r\n" + this.theBufferCollection.sAssignmentBuffer + "\r\n" + this.theBufferCollection.sPropertyBuffer + "\r\n" + this.theBufferCollection.sAttachmentBuffer + "\r\n" + "}\r\n}\r\n";
        CodeFormatter theFormatter = new CodeFormatter();
        StringReader theReader = new StringReader(sSourceCode);
        StringWriter theWriter = new StringWriter(sSourceCode.length());
        theFormatter.formatCode((Reader)theReader, (Writer)theWriter);
        return theWriter.getBuffer().toString();
    }

    public void reset() {
        this.theBufferCollection = new BufferCollection();
    }

    public boolean doTemplateFile(String sTemplateFile, String sReplaceString, String sExtension) {
        String sOutputFile = sReplaceString + sTemplateFile;
        sOutputFile = sOutputFile.substring(0, sOutputFile.lastIndexOf(".") + 1) + sExtension;
        sTemplateFile = sStub + sTemplateFile;
        Object streamIn = null;
        Object streamOut = null;
        File fileInputTest = new File(sTemplateFile);
        if (!fileInputTest.isFile()) {
            return false;
        }
        File fileOutputTest = new File(sOutputFile);
        if (!fileOutputTest.isFile()) {
            try {
                fileOutputTest.createNewFile();
            }
            catch (IOException e1) {
                return false;
            }
        }
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(fileInputTest));
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            writer = new BufferedWriter(new FileWriter(fileOutputTest));
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        String sLine = "";
        try {
            while ((sLine = reader.readLine()) != null) {
                sLine = sLine.replaceAll(sFindString, sReplaceString);
                sLine = sLine + "\r\n";
                writer.write(sLine);
            }
            reader.close();
            writer.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void doTemplateFiles(String sDocumentName) {
        int iDotPos = sDocumentName.lastIndexOf(".");
        if (iDotPos != -1) {
            String sFileSeparator;
            String sBase = sDocumentName.substring(0, iDotPos - 1);
            int iMatchSlash = sBase.lastIndexOf(sFileSeparator = System.getProperty("file.separator"));
            if (iMatchSlash != -1) {
                sBase = sBase.substring(iMatchSlash + sFileSeparator.length());
            }
            this.doTemplateFile("AppFactory.template", sBase, "java");
            this.doTemplateFile("MainWindow.template", sBase, "java");
        }
    }
}

