/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.programmableCompiler;

import ch.abacus.lib.ui.renderer.programmableCompiler.ClassByteLoader;
import java.util.Hashtable;

public class CustomClassLoader
extends ClassLoader {
    private Hashtable hashtable;
    private ClassByteLoader classByteLoader;

    public CustomClassLoader(ClassByteLoader classByteLoader) {
        this.classByteLoader = classByteLoader;
        this.hashtable = new Hashtable();
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> resultClass;
        try {
            resultClass = this.findSystemClass(name);
        }
        catch (Exception e1) {
            Object lookup = this.hashtable.get(name);
            if (lookup != null) {
                resultClass = (Class<?>)lookup;
            }
            try {
                byte[] classBytes = this.classByteLoader.get(name);
                if (classBytes == null) {
                    throw new ClassNotFoundException("ClassByteLoader.get returned null for class " + name);
                }
                resultClass = this.defineClass(name, classBytes, 0, classBytes.length);
            }
            catch (ClassFormatError e2) {
                throw new ClassNotFoundException("format of class file incorrect for class " + name + ": " + e2.getMessage());
            }
        }
        if (resolve) {
            this.resolveClass(resultClass);
        }
        this.hashtable.put(name, resultClass);
        return resultClass;
    }
}

