/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.util.math;

public class LinearCongruence {
    private int current;
    private int b;
    private int m;
    private static final int MULT_HELP = 10000;
    private static final LinearCongruence LC = new LinearCongruence((int)System.currentTimeMillis());

    public LinearCongruence(int seed, int b, int m) {
        this.current = seed;
        this.b = b;
        if (m >= 0x3FFFFFFF) {
            throw new RuntimeException("m is too big");
        }
        this.m = m;
    }

    public LinearCongruence(int seed) {
        this(seed, 31415821, 100000000);
    }

    public int nextSimple() {
        this.current = (this.current * this.b + 1) % this.m;
        return this.current;
    }

    public int next() {
        this.current = (this.mult(this.current, this.b) + 1) % this.m;
        return this.current;
    }

    public final int mult(int p, int q) {
        int p1 = p / 10000;
        int p0 = p % 10000;
        int q1 = q / 10000;
        int q0 = q % 10000;
        int t = (p0 * q1 + p1 * q0) % 10000 * 10000 + p0 * q0;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int random() {
        LinearCongruence linearCongruence = LC;
        synchronized (linearCongruence) {
            return LC.next();
        }
    }
}

