/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf;

import com.jgoodies.plaf.FontSizeHints;
import com.jgoodies.plaf.LookUtils;
import java.awt.Font;
import java.security.AccessController;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import sun.security.action.GetPropertyAction;

public final class FontUtils {
    private FontUtils() {
    }

    public static boolean useSystemFontSettings() {
        boolean useSystemFontSettings;
        String systemFonts = AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
        boolean bl = useSystemFontSettings = systemFonts == null || systemFonts.equals("true");
        if (useSystemFontSettings) {
            Object value = UIManager.get("Application.useSystemFontSettings");
            useSystemFontSettings = value == null || Boolean.TRUE.equals(value);
        }
        return useSystemFontSettings;
    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont, Object windowFont) {
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont, "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont};
        table.putDefaults(defaults);
        if (menuFont != null) {
            Object[] menuDefaults = new Object[]{"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(menuDefaults);
        }
    }

    public static Font getMenuFont(UIDefaults table, FontSizeHints hints) {
        Font menuFont;
        String fontDescription = LookUtils.getSystemProperty("jgoodies.menuFont", null);
        if (fontDescription != null) {
            return Font.decode(fontDescription);
        }
        if (LookUtils.IS_BEFORE_14) {
            menuFont = FontUtils.guessFont(hints.menuFontSize());
        } else {
            menuFont = table.getFont("Menu.font");
            if (menuFont.getName().equals("Tahoma")) {
                float size = (float)menuFont.getSize() + hints.menuFontSizeDelta();
                float minSize = hints.menuFontSize();
                menuFont = menuFont.deriveFont(Math.max(minSize, size));
            }
        }
        return new FontUIResource(menuFont);
    }

    public static Font getControlFont(UIDefaults table, FontSizeHints hints) {
        Font controlFont;
        String fontDescription = LookUtils.getSystemProperty("jgoodies.controlFont", null);
        if (fontDescription != null) {
            return Font.decode(fontDescription);
        }
        if (LookUtils.IS_BEFORE_14) {
            controlFont = FontUtils.guessFont(hints.controlFontSize());
        } else {
            String fontKey = LookUtils.IS_140 ? "Label.font" : "OptionPane.font";
            controlFont = table.getFont(fontKey);
            if (controlFont.getName().equals("Tahoma")) {
                float oldSize = controlFont.getSize();
                float minSize = hints.controlFontSize();
                float size = oldSize + hints.controlFontSizeDelta();
                controlFont = controlFont.deriveFont(Math.max(minSize, size));
            }
        }
        return new FontUIResource(controlFont);
    }

    public static Font guessFont(int size) {
        String fontName = LookUtils.isModernWindows() ? "Tahoma" : "dialog";
        return new Font(fontName, 0, size);
    }
}

