/*
 * Decompiled with CFR 0.152.
 */
package net.janino;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.janino.ClassFileIClass;
import net.janino.ClassLoaderIClassLoader;
import net.janino.Descriptor;
import net.janino.IClass;
import net.janino.IClassLoader;
import net.janino.Java;
import net.janino.Parser;
import net.janino.Scanner;
import net.janino.util.Benchmark;
import net.janino.util.ClassFile;
import net.janino.util.PathClassLoader;
import net.janino.util.StringPattern;
import net.janino.util.TunnelException;
import net.janino.util.resource.PathResourceFinder;
import net.janino.util.resource.ResourceFinder;

public class Compiler {
    private static final boolean DEBUG = false;
    private static final String[] USAGE = new String[]{"Usage:", "", "  java net.janino.Compiler [ <option> ] ... <source-file> ...", "", "Supported <option>s are:", "  -d <output-dir>           Where to save class files", "  -sourcepath <dirlist>     Where to look for other source files", "  -classpath <dirlist>      Where to look for other class files", "  -extdirs <dirlist>        Where to look for other class files", "  -bootclasspath <dirlist>  Where to look for other class files", "  -encoding <encoding>      Encoding of source files, e.g. \"UTF-8\" or \"ISO-8859-1\"", "  -verbose", "  -g                        Generate all debugging info", "  -g:none                   Generate no debugging info", "  -g:{lines,vars,source}    Generate only some debugging info", "  -warn:<pattern-list>      Issue certain warnings; examples:", "    -warn:*                 Enables all warnings", "    -warn:IASF              Only warn against implicit access to static fields", "    -warn:*-IASF            Enables all warnings, except those against implicit", "                            access to static fields", "    -warn:*-IA*+IASF        Enables all warnings, except those against implicit", "                            accesses, but do warn against implicit access to", "                            static fields", "  -rebuild                  Compile all source files, even if the class files", "                            seems up-to-date", "  -help", "", "The default encoding in this environment is \"" + new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding() + "\"."};
    private File optionalDestinationDirectory;
    private String optionalCharacterEncoding;
    private Benchmark benchmark;
    private int debuggingInformation;
    private StringPattern[] optionalWarningHandlePatterns;
    private boolean rebuild;
    private IClassLoader iClassLoader;
    private final ArrayList parsedCompilationUnits = new ArrayList();

    public Compiler(File[] fileArray, File[] fileArray2, File[] fileArray3, File[] fileArray4, File file, String string, boolean bl, int n, StringPattern[] stringPatternArray, boolean bl2) {
        this.optionalDestinationDirectory = file;
        this.optionalCharacterEncoding = string;
        this.benchmark = new Benchmark(bl);
        this.debuggingInformation = n;
        this.optionalWarningHandlePatterns = stringPatternArray;
        this.rebuild = bl2;
        this.benchmark.report("*** JANINO - an embedded compiler for the Java(TM) programming language");
        this.benchmark.report("*** For more information visit http://www.janino.net");
        this.benchmark.report("Destination directory", file);
        this.benchmark.report("Source path", fileArray);
        this.benchmark.report("Class path", fileArray2);
        this.benchmark.report("Ext dirs", fileArray3);
        this.benchmark.report("Boot class path", fileArray4);
        this.benchmark.report("Character encoding", string);
        this.benchmark.report("Verbose", new Boolean(bl));
        this.benchmark.report("Debugging information", new Integer(n));
        this.benchmark.report("Warning handle patterns", stringPatternArray);
        ClassLoader classLoader = new ClassLoader(null){};
        classLoader = new PathClassLoader(fileArray4 == null ? PathResourceFinder.parsePath(System.getProperty("sun.boot.class.path")) : fileArray4, classLoader);
        classLoader = new PathClassLoader(fileArray3 == null ? PathResourceFinder.parsePath(System.getProperty("java.ext.dirs")) : fileArray3, classLoader);
        classLoader = new PathClassLoader(fileArray2, classLoader);
        ResourceFinder resourceFinder = fileArray == null ? ((PathClassLoader)classLoader).getResourceFinder() : new PathResourceFinder(fileArray);
        this.iClassLoader = new CompilerIClassLoader(resourceFinder, string, classLoader);
    }

    public void compile(File[] fileArray) throws Scanner.ScanException, Parser.ParseException, Java.CompileException, IOException {
        this.benchmark.report("Source files", fileArray);
        this.benchmark.beginReporting();
        try {
            Java.setWarningHandlePatterns(this.optionalWarningHandlePatterns);
            this.parsedCompilationUnits.clear();
            int n = 0;
            while (n < fileArray.length) {
                this.parsedCompilationUnits.add(this.parseCompilationUnit(fileArray[n].getPath(), new FileInputStream(fileArray[n]), this.optionalCharacterEncoding));
                ++n;
            }
            int n2 = 0;
            while (n2 < this.parsedCompilationUnits.size()) {
                Object var10_7;
                ClassFile[] classFileArray;
                Java.CompilationUnit compilationUnit = (Java.CompilationUnit)this.parsedCompilationUnits.get(n2);
                File file = new File(compilationUnit.getFileName());
                this.benchmark.beginReporting("Compiling compilation unit \"" + file + "\"");
                try {
                    try {
                        classFileArray = compilationUnit.compile(this.iClassLoader, this.debuggingInformation);
                    }
                    catch (TunnelException tunnelException) {
                        Throwable throwable = tunnelException.getDelegate();
                        if (throwable instanceof Scanner.ScanException) {
                            throw (Scanner.ScanException)throwable;
                        }
                        if (throwable instanceof Parser.ParseException) {
                            throw (Parser.ParseException)throwable;
                        }
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        throw tunnelException;
                    }
                    var10_7 = null;
                    this.benchmark.endReporting();
                }
                catch (Throwable throwable) {
                    var10_7 = null;
                    this.benchmark.endReporting();
                    throw throwable;
                }
                this.benchmark.beginReporting("Storing " + classFileArray.length + " class file(s) resulting from compilation unit \"" + file + "\"");
                try {
                    int n3 = 0;
                    while (n3 < classFileArray.length) {
                        Compiler.storeClassFile(classFileArray[n3], file, this.optionalDestinationDirectory);
                        ++n3;
                    }
                }
                finally {
                    var10_7 = null;
                    this.benchmark.endReporting();
                }
                ++n2;
            }
        }
        finally {
            Object var3_13 = null;
            this.benchmark.endReporting("Compiled " + this.parsedCompilationUnits.size() + " compilation unit(s)");
        }
    }

    public static File getClassFile(String string, File file, File file2) {
        if (file2 != null) {
            return new File(file2, String.valueOf(string.replace('.', File.separatorChar)) + ".class");
        }
        int n = string.lastIndexOf(46);
        return new File(file.getParentFile(), String.valueOf(string.substring(n + 1)) + ".class");
    }

    public static void main(String[] stringArray) {
        Object object;
        File[] fileArray;
        File file = null;
        File[] fileArray2 = null;
        File[] fileArray3 = new File[]{new File(".")};
        File[] fileArray4 = null;
        File[] fileArray5 = null;
        String string = null;
        boolean bl = false;
        int n = 3;
        StringPattern[] stringPatternArray = null;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            fileArray = stringArray[n2];
            if (fileArray.charAt(0) != '-') break;
            if (fileArray.equals("-d")) {
                file = new File(stringArray[++n2]);
            } else if (fileArray.equals("-sourcepath")) {
                fileArray2 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-classpath")) {
                fileArray3 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-extdirs")) {
                fileArray4 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-bootclasspath")) {
                fileArray5 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-encoding")) {
                string = stringArray[++n2];
            } else if (fileArray.equals("-verbose")) {
                bl = true;
            } else if (fileArray.equals("-g")) {
                n = 7;
            } else if (fileArray.equals("-g:none")) {
                n = 0;
            } else if (fileArray.startsWith("-g:")) {
                n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(fileArray.substring(3), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if ("source".equals(object)) {
                        n |= 1;
                        continue;
                    }
                    if ("lines".equals(object)) {
                        n |= 2;
                        continue;
                    }
                    if (!"vars".equals(object)) continue;
                    n |= 4;
                }
            } else if (fileArray.startsWith("-warn:")) {
                stringPatternArray = StringPattern.parseCombinedPattern(fileArray.substring(6));
            } else if (fileArray.equals("-rebuild")) {
                bl2 = true;
            } else if (fileArray.equals("-help")) {
                int n3 = 0;
                while (n3 < USAGE.length) {
                    System.out.println(USAGE[n3]);
                    ++n3;
                }
                System.exit(1);
            } else {
                System.err.println("Unrecognized command line option \"" + (String)fileArray + "\"; try \"-help\".");
                System.exit(1);
            }
            ++n2;
        }
        if (n2 == stringArray.length) {
            System.err.println("No source files given on command line; try \"-help\".");
            System.exit(1);
        }
        fileArray = new File[stringArray.length - n2];
        int n4 = n2;
        while (n4 < stringArray.length) {
            fileArray[n4 - n2] = new File(stringArray[n4]);
            ++n4;
        }
        object = new int[1];
        Java.setCompileErrorHandler(new Java.ErrorHandler((int[])object){
            private final /* synthetic */ int[] val$compileExceptionCount;
            {
                this.val$compileExceptionCount = nArray;
            }

            public void handleError(String string, Scanner.Location location) throws Java.CompileException {
                if (location != null) {
                    System.err.print(String.valueOf(String.valueOf(location)) + ": ");
                }
                System.err.println(string);
                this.val$compileExceptionCount[0] = this.val$compileExceptionCount[0] + 1;
                if (this.val$compileExceptionCount[0] >= 20) {
                    throw new Java.CompileException("Too many compile errors", null);
                }
            }
        });
        Java.setWarningHandler(new Java.WarningHandler(){

            public void handleWarning(String string, String string2, Scanner.Location location) {
                if (location != null) {
                    System.err.print(String.valueOf(String.valueOf(location)) + ": ");
                }
                System.err.println("Warning " + string + ": " + string2);
            }
        });
        try {
            new Compiler(fileArray2, fileArray3, fileArray4, fileArray5, file, string, bl, n, stringPatternArray, bl2).compile(fileArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        if (object[0] > 0) {
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Java.CompilationUnit parseCompilationUnit(String string, InputStream inputStream, String string2) throws Scanner.ScanException, Parser.ParseException, IOException {
        Java.CompilationUnit compilationUnit;
        Scanner scanner = string2 == null ? new Scanner(string, inputStream) : new Scanner(string, new InputStreamReader(inputStream, string2));
        try {
            this.benchmark.beginReporting("Parsing \"" + string + "\"");
            try {
                compilationUnit = new Parser(scanner).parseCompilationUnit();
                Object var9_6 = null;
                this.benchmark.endReporting();
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                this.benchmark.endReporting();
                throw throwable;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            scanner.close();
            throw throwable;
        }
        scanner.close();
        return compilationUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void storeClassFile(ClassFile classFile, File file, File file2) throws IOException {
        File file3 = Compiler.getClassFile(classFile.getThisClassName(), file, file2);
        File file4 = file3.getParentFile();
        if (file4 != null && !file4.isDirectory() && !file4.mkdirs()) {
            throw new IOException("Cannot create directory for class file \"" + file3 + "\"");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        try {
            try {
                classFile.store(fileOutputStream);
            }
            catch (IOException iOException) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {}
                fileOutputStream = null;
                if (file3.delete()) throw iOException;
                throw new IOException("Could not delete incompletely written class file \"" + file3 + "\"");
            }
            Object var7_7 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private class CompilerIClassLoader
    extends ClassLoaderIClassLoader {
        private final ResourceFinder sourceFinder;
        private final String optionalCharacterEncoding;

        public CompilerIClassLoader(ResourceFinder resourceFinder, String string, ClassLoader classLoader) {
            super(classLoader);
            this.sourceFinder = resourceFinder;
            this.optionalCharacterEncoding = string;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IClass defineIClassFromClassFile(File file) throws ClassNotFoundException {
            Compiler.this.benchmark.beginReporting("Loading class file \"" + file + "\"");
            try {
                ClassFile classFile;
                block9: {
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(file);
                            classFile = new ClassFile(fileInputStream);
                        }
                        catch (IOException iOException) {
                            throw new TunnelException(iOException);
                        }
                        Object var8_5 = null;
                        if (fileInputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var8_6 = null;
                        if (fileInputStream == null) throw throwable;
                        try {
                            ((InputStream)fileInputStream).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    ((InputStream)fileInputStream).close();
                }
                ClassFileIClass classFileIClass = new ClassFileIClass(classFile, this);
                this.defineIClass(classFileIClass);
                classFileIClass.resolveAllClasses();
                ClassFileIClass classFileIClass2 = classFileIClass;
                Object var4_10 = null;
                Compiler.this.benchmark.endReporting();
                return classFileIClass2;
            }
            catch (Throwable throwable) {
                Object var4_11 = null;
                Compiler.this.benchmark.endReporting();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IClass defineIClassFromSourceFile(File file, String string) throws ClassNotFoundException {
            Java.CompilationUnit compilationUnit;
            block10: {
                FileInputStream fileInputStream = null;
                try {
                    try {
                        fileInputStream = new FileInputStream(file);
                        compilationUnit = Compiler.this.parseCompilationUnit(file.getPath(), fileInputStream, this.optionalCharacterEncoding);
                    }
                    catch (IOException iOException) {
                        throw new TunnelException(iOException);
                    }
                    catch (Parser.ParseException parseException) {
                        throw new TunnelException(parseException);
                    }
                    catch (Scanner.ScanException scanException) {
                        throw new TunnelException(scanException);
                    }
                    Object var6_8 = null;
                    if (fileInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        ((InputStream)fileInputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)fileInputStream).close();
            }
            Compiler.this.parsedCompilationUnits.add(compilationUnit);
            IClass iClass = compilationUnit.findClass(string);
            if (iClass == null) {
                return super.findIClass(Descriptor.fromClassName(string));
            }
            this.defineIClass(iClass);
            return iClass;
        }

        protected IClass findIClass(String string) throws ClassNotFoundException, TunnelException {
            Object object;
            Object object2;
            if (Descriptor.isPrimitive(string)) {
                return super.findIClass(string);
            }
            String string2 = Descriptor.toClassName(string);
            if (string2.startsWith("java.")) {
                return super.findIClass(string);
            }
            int n = 0;
            while (n < Compiler.this.parsedCompilationUnits.size()) {
                object2 = (Java.CompilationUnit)Compiler.this.parsedCompilationUnits.get(n);
                object = ((Java.CompilationUnit)object2).findClass(string2);
                if (object != null) {
                    this.defineIClass((IClass)object);
                    return object;
                }
                ++n;
            }
            object2 = null;
            object = this.sourceFinder.findResource(ClassFile.getSourceResourceName(string2));
            if (object != null) {
                if (!((URL)object).getProtocol().equals("file")) {
                    throw new RuntimeException();
                }
                object2 = new File(((URL)object).getFile());
            }
            if (object2 == null) {
                return super.findIClass(string);
            }
            if (Compiler.this.rebuild) {
                return this.defineIClassFromSourceFile((File)object2, string2);
            }
            long l = 0L;
            l = ((File)object2).lastModified();
            if (l == 0L) {
                throw new RuntimeException();
            }
            File file = Compiler.getClassFile(string2, (File)object2, Compiler.this.optionalDestinationDirectory);
            long l2 = file.lastModified();
            if (l > l2) {
                return this.defineIClassFromSourceFile((File)object2, string2);
            }
            return this.defineIClassFromClassFile(file);
        }
    }
}

