/*
 * Decompiled with CFR 0.152.
 */
package net.janino;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.janino.Descriptor;
import net.janino.Java;
import net.janino.MethodDescriptor;

public abstract class IClass {
    private static final boolean DEBUG = false;
    private final Map memberTypeCache = new HashMap();
    private static final IClass[] ZERO_ICLASSES = new IClass[0];
    public static final int PRIVATE = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE = 2;
    public static final int PUBLIC = 3;

    public static IClass createArrayIClass(IClass iClass, final IClass iClass2) {
        return new IClass(){

            public IClass getComponentType() {
                return IClass.this;
            }

            public IClass[] getDeclaredIClasses() {
                return new IClass[0];
            }

            public IConstructor[] getDeclaredIConstructors() {
                return new IConstructor[0];
            }

            public IField[] getDeclaredIFields() {
                return new IField[0];
            }

            public IMethod[] getDeclaredIMethods() {
                return new IMethod[0];
            }

            public IClass getDeclaringIClass() {
                return null;
            }

            public String getDescriptor() {
                return String.valueOf('[') + IClass.this.getDescriptor();
            }

            public IClass[] getInterfaces() {
                return new IClass[0];
            }

            public IClass getOuterIClass() {
                return null;
            }

            public IClass getSuperclass() {
                return iClass2;
            }

            public boolean isAbstract() {
                return false;
            }

            public boolean isArray() {
                return true;
            }

            public boolean isFinal() {
                return true;
            }

            public boolean isInterface() {
                return false;
            }

            public boolean isPrimitive() {
                return false;
            }

            public boolean isPrimitiveNumeric() {
                return false;
            }

            public boolean isPublic() {
                return IClass.this.isPublic();
            }

            public String toString() {
                return String.valueOf(IClass.this.toString()) + "[]";
            }
        };
    }

    IClass[] findMemberType(String string) throws Java.CompileException {
        IClass[] iClassArray = (IClass[])this.memberTypeCache.get(string);
        if (iClassArray == null) {
            HashSet hashSet = new HashSet();
            this.findMemberType(string, hashSet);
            iClassArray = hashSet.isEmpty() ? ZERO_ICLASSES : hashSet.toArray(new IClass[hashSet.size()]);
            this.memberTypeCache.put(string, iClassArray);
        }
        return iClassArray;
    }

    private void findMemberType(String string, Collection collection) throws Java.CompileException {
        Object object;
        IClass[] iClassArray = this.getDeclaredIClasses();
        if (string == null) {
            collection.addAll(Arrays.asList(iClassArray));
        } else {
            object = Descriptor.fromClassName(String.valueOf(Descriptor.toClassName(this.getDescriptor())) + '$' + string);
            int n = 0;
            while (n < iClassArray.length) {
                IClass iClass = iClassArray[n];
                if (iClass.getDescriptor().equals(object)) {
                    collection.add(iClass);
                    return;
                }
                ++n;
            }
        }
        object = this.getSuperclass();
        if (object != null) {
            ((IClass)object).findMemberType(string, collection);
        }
        IClass[] iClassArray2 = this.getInterfaces();
        int n = 0;
        while (n < iClassArray2.length) {
            iClassArray2[n].findMemberType(string, collection);
            ++n;
        }
        IClass iClass = this.getDeclaringIClass();
        IClass iClass2 = this.getOuterIClass();
        if (iClass != null) {
            iClass.findMemberType(string, collection);
        }
        if (iClass2 != null && iClass2 != iClass) {
            iClass2.findMemberType(string, collection);
        }
    }

    public abstract IClass getComponentType();

    public abstract IClass[] getDeclaredIClasses() throws Java.CompileException;

    public abstract IConstructor[] getDeclaredIConstructors();

    public abstract IField[] getDeclaredIFields();

    public abstract IMethod[] getDeclaredIMethods();

    public abstract IClass getDeclaringIClass() throws Java.CompileException;

    public abstract String getDescriptor();

    public static String[] getDescriptors(IClass[] iClassArray) {
        String[] stringArray = new String[iClassArray.length];
        int n = 0;
        while (n < iClassArray.length) {
            stringArray[n] = iClassArray[n].getDescriptor();
            ++n;
        }
        return stringArray;
    }

    public abstract IClass[] getInterfaces() throws Java.CompileException;

    public abstract IClass getOuterIClass() throws Java.CompileException;

    public abstract IClass getSuperclass() throws Java.CompileException;

    public boolean implementsInterface(IClass iClass) throws Java.CompileException {
        IClass iClass2 = this;
        while (iClass2 != null) {
            IClass[] iClassArray = iClass2.getInterfaces();
            int n = 0;
            while (n < iClassArray.length) {
                IClass iClass3 = iClassArray[n];
                if (iClass3 == iClass || iClass3.implementsInterface(iClass)) {
                    return true;
                }
                ++n;
            }
            iClass2 = iClass2.getSuperclass();
        }
        return false;
    }

    public abstract boolean isAbstract();

    public abstract boolean isArray();

    public boolean isAssignableFrom(IClass iClass) throws Java.CompileException {
        if (this == iClass) {
            return true;
        }
        if (Java.isWideningPrimitiveConvertible(iClass, this)) {
            return true;
        }
        return Java.isWideningReferenceConvertible(iClass, this);
    }

    public abstract boolean isFinal();

    public abstract boolean isInterface();

    public abstract boolean isPrimitive();

    public abstract boolean isPrimitiveNumeric();

    public abstract boolean isPublic();

    public boolean isSubclassOf(IClass iClass) throws Java.CompileException {
        IClass iClass2 = this.getSuperclass();
        while (iClass2 != null) {
            if (iClass2 == iClass) {
                return true;
            }
            iClass2 = iClass2.getSuperclass();
        }
        return false;
    }

    public String toString() {
        return Descriptor.toClassName(this.getDescriptor());
    }

    public static interface IMember {
        public int getAccess();

        public IClass getDeclaringIClass();
    }

    public abstract class IInvocable
    implements IMember {
        public abstract int getAccess();

        public IClass getDeclaringIClass() {
            return IClass.this;
        }

        public abstract String getDescriptor() throws Java.CompileException;

        public abstract IClass[] getParameterTypes() throws Java.CompileException;

        public abstract IClass[] getThrownExceptions() throws Java.CompileException;

        public boolean isLessSpecificThan(IInvocable iInvocable) throws Java.CompileException {
            return iInvocable.isMoreSpecificThan(this);
        }

        public boolean isMoreSpecificThan(IInvocable iInvocable) throws Java.CompileException {
            if (!iInvocable.getDeclaringIClass().isAssignableFrom(this.getDeclaringIClass())) {
                return false;
            }
            IClass[] iClassArray = this.getParameterTypes();
            IClass[] iClassArray2 = iInvocable.getParameterTypes();
            int n = 0;
            while (n < iClassArray.length) {
                if (!iClassArray2[n].isAssignableFrom(iClassArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public abstract String toString();
    }

    public abstract class IConstructor
    extends IInvocable {
        public String getDescriptor() throws Java.CompileException {
            return new MethodDescriptor(IClass.getDescriptors(this.getParameterTypes()), "V").toString();
        }

        public abstract IClass[] getParameterTypes() throws Java.CompileException;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getDeclaringIClass().toString());
            stringBuffer.append('(');
            try {
                IClass[] iClassArray = this.getParameterTypes();
                int n = 0;
                while (n < iClassArray.length) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(iClassArray[n].toString());
                    ++n;
                }
            }
            catch (Java.CompileException compileException) {
                stringBuffer.append("<invalid type>");
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public abstract class IMethod
    extends IInvocable {
        public String getDescriptor() throws Java.CompileException {
            return new MethodDescriptor(IClass.getDescriptors(this.getParameterTypes()), this.getReturnType().getDescriptor()).toString();
        }

        public abstract String getName();

        public abstract IClass getReturnType() throws Java.CompileException;

        public abstract boolean isAbstract();

        public abstract boolean isStatic();

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.getReturnType().toString());
            }
            catch (Java.CompileException compileException) {
                stringBuffer.append("<invalid type>");
            }
            stringBuffer.append(' ');
            stringBuffer.append(this.getDeclaringIClass().toString());
            stringBuffer.append('.');
            stringBuffer.append(this.getName());
            stringBuffer.append('(');
            try {
                IClass[] iClassArray = this.getParameterTypes();
                int n = 0;
                while (n < iClassArray.length) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(iClassArray[n].toString());
                    ++n;
                }
            }
            catch (Java.CompileException compileException) {
                stringBuffer.append("<invalid type>");
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public abstract class IField
    implements IMember {
        public abstract int getAccess();

        public abstract Object getConstantValue() throws Java.CompileException;

        public IClass getDeclaringIClass() {
            return IClass.this;
        }

        public String getDescriptor() throws Java.CompileException {
            return this.getType().getDescriptor();
        }

        public abstract String getName();

        public abstract IClass getType() throws Java.CompileException;

        public abstract boolean isStatic();

        public String toString() {
            return this.getName();
        }
    }
}

