/*
 * Decompiled with CFR 0.152.
 */
package net.janino;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import net.janino.Java;
import net.janino.Mod;
import net.janino.Parser;
import net.janino.Scanner;
import net.janino.Visitor;
import net.janino.util.AutoIndentWriter;

public class UnparseVisitor
implements Visitor {
    private final AutoIndentWriter aiw;
    private final PrintWriter pw;

    public UnparseVisitor(Writer writer) {
        this.aiw = new AutoIndentWriter(writer);
        this.pw = new PrintWriter((Writer)this.aiw, true);
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        int n = 0;
        while (n < stringArray.length) {
            Java.CompilationUnit compilationUnit = new Parser(new Scanner(stringArray[n])).parseCompilationUnit();
            UnparseVisitor.unparse(compilationUnit, bufferedWriter);
            ++n;
        }
        ((Writer)bufferedWriter).flush();
    }

    public static void unparse(Java.CompilationUnit compilationUnit, Writer writer) {
        new UnparseVisitor(writer).visitCompilationUnit(compilationUnit);
    }

    private void unparseAbstractTypeDeclarationBody(Java.AbstractTypeDeclaration abstractTypeDeclaration) {
        Iterator iterator = abstractTypeDeclaration.declaredMethods.iterator();
        while (iterator.hasNext()) {
            ((Java.MethodDeclarator)iterator.next()).visit(this);
            this.pw.println();
        }
        Iterator iterator2 = abstractTypeDeclaration.declaredClassesAndInterfaces.values().iterator();
        while (iterator2.hasNext()) {
            ((Java.MemberTypeDeclaration)iterator2.next()).visit(this);
            this.pw.println();
        }
    }

    private void unparseClassDeclarationBody(Java.ClassDeclaration classDeclaration) {
        Iterator iterator = classDeclaration.constructors.iterator();
        while (iterator.hasNext()) {
            ((Java.ConstructorDeclarator)iterator.next()).visit(this);
            this.pw.println();
        }
        this.unparseAbstractTypeDeclarationBody(classDeclaration);
        Iterator iterator2 = classDeclaration.variableDeclaratorsAndInitializers.iterator();
        while (iterator2.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator2.next()).visit(this);
            this.pw.println();
        }
    }

    private void unparseFunctionDeclaratorRest(Java.FunctionDeclarator functionDeclarator) {
        this.pw.print('(');
        int n = 0;
        while (n < functionDeclarator.formalParameters.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            functionDeclarator.formalParameters[n].visit(this);
            ++n;
        }
        this.pw.print(')');
        if (functionDeclarator.thrownExceptions.length > 0) {
            this.pw.print(" throws " + Java.join(functionDeclarator.thrownExceptions, ", "));
        }
    }

    private void unparseFunctionInvocationArguments(Java.Rvalue[] rvalueArray) {
        this.pw.print('(');
        int n = 0;
        while (n < rvalueArray.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            rvalueArray[n].visit(this);
            ++n;
        }
        this.pw.print(')');
    }

    private void unparseInterfaceDeclaration(Java.InterfaceDeclaration interfaceDeclaration) {
        this.unparseModifiers(interfaceDeclaration.modifiers);
        this.pw.print("interface " + interfaceDeclaration.name);
        if (interfaceDeclaration.extendedTypes.length > 0) {
            this.pw.print(" extends " + Java.join(interfaceDeclaration.extendedTypes, ", "));
        }
        this.pw.println(" {");
        this.unparseAbstractTypeDeclarationBody(interfaceDeclaration);
        Iterator iterator = interfaceDeclaration.constantDeclarations.iterator();
        while (iterator.hasNext()) {
            ((Java.FieldDeclarator)iterator.next()).visit(this);
            this.pw.println();
        }
        this.pw.print('}');
    }

    private void unparseModifiers(short s) {
        if (s != 0) {
            this.pw.print(String.valueOf(Mod.shortToString(s)) + ' ');
        }
    }

    private void unparseNamedClassDeclaration(Java.NamedClassDeclaration namedClassDeclaration) {
        this.unparseModifiers(namedClassDeclaration.modifiers);
        this.pw.print("class " + namedClassDeclaration.name);
        if (namedClassDeclaration.optionalExtendedType != null) {
            this.pw.print(" extends ");
            namedClassDeclaration.optionalExtendedType.visit(this);
        }
        if (namedClassDeclaration.implementedTypes.length > 0) {
            this.pw.print(" implements " + Java.join(namedClassDeclaration.implementedTypes, ", "));
        }
        this.pw.println(" {");
        this.unparseClassDeclarationBody(namedClassDeclaration);
        this.pw.print('}');
    }

    public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation alternateConstructorInvocation) {
        this.pw.print("this");
        this.unparseFunctionInvocationArguments(alternateConstructorInvocation.arguments);
    }

    public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
        this.pw.print(ambiguousName.toString());
    }

    public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration anonymousClassDeclaration) {
        anonymousClassDeclaration.baseType.visit(this);
        this.pw.println(" {");
        this.unparseClassDeclarationBody(anonymousClassDeclaration);
        this.pw.print('}');
    }

    public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
        arrayAccessExpression.lhs.visit(this);
        this.pw.print('[');
        arrayAccessExpression.index.visit(this);
        this.pw.print(']');
    }

    public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
        this.pw.print("new ");
        arrayInitializer.arrayType.visit(this);
        this.pw.println(" {");
        int n = 0;
        while (n < arrayInitializer.values.length) {
            arrayInitializer.values[n].visit(this);
            this.pw.println(',');
            ++n;
        }
        this.pw.print('}');
    }

    public void visitArrayLength(Java.ArrayLength arrayLength) {
        arrayLength.lhs.visit(this);
        this.pw.print(".length");
    }

    public void visitArrayType(Java.ArrayType arrayType) {
        arrayType.componentType.visit(this);
        this.pw.print("[]");
    }

    public void visitAssignment(Java.Assignment assignment) {
        assignment.lhs.visit(this);
        this.pw.print(String.valueOf(' ') + assignment.operator + ' ');
        assignment.rhs.visit(this);
    }

    public void visitBasicType(Java.BasicType basicType) {
        this.pw.print(basicType.toString());
    }

    public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
        binaryOperation.lhs.visit(this);
        this.pw.print(String.valueOf(' ') + binaryOperation.op + ' ');
        binaryOperation.rhs.visit(this);
    }

    public void visitBlock(Java.Block block) {
        this.pw.println('{');
        Iterator iterator = block.statements.iterator();
        while (iterator.hasNext()) {
            ((Java.BlockStatement)iterator.next()).visit(this);
            this.pw.println();
        }
        this.pw.print('}');
    }

    public void visitBreakStatement(Java.BreakStatement breakStatement) {
        this.pw.print("break");
        if (breakStatement.optionalLabel != null) {
            this.pw.print(String.valueOf(' ') + breakStatement.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitCast(Java.Cast cast) {
        this.pw.print('(');
        cast.targetType.visit(this);
        this.pw.print(") ");
        cast.value.visit(this);
    }

    public void visitClassLiteral(Java.ClassLiteral classLiteral) {
        classLiteral.type.visit(this);
        this.pw.print(".class");
    }

    public void visitCompilationUnit(Java.CompilationUnit compilationUnit) {
        if (compilationUnit.optionalPackage != null) {
            this.pw.println("package " + compilationUnit.optionalPackage + ';');
        }
        Iterator iterator = compilationUnit.importedPackages.iterator();
        while (iterator.hasNext()) {
            this.pw.println("import " + Java.join((String[])iterator.next(), ".") + ".*;");
        }
        Iterator iterator2 = compilationUnit.singleTypeImports.values().iterator();
        while (iterator2.hasNext()) {
            this.pw.println("import " + Java.join((String[])iterator2.next(), ".") + ';');
        }
        Iterator iterator3 = compilationUnit.packageMemberTypeDeclarations.values().iterator();
        while (iterator3.hasNext()) {
            ((Java.PackageMemberTypeDeclaration)iterator3.next()).visit(this);
            this.pw.println();
        }
    }

    public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
        conditionalExpression.lhs.visit(this);
        this.pw.print(" ? ");
        conditionalExpression.mhs.visit(this);
        this.pw.print(" : ");
        conditionalExpression.rhs.visit(this);
    }

    public void visitConstantValue(Java.ConstantValue constantValue) {
        this.pw.print(constantValue.toString());
    }

    public void visitConstructorDeclarator(Java.ConstructorDeclarator constructorDeclarator) {
        this.unparseModifiers(constructorDeclarator.modifiers);
        this.pw.print(((Java.NamedClassDeclaration)constructorDeclarator.declaringType).name);
        this.unparseFunctionDeclaratorRest(constructorDeclarator);
        this.pw.print(' ');
        if (constructorDeclarator.optionalExplicitConstructorInvocation != null) {
            this.pw.println('{');
            constructorDeclarator.optionalExplicitConstructorInvocation.visit(this);
            this.pw.println(';');
            Iterator iterator = constructorDeclarator.optionalBody.statements.iterator();
            while (iterator.hasNext()) {
                ((Java.BlockStatement)iterator.next()).visit(this);
                this.pw.println();
            }
            this.pw.print('}');
        } else {
            constructorDeclarator.optionalBody.visit(this);
        }
    }

    public void visitContinueStatement(Java.ContinueStatement continueStatement) {
        this.pw.print("continue");
        if (continueStatement.optionalLabel != null) {
            this.pw.print(String.valueOf(' ') + continueStatement.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitCrement(Java.Crement crement) {
        this.pw.print(crement.pre ? String.valueOf(crement.operator) + crement.operand : String.valueOf(String.valueOf(crement.operand)) + crement.operator);
    }

    public void visitDoStatement(Java.DoStatement doStatement) {
        this.pw.print("do ");
        doStatement.body.visit(this);
        this.pw.print("while (");
        doStatement.condition.visit(this);
        this.pw.print(");");
    }

    public void visitEmptyStatement(Java.EmptyStatement emptyStatement) {
        this.pw.print(';');
    }

    public void visitExpressionStatement(Java.ExpressionStatement expressionStatement) {
        expressionStatement.rvalue.visit(this);
        this.pw.print(';');
    }

    public void visitFieldAccess(Java.FieldAccess fieldAccess) {
        fieldAccess.lhs.visit(this);
        this.pw.print(String.valueOf('.') + fieldAccess.field.getName());
    }

    public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
        fieldAccessExpression.lhs.visit(this);
        this.pw.print(String.valueOf('.') + fieldAccessExpression.fieldName);
    }

    public void visitFieldDeclarator(Java.FieldDeclarator fieldDeclarator) {
        this.unparseModifiers(fieldDeclarator.modifiers);
        fieldDeclarator.type.visit(this);
        this.pw.print(' ');
        int n = 0;
        while (n < fieldDeclarator.variableDeclarators.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            fieldDeclarator.variableDeclarators[n].visit(this);
            ++n;
        }
        this.pw.print(';');
    }

    public void visitForStatement(Java.ForStatement forStatement) {
        this.pw.print("for (");
        if (forStatement.optionalInit != null) {
            forStatement.optionalInit.visit(this);
        } else {
            this.pw.print(';');
        }
        if (forStatement.optionalCondition != null) {
            this.pw.print(' ');
            forStatement.optionalCondition.visit(this);
        }
        this.pw.print(';');
        if (forStatement.optionalUpdate != null) {
            this.pw.print(' ');
            int n = 0;
            while (n < forStatement.optionalUpdate.length) {
                if (n > 0) {
                    this.pw.print(", ");
                }
                forStatement.optionalUpdate[n].visit(this);
                ++n;
            }
        }
        this.pw.print(") ");
        forStatement.body.visit(this);
    }

    public void visitFormalParameter(Java.FormalParameter formalParameter) {
        if (formalParameter.finaL) {
            this.pw.print("final ");
        }
        formalParameter.type.visit(this);
        this.pw.print(String.valueOf(' ') + formalParameter.name);
    }

    public void visitIfStatement(Java.IfStatement ifStatement) {
        this.pw.print("if (");
        ifStatement.condition.visit(this);
        this.pw.print(") ");
        ifStatement.thenStatement.visit(this);
        if (ifStatement.optionalElseStatement != null) {
            this.pw.print(" else ");
            ifStatement.optionalElseStatement.visit(this);
        }
    }

    public void visitInitializer(Java.Initializer initializer) {
        if (initializer.statiC) {
            this.pw.print("static ");
        }
        initializer.block.visit(this);
    }

    public void visitInstanceof(Java.Instanceof instanceof_) {
        instanceof_.lhs.visit(this);
        this.pw.print(" instanceof ");
        instanceof_.rhs.visit(this);
    }

    public void visitLabeledStatement(Java.LabeledStatement labeledStatement) {
        this.pw.println(String.valueOf(labeledStatement.label) + ':');
        labeledStatement.body.visit(this);
    }

    public void visitLiteral(Java.Literal literal) {
        this.pw.print(literal.toString());
    }

    public void visitLocalClassDeclaration(Java.LocalClassDeclaration localClassDeclaration) {
        this.unparseNamedClassDeclaration(localClassDeclaration);
    }

    public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
        localClassDeclarationStatement.lcd.visit(this);
    }

    public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
        this.pw.print(localVariableAccess.toString());
    }

    public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
        this.unparseModifiers(localVariableDeclarationStatement.modifiers);
        localVariableDeclarationStatement.type.visit(this);
        this.pw.print(' ');
        localVariableDeclarationStatement.variableDeclarators[0].visit(this);
        int n = 1;
        while (n < localVariableDeclarationStatement.variableDeclarators.length) {
            this.pw.print(", ");
            localVariableDeclarationStatement.variableDeclarators[n].visit(this);
            ++n;
        }
        this.pw.print(';');
    }

    public void visitMemberClassDeclaration(Java.MemberClassDeclaration memberClassDeclaration) {
        this.unparseNamedClassDeclaration(memberClassDeclaration);
    }

    public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration memberInterfaceDeclaration) {
        this.unparseInterfaceDeclaration(memberInterfaceDeclaration);
    }

    public void visitMethodDeclarator(Java.MethodDeclarator methodDeclarator) {
        this.unparseModifiers(methodDeclarator.modifiers);
        methodDeclarator.type.visit(this);
        this.pw.print(String.valueOf(' ') + methodDeclarator.name);
        this.unparseFunctionDeclaratorRest(methodDeclarator);
        if (methodDeclarator.optionalBody != null) {
            this.pw.print(' ');
            methodDeclarator.optionalBody.visit(this);
        } else {
            this.pw.print(';');
        }
    }

    public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
        if (methodInvocation.optionalTarget != null) {
            methodInvocation.optionalTarget.visit(this);
            this.pw.print('.');
        }
        this.pw.print(methodInvocation.methodName);
        this.unparseFunctionInvocationArguments(methodInvocation.arguments);
    }

    public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
        if (newAnonymousClassInstance.optionalQualification != null) {
            newAnonymousClassInstance.optionalQualification.visit(this);
            this.pw.print('.');
        }
        this.pw.print("new " + newAnonymousClassInstance.anonymousClassDeclaration.baseType.toString() + '(');
        int n = 0;
        while (n < newAnonymousClassInstance.arguments.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            newAnonymousClassInstance.arguments[n].visit(this);
            ++n;
        }
        this.pw.println(") {");
        this.unparseClassDeclarationBody(newAnonymousClassInstance.anonymousClassDeclaration);
        this.pw.print('}');
    }

    public void visitNewArray(Java.NewArray newArray) {
        this.pw.print("new ");
        newArray.type.visit(this);
        int n = 0;
        while (n < newArray.dimExprs.length) {
            this.pw.print('[');
            newArray.dimExprs[n].visit(this);
            this.pw.print(']');
            ++n;
        }
        int n2 = 0;
        while (n2 < newArray.dims) {
            this.pw.print("[]");
            ++n2;
        }
    }

    public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
        if (newClassInstance.optionalQualification != null) {
            newClassInstance.optionalQualification.visit(this);
            this.pw.print('.');
        }
        this.pw.print("new " + newClassInstance.type.toString());
        this.unparseFunctionInvocationArguments(newClassInstance.arguments);
    }

    public void visitPackage(Java.Package package_) {
        this.pw.print(package_.toString());
    }

    public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration packageMemberClassDeclaration) {
        this.unparseNamedClassDeclaration(packageMemberClassDeclaration);
    }

    public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration packageMemberInterfaceDeclaration) {
        this.unparseInterfaceDeclaration(packageMemberInterfaceDeclaration);
    }

    public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
        this.pw.print(parameterAccess.toString());
    }

    public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
        this.pw.print('(');
        parenthesizedExpression.value.visit(this);
        this.pw.print(')');
    }

    public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
        qualifiedThisReference.qualification.visit(this);
        this.pw.print(".this");
    }

    public void visitReferenceType(Java.ReferenceType referenceType) {
        this.pw.print(referenceType.toString());
    }

    public void visitReturnStatement(Java.ReturnStatement returnStatement) {
        this.pw.print("return");
        if (returnStatement.optionalReturnValue != null) {
            this.pw.print(' ');
            returnStatement.optionalReturnValue.visit(this);
        }
        this.pw.print(';');
    }

    public void visitRvalueMemberType(Java.RvalueMemberType rvalueMemberType) {
        this.pw.print(rvalueMemberType.toString());
    }

    public void visitSimpleType(Java.SimpleType simpleType) {
        this.pw.print(simpleType.toString());
    }

    public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation superConstructorInvocation) {
        if (superConstructorInvocation.optionalQualification != null) {
            superConstructorInvocation.optionalQualification.visit(this);
            this.pw.print('.');
        }
        this.pw.print("super");
        this.unparseFunctionInvocationArguments(superConstructorInvocation.arguments);
    }

    public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
        this.pw.print("super." + superclassMethodInvocation.methodName);
        this.unparseFunctionInvocationArguments(superclassMethodInvocation.arguments);
    }

    public void visitSwitchStatement(Java.SwitchStatement switchStatement) {
        this.pw.println("switch (" + switchStatement.condition + ") {");
        Iterator iterator = switchStatement.sbsgs.iterator();
        while (iterator.hasNext()) {
            Object var5_6;
            Java.SwitchBlockStatementGroup switchBlockStatementGroup;
            block5: {
                switchBlockStatementGroup = (Java.SwitchBlockStatementGroup)iterator.next();
                this.aiw.unindent();
                try {
                    Iterator iterator2 = switchBlockStatementGroup.caseLabels.iterator();
                    while (iterator2.hasNext()) {
                        Java.Rvalue rvalue = (Java.Rvalue)iterator2.next();
                        this.pw.print("case ");
                        rvalue.visit(this);
                        this.pw.println(':');
                    }
                    if (!switchBlockStatementGroup.hasDefaultLabel) break block5;
                    this.pw.println("default:");
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    this.aiw.indent();
                    throw throwable;
                }
            }
            var5_6 = null;
            this.aiw.indent();
            Iterator iterator3 = switchBlockStatementGroup.blockStatements.iterator();
            while (iterator3.hasNext()) {
                ((Java.BlockStatement)iterator3.next()).visit(this);
                this.pw.println();
            }
        }
        this.pw.print('}');
    }

    public void visitSynchronizedStatement(Java.SynchronizedStatement synchronizedStatement) {
        this.pw.print("synchronized (");
        synchronizedStatement.expression.visit(this);
        this.pw.print(") ");
        synchronizedStatement.body.visit(this);
    }

    public void visitThisReference(Java.ThisReference thisReference) {
        this.pw.print("this");
    }

    public void visitThrowStatement(Java.ThrowStatement throwStatement) {
        this.pw.print("throw ");
        throwStatement.expression.visit(this);
        this.pw.print(';');
    }

    public void visitTryStatement(Java.TryStatement tryStatement) {
        this.pw.print("try ");
        tryStatement.body.visit(this);
        Iterator iterator = tryStatement.catchClauses.iterator();
        while (iterator.hasNext()) {
            Java.CatchClause catchClause = (Java.CatchClause)iterator.next();
            this.pw.print(" catch (");
            catchClause.caughtException.visit(this);
            this.pw.print(") ");
            catchClause.body.visit(this);
        }
        if (tryStatement.optionalFinally != null) {
            this.pw.print(" finally ");
            tryStatement.optionalFinally.visit(this);
        }
    }

    public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
        this.pw.print(unaryOperation.operator);
        unaryOperation.operand.visit(this);
    }

    public void visitVariableDeclarator(Java.VariableDeclarator variableDeclarator) {
        this.pw.print(variableDeclarator.name);
        int n = 0;
        while (n < variableDeclarator.brackets) {
            this.pw.print("[]");
            ++n;
        }
        if (variableDeclarator.optionalInitializer != null) {
            this.pw.print(" = ");
            variableDeclarator.optionalInitializer.visit(this);
        }
    }

    public void visitWhileStatement(Java.WhileStatement whileStatement) {
        this.pw.print("while (");
        whileStatement.condition.visit(this);
        this.pw.print(") ");
        whileStatement.body.visit(this);
    }
}

