/*
 * Decompiled with CFR 0.152.
 */
package net.janino.util;

import java.util.Stack;

public class Benchmark {
    private final Stack beginTimes = new Stack();
    private final boolean reportingEnabled;
    private final Reporter reporter;

    public Benchmark() {
        this.reportingEnabled = false;
        this.reporter = null;
    }

    public Benchmark(boolean bl) {
        this.reportingEnabled = bl;
        this.reporter = new Reporter(){

            public void report(String string) {
                System.out.println(string);
            }
        };
    }

    public Benchmark(boolean bl, Reporter reporter) {
        this.reportingEnabled = bl;
        this.reporter = reporter;
    }

    public void begin() {
        this.beginTimes.push(new Long(System.currentTimeMillis()));
    }

    public void beginReporting() {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("Beginning...");
        this.begin();
    }

    public void beginReporting(String string) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented(String.valueOf(string) + "...");
        this.begin();
    }

    public long end() {
        return System.currentTimeMillis() - (Long)this.beginTimes.pop();
    }

    public void endReporting() {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("... took " + this.end() + " ms");
    }

    public void endReporting(String string) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("... took " + this.end() + " ms: " + string);
    }

    public void report(Object object) {
        if (!this.reportingEnabled) {
            return;
        }
        if (object == null) {
            this.reportIndented("(null)");
        } else if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 0) {
                this.reportIndented("(empty array)");
            } else {
                this.reportIndented("Array:");
                this.begin();
                try {
                    int n = 0;
                    while (n < objectArray.length) {
                        this.report(objectArray[n]);
                        ++n;
                    }
                }
                finally {
                    Object var4_4 = null;
                    this.end();
                }
            }
        } else {
            this.reportIndented(object.toString());
        }
    }

    public void report(String string, Object object) {
        if (!this.reportingEnabled) {
            return;
        }
        if (object == null) {
            this.reportIndented(String.valueOf(string) + ": (null)");
        } else if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 0) {
                this.reportIndented(String.valueOf(string) + ": (zero elements)");
            } else {
                this.reportIndented(String.valueOf(string) + ":");
                this.begin();
                try {
                    int n = 0;
                    while (n < objectArray.length) {
                        this.report(objectArray[n]);
                        ++n;
                    }
                }
                finally {
                    Object var5_5 = null;
                    this.end();
                }
            }
        } else {
            this.reportIndented(String.valueOf(string) + ": " + object.toString());
        }
    }

    private void reportIndented(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.beginTimes.size();
        while (n > 0) {
            stringBuffer.append(' ');
            --n;
        }
        stringBuffer.append(string);
        this.reporter.report(stringBuffer.toString());
    }

    public static interface Reporter {
        public void report(String var1);
    }
}

