/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.jdbc.base.BaseCallEscape;
import com.microsoft.jdbc.base.BaseEscapeTranslator;
import com.microsoft.jdbc.base.BaseFunctionEscape;
import com.microsoft.jdbc.base.BaseTimestampEscape;
import com.microsoft.util.UtilDebug;

public class SQLServerEscapeTranslator
extends BaseEscapeTranslator {
    private static String footprint = "$Revision:   1.8.1.0  $";

    public int getTranslationNeeded(int n) {
        int n2;
        switch (n) {
            case 8: {
                n2 = 1;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: {
                n2 = 0;
                break;
            }
            default: {
                UtilDebug.assert((String)"Unknown escape type.", (boolean)false);
                n2 = 0;
            }
        }
        return n2;
    }

    public String translateCallEscape(BaseCallEscape baseCallEscape) {
        String string = new String("EXEC ");
        if (baseCallEscape.getEscapeType() == 7) {
            string = String.valueOf(string) + "? = ";
        }
        string = String.valueOf(string) + baseCallEscape.getProcedureName() + " " + baseCallEscape.getAllParameters();
        return string;
    }

    public String translateFunctionEscape(BaseFunctionEscape baseFunctionEscape) {
        String string = null;
        switch (baseFunctionEscape.getFunctionType()) {
            case 72: {
                string = new String("{fn CONVERT(");
                string = String.valueOf(string) + baseFunctionEscape.getParameter(1) + ", SQL_";
                String string2 = baseFunctionEscape.getParameter(2).toString();
                if (string2.regionMatches(true, 0, "TIME", 0, 4) || string2.regionMatches(true, 0, "DATE", 0, 4) || string2.regionMatches(true, 0, "TIMESTAMP", 0, 9)) {
                    string = String.valueOf(string) + "TYPE_";
                }
                string = String.valueOf(string) + string2 + ")}";
                break;
            }
        }
        return string;
    }

    public String translateTimestampEscape(BaseTimestampEscape baseTimestampEscape) {
        String string = null;
        switch (baseTimestampEscape.getEscapeType()) {
            case 1: 
            case 3: {
                String string2 = baseTimestampEscape.getSecondsFraction();
                if (string2 == null || string2.length() <= 3) break;
                string = new String();
                string = baseTimestampEscape.getEscapeType() == 3 ? String.valueOf(string) + "{ts '" + baseTimestampEscape.getYear() + "-" + baseTimestampEscape.getMonth() + "-" + baseTimestampEscape.getDay() + " " : String.valueOf(string) + "{t '";
                string = String.valueOf(string) + baseTimestampEscape.getHour() + ":" + baseTimestampEscape.getMinutes() + ":" + baseTimestampEscape.getSeconds() + "." + string2.substring(0, 3) + "'}";
                this.warnings.add(11010);
                break;
            }
        }
        return string;
    }
}

