/*
 * Decompiled with CFR 0.152.
 */
package org.openabacus.jfreechart;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaObjectAccess;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openabacus.jfreechart.JAChartPanel;

public class JAXYLineChart
extends JAChartPanel
implements MetaObjectAccess {
    private JFreeChart chart;
    private XYSeries dataset;
    private XYDataset xyDataset = null;
    private String seriesLabel = null;
    private XYPlot plot = null;
    private Font plotFont = new Font("SansSerif", 0, 12);
    private String defaultTitle = null;
    private String xAxisTitle = "X-Axis Title";
    private String yAxisTitle = "Y-Axis Title";
    public static int VERTICAL = 0;
    public static int HORIZONTAL = 1;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;

    public JAXYLineChart() {
        this.dataset = new XYSeries("Default label");
        this.setDefaultdata();
        this.xyDataset = new XYSeriesCollection(this.dataset);
        this.defaultTitle = new String("No Title");
        this.chart = this.createChart();
        this.setChart(this.chart);
    }

    public void setMetaObject(MetaObject metaObject) {
        this.iDesignMode = metaObject.iMode;
        this.mtObject = metaObject;
        this.setDefaultdata();
    }

    public void refresh(XYSeries newDataSet) {
        this.dataset = newDataSet;
        this.chart.clearSubtitles();
        this.chart = this.createChart();
        this.setChart(this.chart);
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public String getTitle() {
        return this.defaultTitle;
    }

    public void set3DChart(boolean bFlag) {
        this.b3DChart = bFlag;
        this.chart = this.createChart();
        this.setChart(this.chart);
    }

    public boolean get3DChart(boolean bFlag) {
        return this.b3DChart;
    }

    public void setFont(Font chartFont) {
        this.plotFont = chartFont;
    }

    public Font getFont() {
        return this.plotFont;
    }

    public void refresh(XYDataset newDataSet) {
        this.xyDataset = newDataSet;
        this.chart.clearSubtitles();
        this.chart = this.createChart();
        this.setChart(this.chart);
    }

    public void setXYSeries(String sLabel) {
        this.seriesLabel = sLabel;
        this.dataset = new XYSeries(sLabel);
    }

    public String getXYSeries() {
        return this.seriesLabel;
    }

    public void setOrientation(int iOrientation) {
        this.orientation = iOrientation == VERTICAL ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
        this.createChart();
        this.setChart(this.chart);
    }

    public int getOrientation() {
        int iOrientation = 0;
        iOrientation = this.orientation == PlotOrientation.VERTICAL ? VERTICAL : HORIZONTAL;
        return iOrientation;
    }

    public String getyAxisTitle() {
        return this.yAxisTitle;
    }

    public void setyAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
        this.chart = this.createChart();
        this.setChart(this.chart);
    }

    public String getxAxisTitle() {
        return this.xAxisTitle;
    }

    public void setxAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
        this.chart = this.createChart();
        this.setChart(this.chart);
    }

    private void setDefaultdata() {
        if (this.dataset != null && this.iDesignMode == 1) {
            this.dataset.add(20.0, 10.0);
            this.dataset.add(40.0, 20.0);
            this.dataset.add(70.0, 50.0);
        }
    }

    public JFreeChart createChart() {
        JFreeChart localChart = ChartFactory.createXYLineChart((String)this.defaultTitle, (String)this.xAxisTitle, (String)this.yAxisTitle, (XYDataset)this.xyDataset, (PlotOrientation)this.orientation, (boolean)true, (boolean)false, (boolean)false);
        this.plot = (XYPlot)localChart.getPlot();
        this.plot.setNoDataMessage("No data available");
        return localChart;
    }
}

