/*
 * Decompiled with CFR 0.152.
 */
package com.nqadmin.swingSet;

import com.nqadmin.swingSet.SSTextDocument;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Stack;
import java.util.Vector;
import javax.sql.RowSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SSDBComboBox
extends JComponent {
    private JTextField textField = null;
    private JComboBox cmbDisplayed = new JComboBox();
    private Connection conn = null;
    private String query = null;
    private String columnName = null;
    private String displayColumnName = null;
    private String secondDisplayColumnName = null;
    private Vector columnVector = new Vector();
    private int numberOfItems = 0;
    private RowSet rowset = null;
    final MyComboListener cmbListener = new MyComboListener();
    final MyTextFieldDocumentListener textFieldDocumentListener = new MyTextFieldDocumentListener();
    final MyKeyListener myKeyListener = new MyKeyListener();
    String seperator = " - ";
    String datePattern = "MM/dd/yyyy";

    public SSDBComboBox() {
    }

    public SSDBComboBox(Connection connection, String string, String string2, String string3, JTextField jTextField) {
        this.conn = connection;
        this.query = string;
        this.columnName = string2;
        this.displayColumnName = string3;
        this.textField = jTextField;
        this.textField.setPreferredSize(new Dimension(200, 20));
        this.cmbDisplayed.setPreferredSize(new Dimension(200, 20));
        this.textField.setMaximumSize(new Dimension(200, 20));
        this.cmbDisplayed.setMaximumSize(new Dimension(200, 20));
    }

    public SSDBComboBox(Connection connection, String string, String string2, String string3) {
        this.conn = connection;
        this.query = string;
        this.columnName = string2;
        this.displayColumnName = string3;
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(200, 20));
        this.cmbDisplayed.setPreferredSize(new Dimension(200, 20));
        this.textField.setMaximumSize(new Dimension(200, 20));
        this.cmbDisplayed.setMaximumSize(new Dimension(200, 20));
    }

    public void setRowSet(RowSet rowSet) {
        this.rowset = rowSet;
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public void setDisplayColumnName(String string) {
        this.displayColumnName = string;
    }

    public void setDateFormat(String string) {
        this.datePattern = string;
    }

    public void setSecondDisplayColumnName(String string) {
        this.secondDisplayColumnName = string;
    }

    public void setTextField(JTextField jTextField) {
        this.textField = jTextField;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }

    public String getQuery() {
        return this.query;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDisplayColumnName() {
        return this.displayColumnName;
    }

    public String getSecondDisplayColumnName() {
        return this.secondDisplayColumnName;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setSeperator(String string) {
        this.seperator = string;
    }

    public String getSeperator() {
        return this.seperator;
    }

    public long getSelectedValue() {
        int n = this.cmbDisplayed.getSelectedIndex();
        if (n == -1) {
            return -1L;
        }
        return (Long)this.columnVector.get(n);
    }

    public void execute() throws SQLException, Exception {
        this.removeListeners();
        Statement statement = this.conn.createStatement();
        if (this.query.equals("")) {
            throw new Exception("Query is empty");
        }
        ResultSet resultSet = statement.executeQuery(this.query);
        this.cmbDisplayed.removeAllItems();
        this.columnVector.clear();
        int n = 0;
        if (this.rowset == null) {
            while (resultSet.next()) {
                if (this.secondDisplayColumnName != null) {
                    this.cmbDisplayed.addItem(this.getStringValue(resultSet, this.displayColumnName) + this.seperator + resultSet.getString(this.secondDisplayColumnName));
                } else {
                    this.cmbDisplayed.addItem(this.getStringValue(resultSet, this.displayColumnName));
                }
                this.columnVector.add(n, new Long(resultSet.getLong(this.columnName)));
                ++n;
            }
        } else {
            int n2 = this.rowset.getRow();
            this.rowset.beforeFirst();
            while (this.rowset.next()) {
                if (n == 0) {
                    this.rowset.first();
                }
                if (this.secondDisplayColumnName != null) {
                    this.cmbDisplayed.addItem(this.rowset.getString(this.displayColumnName) + " : " + this.rowset.getString(this.secondDisplayColumnName));
                } else {
                    this.cmbDisplayed.addItem(this.rowset.getString(this.displayColumnName));
                }
                this.columnVector.add(n, new Long(this.rowset.getLong(this.columnName)));
                ++n;
            }
            if (n2 == 0) {
                this.rowset.beforeFirst();
            } else {
                this.rowset.absolute(n2);
            }
        }
        this.numberOfItems = n;
        this.setCmbDisplay();
        this.addListeners();
    }

    private void setCmbDisplay() {
        Document document = this.textField.getDocument();
        try {
            long l;
            int n;
            String string = document.getText(0, document.getLength());
            if (string != null && (n = this.columnVector.indexOf(new Long(l = Long.parseLong(string)))) != this.cmbDisplayed.getSelectedIndex()) {
                this.cmbDisplayed.setSelectedIndex(n);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void bind(RowSet rowSet, String string) {
        this.textField.setDocument(new SSTextDocument(rowSet, string));
    }

    private void addListeners() {
        this.cmbDisplayed.addActionListener(this.cmbListener);
        this.cmbDisplayed.addKeyListener(this.myKeyListener);
        this.cmbDisplayed.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SSDBComboBox.this.myKeyListener.resetSearchString();
            }
        });
        this.textField.getDocument().addDocumentListener(this.textFieldDocumentListener);
    }

    private void removeListeners() {
        this.cmbDisplayed.removeActionListener(this.cmbListener);
        this.cmbDisplayed.removeKeyListener(this.myKeyListener);
        this.textField.getDocument().removeDocumentListener(this.textFieldDocumentListener);
    }

    public JComboBox getComboBox() {
        return this.cmbDisplayed;
    }

    public void addItem(String string, long l) {
        this.columnVector.add(new Long(l));
        this.cmbDisplayed.addItem(string);
    }

    public boolean deleteItem(String string) {
        for (int i = 0; i < this.cmbDisplayed.getItemCount(); ++i) {
            if (!((String)this.cmbDisplayed.getItemAt(i)).equals(string)) continue;
            this.cmbDisplayed.removeItemAt(i);
            this.columnVector.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean deleteItem(long l) {
        int n = this.columnVector.indexOf(new Long(l));
        if (n == -1) {
            return false;
        }
        this.columnVector.removeElementAt(n);
        this.cmbDisplayed.removeItemAt(n);
        return true;
    }

    public boolean deleteItem(String string, long l) {
        for (int i = 0; i < this.cmbDisplayed.getItemCount(); ++i) {
            if (!((String)this.cmbDisplayed.getItemAt(i)).equals(string) || (Long)this.columnVector.elementAt(i) != l) continue;
            this.cmbDisplayed.removeItemAt(i);
            this.columnVector.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean updateItem(long l, String string) {
        int n = this.columnVector.indexOf(new Long(l));
        System.out.println(n);
        if (n == -1) {
            return false;
        }
        this.cmbDisplayed.removeActionListener(this.cmbListener);
        this.cmbDisplayed.insertItemAt(string, n + 1);
        this.cmbDisplayed.removeItemAt(n);
        this.cmbDisplayed.setSelectedIndex(n);
        this.cmbDisplayed.addActionListener(this.cmbListener);
        return true;
    }

    private String getStringValue(ResultSet resultSet, String string) {
        String string2 = "";
        try {
            int n = resultSet.getMetaData().getColumnType(resultSet.findColumn(string));
            switch (n) {
                case 91: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                    string2 = simpleDateFormat.format(resultSet.getDate(string));
                    break;
                }
                default: {
                    string2 = resultSet.getString(string);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return string2;
    }

    private class MyComboListener
    implements ActionListener {
        private MyComboListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SSDBComboBox.this.textField.getDocument().removeDocumentListener(SSDBComboBox.this.textFieldDocumentListener);
            int n = SSDBComboBox.this.cmbDisplayed.getSelectedIndex();
            if (n != -1) {
                try {
                    long l = (Long)SSDBComboBox.this.columnVector.get(n);
                    String string = SSDBComboBox.this.textField.getText();
                    long l2 = -1L;
                    if (!string.equals("")) {
                        l2 = Long.parseLong(string);
                    }
                    if (l2 != l) {
                        SSDBComboBox.this.textField.setText(String.valueOf(l));
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            SSDBComboBox.this.textField.getDocument().addDocumentListener(SSDBComboBox.this.textFieldDocumentListener);
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        String searchString = null;
        Stack searchStack = new Stack();
        int previousIndex = 0;

        private MyKeyListener() {
        }

        public void resetSearchString() {
            this.searchString = null;
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n;
            if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 10) {
                this.searchString = null;
                this.searchStack.removeAllElements();
                return;
            }
            if (keyEvent.getKeyCode() == 8) {
                if (this.searchString == null) {
                    SSDBComboBox.this.cmbDisplayed.setSelectedIndex(0);
                    this.searchStack.removeAllElements();
                    this.previousIndex = 0;
                    return;
                }
                if (this.searchString.length() > 0) {
                    this.searchString = this.searchString.substring(0, this.searchString.length() - 1);
                    if (this.searchString.length() == 0) {
                        this.searchString = null;
                        this.searchStack.removeAllElements();
                        this.previousIndex = 0;
                    }
                }
            } else {
                this.searchString = this.searchString == null ? new String(new char[]{keyEvent.getKeyChar()}) : this.searchString + new String(new char[]{keyEvent.getKeyChar()});
            }
            if (this.searchString == null) {
                SSDBComboBox.this.cmbDisplayed.setSelectedIndex(0);
                return;
            }
            if (keyEvent.getKeyCode() == 8) {
                if (this.searchStack.empty()) {
                    SSDBComboBox.this.cmbDisplayed.setSelectedIndex(0);
                    return;
                }
                this.searchStack.pop();
                if (!this.searchStack.empty()) {
                    this.previousIndex = (Integer)this.searchStack.peek();
                    SSDBComboBox.this.cmbDisplayed.setSelectedIndex(this.previousIndex);
                    return;
                }
                this.previousIndex = 0;
                SSDBComboBox.this.cmbDisplayed.setSelectedIndex(0);
                return;
            }
            for (n = this.previousIndex; n < SSDBComboBox.this.cmbDisplayed.getItemCount(); ++n) {
                if (this.searchString.length() == 0) {
                    SSDBComboBox.this.cmbDisplayed.setSelectedIndex(0);
                    continue;
                }
                if (((String)SSDBComboBox.this.cmbDisplayed.getItemAt(n)).length() < this.searchString.length() || !this.searchString.equalsIgnoreCase(((String)SSDBComboBox.this.cmbDisplayed.getItemAt(n)).substring(0, this.searchString.length()))) continue;
                SSDBComboBox.this.cmbDisplayed.setSelectedIndex(n);
                this.searchStack.push(new Integer(n));
                return;
            }
            if (n == SSDBComboBox.this.cmbDisplayed.getItemCount()) {
                for (n = 0; n < this.previousIndex; ++n) {
                    if (this.searchString.length() == 0) {
                        SSDBComboBox.this.cmbDisplayed.setSelectedIndex(0);
                        continue;
                    }
                    if (((String)SSDBComboBox.this.cmbDisplayed.getItemAt(n)).length() < this.searchString.length() || !this.searchString.equalsIgnoreCase(((String)SSDBComboBox.this.cmbDisplayed.getItemAt(n)).substring(0, this.searchString.length()))) continue;
                    SSDBComboBox.this.cmbDisplayed.setSelectedIndex(n);
                    this.searchStack.push(new Integer(n));
                    return;
                }
            }
            if (this.searchStack.empty()) {
                SSDBComboBox.this.cmbDisplayed.setSelectedIndex(0);
            } else {
                SSDBComboBox.this.cmbDisplayed.setSelectedIndex((Integer)this.searchStack.peek());
            }
        }
    }

    private class MyTextFieldDocumentListener
    implements DocumentListener {
        private MyTextFieldDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            SSDBComboBox.this.cmbDisplayed.removeActionListener(SSDBComboBox.this.cmbListener);
            Document document = SSDBComboBox.this.textField.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                if (string != null) {
                    long l = Long.parseLong(string);
                    int n = SSDBComboBox.this.columnVector.indexOf(new Long(l));
                    if (n != SSDBComboBox.this.cmbDisplayed.getSelectedIndex()) {
                        SSDBComboBox.this.cmbDisplayed.setSelectedIndex(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SSDBComboBox.this.cmbDisplayed.addActionListener(SSDBComboBox.this.cmbListener);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SSDBComboBox.this.cmbDisplayed.removeActionListener(SSDBComboBox.this.cmbListener);
            Document document = SSDBComboBox.this.textField.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                if (string != null) {
                    long l = Long.parseLong(string);
                    int n = SSDBComboBox.this.columnVector.indexOf(new Long(l));
                    if (n != SSDBComboBox.this.cmbDisplayed.getSelectedIndex()) {
                        SSDBComboBox.this.cmbDisplayed.setSelectedIndex(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SSDBComboBox.this.cmbDisplayed.addActionListener(SSDBComboBox.this.cmbListener);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            SSDBComboBox.this.cmbDisplayed.removeActionListener(SSDBComboBox.this.cmbListener);
            Document document = SSDBComboBox.this.textField.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                if (string != null) {
                    long l = Long.parseLong(string);
                    int n = SSDBComboBox.this.columnVector.indexOf(new Long(l));
                    if (n != SSDBComboBox.this.cmbDisplayed.getSelectedIndex()) {
                        SSDBComboBox.this.cmbDisplayed.setSelectedIndex(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SSDBComboBox.this.cmbDisplayed.addActionListener(SSDBComboBox.this.cmbListener);
        }
    }
}

