/*
 * Decompiled with CFR 0.152.
 */
package com.nqadmin.swingSet;

import com.nqadmin.swingSet.SSDBNav;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URLClassLoader;
import java.sql.SQLException;
import javax.sql.RowSet;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SSDataNavigator
extends JPanel {
    JButton button1 = new JButton();
    JButton button2 = new JButton();
    JButton button3 = new JButton();
    JButton button4 = new JButton();
    JButton button5 = new JButton();
    JButton button6 = new JButton();
    JButton button7 = new JButton();
    JButton button8 = new JButton();
    JButton button9 = new JButton();
    boolean modification = true;
    boolean allowDeletions = true;
    boolean allowInsertions = true;
    boolean confirmDeletes = true;
    boolean callExecute = true;
    RowSet rowset = null;
    SSDBNav dbNav = null;
    int numRows = -1;
    boolean onInsertRow = false;
    Dimension buttonSize = new Dimension(50, 20);

    public SSDataNavigator() {
        this.addToolTips();
        this.createPanel();
        this.addListeners();
    }

    public boolean containsRows() {
        return this.numRows != 0;
    }

    private void addToolTips() {
        this.button1.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/first.gif")));
        this.button2.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/prev.gif")));
        this.button3.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/next.gif")));
        this.button4.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/last.gif")));
        this.button5.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/commit.gif")));
        this.button6.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/undo.gif")));
        this.button7.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/refresh.gif")));
        this.button8.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/add.gif")));
        this.button9.setIcon(new ImageIcon(URLClassLoader.getSystemResource("images/delete.gif")));
        this.button1.setToolTipText("First");
        this.button2.setToolTipText("Previous");
        this.button3.setToolTipText("Next");
        this.button4.setToolTipText("Last");
        this.button5.setToolTipText("Commit");
        this.button6.setToolTipText("Undo");
        this.button7.setToolTipText("Refresh");
        this.button8.setToolTipText("Add Record");
        this.button9.setToolTipText("Delete Record");
    }

    public SSDataNavigator(RowSet rowSet) {
        this.setRowSet(rowSet);
        this.addToolTips();
        this.createPanel();
        this.addListeners();
    }

    public SSDataNavigator(RowSet rowSet, Dimension dimension) {
        this.buttonSize = dimension;
        this.setRowSet(rowSet);
        this.addToolTips();
        this.createPanel();
        this.addListeners();
    }

    public void setCallExecute(boolean bl) {
        this.callExecute = bl;
    }

    public void setButtonSize(Dimension dimension) {
        this.buttonSize = dimension;
        this.setButtonSizes();
    }

    public void setDBNav(SSDBNav sSDBNav) {
        this.dbNav = sSDBNav;
    }

    public void setModification(boolean bl) {
        this.modification = bl;
        if (!this.modification) {
            this.button5.setEnabled(false);
            this.button6.setEnabled(false);
            this.button8.setEnabled(false);
            this.button9.setEnabled(false);
        } else {
            this.button5.setEnabled(true);
            this.button6.setEnabled(true);
            this.button8.setEnabled(true);
            this.button9.setEnabled(true);
        }
    }

    public void setDeletion(boolean bl) {
        this.allowDeletions = bl;
        if (!bl) {
            this.button9.setEnabled(false);
        } else {
            this.button9.setEnabled(true);
        }
    }

    public void setInsertion(boolean bl) {
        this.allowInsertions = bl;
        if (!bl) {
            this.button8.setEnabled(false);
        } else {
            this.button8.setEnabled(true);
        }
    }

    public void setConfirmDeletes(boolean bl) {
        this.confirmDeletes = bl;
    }

    public boolean updatePresentRow() {
        try {
            if (!this.onInsertRow) {
                this.rowset.updateRow();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setRowSet(RowSet rowSet) {
        this.rowset = rowSet;
        try {
            if (this.callExecute) {
                this.rowset.execute();
            }
            this.numRows = !this.rowset.next() ? 0 : -1;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (this.numRows == 0) {
            this.button1.setEnabled(false);
            this.button2.setEnabled(false);
            this.button3.setEnabled(false);
            this.button4.setEnabled(false);
        } else {
            this.button1.setEnabled(true);
            this.button2.setEnabled(true);
            this.button3.setEnabled(true);
            this.button4.setEnabled(true);
        }
        try {
            if (this.rowset.isLast()) {
                this.button3.setEnabled(false);
                this.button4.setEnabled(false);
            }
            if (this.rowset.isFirst()) {
                this.button1.setEnabled(false);
                this.button2.setEnabled(false);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void setButtonSizes() {
        this.button1.setPreferredSize(this.buttonSize);
        this.button2.setPreferredSize(this.buttonSize);
        this.button3.setPreferredSize(this.buttonSize);
        this.button4.setPreferredSize(this.buttonSize);
        this.button5.setPreferredSize(this.buttonSize);
        this.button6.setPreferredSize(this.buttonSize);
        this.button7.setPreferredSize(this.buttonSize);
        this.button8.setPreferredSize(this.buttonSize);
        this.button9.setPreferredSize(this.buttonSize);
        this.button1.setMinimumSize(this.buttonSize);
        this.button2.setMinimumSize(this.buttonSize);
        this.button3.setMinimumSize(this.buttonSize);
        this.button4.setMinimumSize(this.buttonSize);
        this.button5.setMinimumSize(this.buttonSize);
        this.button6.setMinimumSize(this.buttonSize);
        this.button7.setMinimumSize(this.buttonSize);
        this.button8.setMinimumSize(this.buttonSize);
        this.button9.setMinimumSize(this.buttonSize);
    }

    private void createPanel() {
        this.setButtonSizes();
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.button1);
        this.add(this.button2);
        this.add(this.button3);
        this.add(this.button4);
        this.add(this.button5);
        this.add(this.button6);
        this.add(this.button7);
        this.add(this.button8);
        this.add(this.button9);
    }

    private void addListeners() {
        this.button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SSDataNavigator.this.modification) {
                        SSDataNavigator.this.rowset.updateRow();
                    }
                    SSDataNavigator.this.rowset.first();
                    SSDataNavigator.this.button1.setEnabled(false);
                    SSDataNavigator.this.button2.setEnabled(false);
                    if (!SSDataNavigator.this.rowset.isLast()) {
                        SSDataNavigator.this.button3.setEnabled(true);
                        SSDataNavigator.this.button4.setEnabled(true);
                    } else {
                        SSDataNavigator.this.button3.setEnabled(false);
                        SSDataNavigator.this.button4.setEnabled(false);
                    }
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performNavigationOps(3);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
        this.button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SSDataNavigator.this.modification) {
                        SSDataNavigator.this.rowset.updateRow();
                    }
                    if (SSDataNavigator.this.rowset.getRow() != 0 && !SSDataNavigator.this.rowset.previous()) {
                        SSDataNavigator.this.rowset.first();
                    }
                    if (SSDataNavigator.this.rowset.isFirst() || SSDataNavigator.this.rowset.getRow() == 0) {
                        SSDataNavigator.this.button1.setEnabled(false);
                        SSDataNavigator.this.button2.setEnabled(false);
                    }
                    if (!SSDataNavigator.this.rowset.isLast()) {
                        SSDataNavigator.this.button3.setEnabled(true);
                        SSDataNavigator.this.button4.setEnabled(true);
                    }
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performNavigationOps(2);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
        this.button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SSDataNavigator.this.modification) {
                        SSDataNavigator.this.rowset.updateRow();
                    }
                    if (!SSDataNavigator.this.rowset.next()) {
                        SSDataNavigator.this.button3.setEnabled(false);
                        SSDataNavigator.this.button4.setEnabled(false);
                        SSDataNavigator.this.rowset.last();
                    }
                    if (SSDataNavigator.this.rowset.isLast()) {
                        SSDataNavigator.this.button3.setEnabled(false);
                        SSDataNavigator.this.button4.setEnabled(false);
                    }
                    if (!SSDataNavigator.this.rowset.isFirst()) {
                        SSDataNavigator.this.button2.setEnabled(true);
                        SSDataNavigator.this.button1.setEnabled(true);
                    }
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performNavigationOps(1);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
        this.button4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SSDataNavigator.this.modification) {
                        SSDataNavigator.this.rowset.updateRow();
                    }
                    SSDataNavigator.this.rowset.last();
                    SSDataNavigator.this.button3.setEnabled(false);
                    SSDataNavigator.this.button4.setEnabled(false);
                    if (!SSDataNavigator.this.rowset.isFirst()) {
                        SSDataNavigator.this.button1.setEnabled(true);
                        SSDataNavigator.this.button2.setEnabled(true);
                    } else {
                        SSDataNavigator.this.button1.setEnabled(false);
                        SSDataNavigator.this.button2.setEnabled(false);
                    }
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performNavigationOps(4);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
        this.button5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SSDataNavigator.this.onInsertRow) {
                        SSDataNavigator.this.rowset.insertRow();
                        if (SSDataNavigator.this.dbNav != null) {
                            SSDataNavigator.this.dbNav.performPostInsertOps();
                        }
                        SSDataNavigator.this.rowset.moveToCurrentRow();
                    } else {
                        SSDataNavigator.this.rowset.updateRow();
                    }
                    SSDataNavigator.this.onInsertRow = false;
                    if (!SSDataNavigator.this.rowset.isFirst()) {
                        SSDataNavigator.this.button1.setEnabled(true);
                        SSDataNavigator.this.button2.setEnabled(true);
                    }
                    if (!SSDataNavigator.this.rowset.isLast()) {
                        SSDataNavigator.this.button3.setEnabled(true);
                        SSDataNavigator.this.button4.setEnabled(true);
                    }
                    SSDataNavigator.this.button7.setEnabled(true);
                    if (SSDataNavigator.this.allowInsertions) {
                        SSDataNavigator.this.button8.setEnabled(true);
                    }
                    if (SSDataNavigator.this.allowDeletions) {
                        SSDataNavigator.this.button9.setEnabled(true);
                    }
                }
                catch (SQLException sQLException) {
                    JOptionPane.showMessageDialog(SSDataNavigator.this, "Exception occured while inserting row.\n" + sQLException.getMessage());
                    sQLException.printStackTrace();
                }
            }
        });
        this.button6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SSDataNavigator.this.rowset.cancelRowUpdates();
                    SSDataNavigator.this.onInsertRow = false;
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performCancelOps();
                    }
                    SSDataNavigator.this.button1.setEnabled(true);
                    SSDataNavigator.this.button2.setEnabled(true);
                    SSDataNavigator.this.button3.setEnabled(true);
                    SSDataNavigator.this.button4.setEnabled(true);
                    SSDataNavigator.this.button7.setEnabled(true);
                    if (SSDataNavigator.this.allowInsertions) {
                        SSDataNavigator.this.button8.setEnabled(true);
                    }
                    if (SSDataNavigator.this.allowDeletions) {
                        SSDataNavigator.this.button9.setEnabled(true);
                    }
                }
                catch (SQLException sQLException) {
                    JOptionPane.showMessageDialog(SSDataNavigator.this, "Exception occured while undoing changes.\n" + sQLException.getMessage());
                    sQLException.printStackTrace();
                }
            }
        });
        this.button7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SSDataNavigator.this.rowset.execute();
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performRefreshOps();
                    }
                    if (SSDataNavigator.this.rowset.next()) {
                        SSDataNavigator.this.button1.setEnabled(true);
                        SSDataNavigator.this.button2.setEnabled(false);
                        SSDataNavigator.this.button3.setEnabled(true);
                        SSDataNavigator.this.button4.setEnabled(true);
                    } else {
                        SSDataNavigator.this.button1.setEnabled(false);
                        SSDataNavigator.this.button2.setEnabled(false);
                        SSDataNavigator.this.button3.setEnabled(false);
                        SSDataNavigator.this.button4.setEnabled(false);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
        this.button8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SSDataNavigator.this.rowset.moveToInsertRow();
                    SSDataNavigator.this.onInsertRow = true;
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performPreInsertOps();
                    }
                    SSDataNavigator.this.button1.setEnabled(false);
                    SSDataNavigator.this.button2.setEnabled(false);
                    SSDataNavigator.this.button3.setEnabled(false);
                    SSDataNavigator.this.button4.setEnabled(false);
                    SSDataNavigator.this.button5.setEnabled(true);
                    SSDataNavigator.this.button6.setEnabled(true);
                    SSDataNavigator.this.button7.setEnabled(false);
                    SSDataNavigator.this.button8.setEnabled(false);
                    SSDataNavigator.this.button9.setEnabled(false);
                }
                catch (SQLException sQLException) {
                    JOptionPane.showMessageDialog(SSDataNavigator.this, "Exception occured while moving to insert row.\n" + sQLException.getMessage());
                    sQLException.printStackTrace();
                }
            }
        });
        this.button9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = JOptionPane.showConfirmDialog(SSDataNavigator.this, "Are you sure you want to delete this record?", "Delete Present Record", 0);
                    if (n != 0) {
                        return;
                    }
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performPreDeletionOps();
                    }
                    SSDataNavigator.this.rowset.deleteRow();
                    if (SSDataNavigator.this.dbNav != null) {
                        SSDataNavigator.this.dbNav.performPostDeletionOps();
                    }
                    if (!SSDataNavigator.this.rowset.next()) {
                        SSDataNavigator.this.rowset.last();
                    }
                }
                catch (SQLException sQLException) {
                    JOptionPane.showMessageDialog(SSDataNavigator.this, "Exception occured while deleting row.\n" + sQLException.getMessage());
                    sQLException.printStackTrace();
                }
            }
        });
    }
}

