/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbcx;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import net.sourceforge.jtds.jdbc.DefaultProperties;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.util.Logger;

public class JtdsDataSource
implements DataSource,
Referenceable,
Serializable {
    protected String serverName;
    protected String serverType;
    protected String portNumber;
    protected String databaseName;
    protected String tdsVersion;
    protected String charset;
    protected String language;
    protected String domain;
    protected String instance;
    protected String lastUpdateCount;
    protected String sendStringParametersAsUnicode;
    protected String namedPipe;
    protected String macAddress;
    protected String prepareSql;
    protected String packetSize;
    protected String user;
    protected String password;
    protected String loginTimeout;
    protected String lobBuffer;
    protected String appName;
    protected String progName;
    protected String description;
    static /* synthetic */ Class class$net$sourceforge$jtds$jdbcx$JtdsObjectFactory;

    public JtdsDataSource() {
        Properties props = new Properties();
        props.setProperty(Messages.get("prop.servertype"), String.valueOf(1));
        props = DefaultProperties.addDefaultProperties(props);
        this.serverName = props.getProperty(Messages.get("prop.servername"));
        this.serverType = props.getProperty(Messages.get("prop.servertype"));
        this.portNumber = props.getProperty(Messages.get("prop.portnumber"));
        this.databaseName = props.getProperty(Messages.get("prop.databasename"));
        this.tdsVersion = props.getProperty(Messages.get("prop.tds"));
        this.charset = props.getProperty(Messages.get("prop.charset"));
        this.language = props.getProperty(Messages.get("prop.language"));
        this.domain = props.getProperty(Messages.get("prop.domain"));
        this.instance = props.getProperty(Messages.get("prop.instance"));
        this.lastUpdateCount = props.getProperty(Messages.get("prop.lastupdatecount"));
        this.sendStringParametersAsUnicode = props.getProperty(Messages.get("prop.useunicode"));
        this.namedPipe = props.getProperty(Messages.get("prop.namedpipe"));
        this.macAddress = props.getProperty(Messages.get("prop.macaddress"));
        this.prepareSql = props.getProperty(Messages.get("prop.preparesql"));
        this.packetSize = props.getProperty(Messages.get("prop.packetsize"));
        this.user = props.getProperty(Messages.get("prop.user"));
        this.password = props.getProperty(Messages.get("prop.password"));
        this.loginTimeout = props.getProperty(Messages.get("prop.logintimeout"));
        this.lobBuffer = props.getProperty(Messages.get("prop.lobbuffer"));
        this.appName = props.getProperty(Messages.get("prop.appname"));
        this.progName = props.getProperty(Messages.get("prop.progname"));
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        if (this.serverName == null) {
            throw new SQLException(Messages.get("error.connection.nohost"), "08001");
        }
        props.setProperty(Messages.get("prop.servername"), this.serverName);
        props.setProperty(Messages.get("prop.portnumber"), this.portNumber);
        props.setProperty(Messages.get("prop.databasename"), this.databaseName);
        props.setProperty(Messages.get("prop.tds"), this.tdsVersion);
        if (this.charset != null) {
            props.setProperty(Messages.get("prop.charset"), this.charset);
        }
        if (this.language != null) {
            props.setProperty(Messages.get("prop.language"), this.language);
        }
        if (this.domain != null) {
            props.setProperty(Messages.get("prop.domain"), this.domain);
        }
        if (this.instance != null) {
            props.setProperty(Messages.get("prop.instance"), this.instance);
        }
        props.setProperty(Messages.get("prop.lastupdatecount"), this.lastUpdateCount);
        props.setProperty(Messages.get("prop.useunicode"), this.sendStringParametersAsUnicode);
        props.setProperty(Messages.get("prop.namedpipe"), this.namedPipe);
        props.setProperty(Messages.get("prop.macaddress"), this.macAddress);
        props.setProperty(Messages.get("prop.preparesql"), this.prepareSql);
        props.setProperty(Messages.get("prop.packetsize"), this.packetSize);
        props.setProperty(Messages.get("prop.user"), user);
        props.setProperty(Messages.get("prop.password"), password);
        props.setProperty(Messages.get("prop.logintimeout"), this.loginTimeout);
        props.setProperty(Messages.get("prop.lobbuffer"), this.lobBuffer);
        props.setProperty(Messages.get("prop.appname"), this.appName);
        props.setProperty(Messages.get("prop.progname"), this.progName);
        Driver driver = new Driver();
        String url = "jdbc:jtds:" + DefaultProperties.getServerType(Integer.parseInt(this.serverType)) + ":";
        return driver.connect(url, props);
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), (class$net$sourceforge$jtds$jdbcx$JtdsObjectFactory == null ? (class$net$sourceforge$jtds$jdbcx$JtdsObjectFactory = JtdsDataSource.class$("net.sourceforge.jtds.jdbcx.JtdsObjectFactory")) : class$net$sourceforge$jtds$jdbcx$JtdsObjectFactory).getName(), null);
        ref.add(new StringRefAddr(Messages.get("prop.servername"), this.serverName));
        ref.add(new StringRefAddr(Messages.get("prop.servertype"), this.serverType));
        ref.add(new StringRefAddr(Messages.get("prop.portnumber"), this.portNumber));
        ref.add(new StringRefAddr(Messages.get("prop.databasename"), this.databaseName));
        ref.add(new StringRefAddr(Messages.get("prop.tds"), this.tdsVersion));
        ref.add(new StringRefAddr(Messages.get("prop.charset"), this.charset));
        ref.add(new StringRefAddr(Messages.get("prop.language"), this.language));
        ref.add(new StringRefAddr(Messages.get("prop.domain"), this.domain));
        ref.add(new StringRefAddr(Messages.get("prop.instance"), this.instance));
        ref.add(new StringRefAddr(Messages.get("prop.lastupdatecount"), this.lastUpdateCount));
        ref.add(new StringRefAddr(Messages.get("prop.useunicode"), this.sendStringParametersAsUnicode));
        ref.add(new StringRefAddr(Messages.get("prop.namedpipe"), this.namedPipe));
        ref.add(new StringRefAddr(Messages.get("prop.macaddress"), this.macAddress));
        ref.add(new StringRefAddr(Messages.get("prop.preparesql"), this.prepareSql));
        ref.add(new StringRefAddr(Messages.get("prop.packetsize"), this.packetSize));
        ref.add(new StringRefAddr(Messages.get("prop.user"), this.user));
        ref.add(new StringRefAddr(Messages.get("prop.password"), this.password));
        ref.add(new StringRefAddr(Messages.get("prop.logintimeout"), this.loginTimeout));
        ref.add(new StringRefAddr(Messages.get("prop.lobbuffer"), this.lobBuffer));
        ref.add(new StringRefAddr(Messages.get("prop.appname"), this.appName));
        ref.add(new StringRefAddr(Messages.get("prop.progname"), this.progName));
        return ref;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return Logger.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        Logger.setLogWriter(out);
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = String.valueOf(loginTimeout);
    }

    public int getLoginTimeout() throws SQLException {
        return Integer.parseInt(this.loginTimeout);
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = String.valueOf(portNumber);
    }

    public int getPortNumber() {
        return Integer.parseInt(this.portNumber);
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setTds(String tds) {
        this.tdsVersion = tds;
    }

    public String getTds() {
        return this.tdsVersion;
    }

    public void setServerType(int serverType) {
        this.serverType = String.valueOf(serverType);
    }

    public int getServerType() {
        return Integer.parseInt(this.serverType);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public boolean getSendStringParametersAsUnicode() {
        return Boolean.valueOf(this.sendStringParametersAsUnicode);
    }

    public void setSendStringParametersAsUnicode(boolean sendStringParametersAsUnicode) {
        this.sendStringParametersAsUnicode = String.valueOf(sendStringParametersAsUnicode);
    }

    public boolean getNamedPipe() {
        return Boolean.valueOf(this.namedPipe);
    }

    public void setNamedPipe(boolean namedPipe) {
        this.namedPipe = String.valueOf(namedPipe);
    }

    public boolean getLastUpdateCount() {
        return Boolean.valueOf(this.lastUpdateCount);
    }

    public void setLastUpdateCount(boolean lastUpdateCount) {
        this.lastUpdateCount = String.valueOf(lastUpdateCount);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = String.valueOf(packetSize);
    }

    public int getPacketSize() {
        return Integer.parseInt(this.packetSize);
    }

    public void setPrepareSql(int prepareSql) {
        this.prepareSql = String.valueOf(prepareSql);
    }

    public int getPrepareSql() {
        return Integer.parseInt(this.prepareSql);
    }

    public void setLobBuffer(long lobBuffer) {
        this.lobBuffer = String.valueOf(lobBuffer);
    }

    public long getLobBuffer() {
        return Long.parseLong(this.lobBuffer);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setProgName(String progName) {
        this.progName = progName;
    }

    public String getProgName() {
        return this.progName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

