/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * ImageLoader.java
 *
 * Creator:
 * 05.08.2005 15:46:59 Pecar
 *
 * Maintainer:
 * 05.08.2005 15:46:59 Pecar
 *
 * Last Modification:
 * $Id: ImageLoader.java,v 1.1 2005/10/14 04:33:30 agraham Exp $
 *
 * Copyright (c) 2005 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.images;

import javax.swing.*;
import java.awt.*;
import java.net.URL;

/**
 * This class loads the requested image or returns the path/url of it.
 * All images are lookedup from the relativ view of this class.
 */
public class ImageLoader {

    /**
     * get the ImageIcon that is relativ to this class. If the Image is not found null will be returned.
     *
     * @param relUrl the relativ URL that identifies the image
     *               exp: /abashop/shoplogo.gif
     * @return the requested image icon or null if not found
     */
    public static ImageIcon getImageIcon(String relUrl) {
        try {
//      return new ImageIcon(ch.abacus.lib.images.ImageLoa6der.class.getResource(relUrl));
            return new ImageIcon(getAbsoluteImageUrl(relUrl));
        } catch(NullPointerException e) {
            // it's ok, image is not found so null is returned
        }
        return null;
    }

    /**
     * get the Imagethat is relativ to this class. If the Image is not found null will be returned.
     *
     * @param relUrl the relativ URL that identifies the image
     *               exp: /abashop/shoplogo.gif
     * @return the requested image icon or null if not found
     */
    public static Image getImage(String relUrl) {
        return Toolkit.getDefaultToolkit().getImage(getAbsoluteImageUrl(relUrl));
    }


    /**
     * get the absolut path of the image. If the Image is not found null will be returned.
     *
     * @param relUrl the relativ URL that identifies the image
     *               exp: /abashop/shoplogo.gif
     * @return the absolute path of the image or null if not found
     */
    public static String getAbsoluteImagePath(String relUrl) {
        try {
            return ch.abacus.lib.images.ImageLoader.class.getResource(relUrl).getPath();
        } catch(NullPointerException e) {
            // it's ok, image is not found so null is returned
        }
        return null;
    }

    /**
     * get the absolut URL of the image. If the Image is not found null will be returned.
     *
     * @param relUrl the relativ URL that identifies the image
     *               exp: /abashop/shoplogo.gif
     * @return the absolute path of the image or null if not found
     */
    public static URL getAbsoluteImageUrl(String relUrl) {
        assert relUrl != null;
        URL url = ch.abacus.lib.images.ImageLoader.class.getResource(relUrl);
        if(url == null)
            System.err.println("ImageLoader Resource '" + relUrl + "' is not available !!!");
        return url;
    }

    /**
     * Returns an CatalogIcon for an application by its name.
     * <p/>
     * Please use one of the constants in the CatalogImages.class
     * <p/>
     * A list of all Images for the application can be found under
     * <p/>
     * http://intranet/bugbox/pablo/index.html
     */
    public static ImageIcon getCatalogIcon(String _Name) {
        return getImageIcon("catalog/" + _Name);
    }

    /**
     * test method
     */
    public static void main(String s[]) {
        System.out.println("XXX: path of Glp_exit.png: " + getAbsoluteImagePath("Glp_exit.png"));
        System.out.println("XXX: ImageIconObject Glp_exit.png: " + getImageIcon("Glp_exit.png"));
        System.out.println("XXX: ImageIconObject not found: " + getImageIcon("not_be_found"));
        System.out.println("XXX: getAbsoluteImagePath not found: " + getAbsoluteImagePath("not_be_found"));
        System.out.println("XXX: getAbsoluteImageUrl not found: " + getAbsoluteImageUrl("not_be_found"));
        System.out.println("XXX: getImage glp_standard.png: " + getImage("glp_standard.png"));
        System.out.println("XXX: getImage not found: " + getImage("not_found"));
    }
}