/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.Vector;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/**
 * Subclass of JTable with the addition of the Validation Events. Constructors are identical to JTable.
 */
public class JATable extends JTable {

  /**
   * Constructor for JATable.
   */
  public JATable() {
    super();
    init();
  }

  /**
   * Constructor for JATable.
   * @param dm
   */
  public JATable(TableModel dm) {
    super(dm);
    init();
  }

  /**
   * Constructor for JATable.
   * @param dm
   * @param cm
   */
  public JATable(TableModel dm, TableColumnModel cm) {
    super(dm, cm);
    init();
  }

  /**
   * Constructor for JATable.
   * @param dm
   * @param cm
   * @param sm
   */
  public JATable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
    super(dm, cm, sm);
    init();
  }

  /**
   * Constructor for JATable.
   * @param numRows
   * @param numColumns
   */
  public JATable(int numRows, int numColumns) {
    super(numRows, numColumns);
    init();
  }

  /**
   * Constructor for JATable.
   * @param rowData
   * @param columnNames
   */
  public JATable(Vector rowData, Vector columnNames) {
    super(rowData, columnNames);
    init();
  }

  /**
   * Constructor for JATable.
   * @param rowData
   * @param columnNames
   */
  public JATable(Object[][] rowData, Object[] columnNames) {
    super(rowData, columnNames);
    init();
  }

  /**
   * internal initialization of the validation events stuff
   */
  private void init() {
  }

    /**
     * Stops cell editing, is called by movement on the grid
     *
     * @return true if the table was in editing mode, else false is returned
     */
    public boolean endEditing() {
      if (isEditing()) {
        getCellEditor(getEditingRow(), getEditingColumn()).stopCellEditing();
        return true;
      }

      return false;
    }
}
