/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.plaf;

import java.awt.*;

import javax.swing.plaf.ColorUIResource;

/**
 * this class...
 * Created on 09.08.2002
 * @author hemmer
 * Copyright (c) 2001-2002 ABACUS Research AG All Rights Reserved.
 */


public class AbacusTheme {
  public static final ColorUIResource white = new ColorUIResource(255, 255, 255);
  public static final ColorUIResource black = new ColorUIResource(0, 0, 0);
  public static final ColorUIResource maroon = new ColorUIResource(128, 0, 0);
  public static final ColorUIResource green = new ColorUIResource(0, 128, 0);
  public static final ColorUIResource olive = new ColorUIResource(128, 128, 0);
  public static final ColorUIResource navy = new ColorUIResource(0, 0, 128);
  public static final ColorUIResource purple = new ColorUIResource(128, 0, 128);
  public static final ColorUIResource teal = new ColorUIResource(0, 128, 128);
  public static final ColorUIResource gray = new ColorUIResource(128, 128, 128);
  public static final ColorUIResource silver = new ColorUIResource(192, 192, 192);
  public static final ColorUIResource red = new ColorUIResource(255, 0, 0);
  public static final ColorUIResource lime = new ColorUIResource(0, 255, 0);
  public static final ColorUIResource yellow = new ColorUIResource(255, 255, 0);
  public static final ColorUIResource blue = new ColorUIResource(0, 0, 255);
  public static final ColorUIResource fuchsia = new ColorUIResource(255, 0, 255);
  public static final ColorUIResource aqua = new ColorUIResource(0, 255, 255);
  public static final ColorUIResource lightGray = new ColorUIResource(192, 192, 192);
  public static final ColorUIResource darkGray = new ColorUIResource(128, 128, 128);

  public static final ColorUIResource btnFace = new ColorUIResource(SystemColor.control.getRGB());
  public static final ColorUIResource btnShadow = new ColorUIResource(SystemColor.controlShadow.getRGB());
  public static final ColorUIResource highLight = new ColorUIResource(SystemColor.textHighlight.getRGB());
  public static final ColorUIResource menuText = new ColorUIResource(SystemColor.menuText.getRGB());

  public static final ColorUIResource entryLinkColor = new ColorUIResource(0x000080);

  // this was the original code
//  public static final ColorUIResource inactiveCaption = new ColorUIResource(SystemColor.inactiveCaption.getRGB());
  public static final ColorUIResource inactiveCaption = darkGray;




  private static final ColorUIResource colGroupFill = new ColorUIResource(181, 190, 215);
  private static final ColorUIResource colGroupBorder = new ColorUIResource(139, 146, 226);
  private static final ColorUIResource colGroupFont = black;
  private static final ColorUIResource colGroupFillFooter = silver;
  private static final ColorUIResource colGroupBorderFooter = gray;
  private static final ColorUIResource colGroupFontFooter = navy;
  private static final ColorUIResource xpBaseSelectColor = highLight;

  private static ColorUIResource xpColor = btnFace;
  private static ColorUIResource xpIconBackColor = btnFace;
  private static ColorUIResource xpMenuBarColor = btnFace;
  private static ColorUIResource xpSelectColor = highLight;
  private static ColorUIResource xpSelectBorderColor = highLight;
  private static ColorUIResource xpSelectFontColor = menuText;
  private static ColorUIResource xpDisabledColor = inactiveCaption;
  private static ColorUIResource xpSeparatorColor = btnFace;
  private static ColorUIResource xpCheckedColor = highLight;

  private static ColorUIResource xpGridZebraColor = new ColorUIResource( new Color(0xE1ECFF) );
  private static ColorUIResource xpToolBarBGColor;



  public static final ColorUIResource window = new ColorUIResource( SystemColor.window );
  public static final ColorUIResource windowText = new ColorUIResource( SystemColor.windowText );


  // Button
  private static ColorUIResource xpButtonUpLeftCorner;

  // Line & Border Colors
  private static ColorUIResource xpBorderHovered;
  private static ColorUIResource xpBorderFocused;
  private static ColorUIResource xpBorderNormal;

  // Fill Colors
  private static ColorUIResource xpFillNormal;
  private static ColorUIResource xpFillFocused;
  private static ColorUIResource xpFillHovered;
  private static ColorUIResource xpFillDown;

  // Menu Colors
  private static ColorUIResource xpMenuBorderColor;
  private static ColorUIResource xpMenuShadowColor;
  //private static ColorUIResource xpFont: TFont;

  // Special
  private static ColorUIResource xpCheckedAreaColor;
  private static ColorUIResource xpCheckedAreaSelectColor;
  private static ColorUIResource xpToolButtonBGColor;

  private static ColorUIResource xpCatalogBGColor;

  // Arrow Colors
  private static ColorUIResource xpArrowNormal;
  private static ColorUIResource xpArrowDown;
  private static ColorUIResource xpArrowDisabled;

  private static boolean colorsInitialized = false;




  public AbacusTheme() {
    initColors();
  }

  private static void initColors() {
    if(!colorsInitialized) {
      xpArrowDown = white;
      xpArrowNormal = black;
      xpArrowDisabled = white;
      xpSelectColor = lightColor(xpSelectColor, 68);
      xpCheckedAreaColor = lightColor(xpSelectColor, 80);
      xpCheckedAreaSelectColor = lightColor(xpSelectColor, 50);
      xpMenuBorderColor = shadeColor(btnFace, 90);
      xpMenuShadowColor = shadeColor(btnFace, 76);
      xpButtonUpLeftCorner = lightColor(btnShadow, 30);
      xpDisabledColor = btnShadow;
      xpBorderFocused = lightColor(xpSelectBorderColor, 60);
      xpBorderNormal = shadeColor(btnFace, 60);
      xpBorderHovered = shadeColor(xpBorderFocused, 30);
      xpFillNormal = btnFace;
      xpFillDown = shadeColor(xpBorderFocused, 15);
      xpFillFocused = lightColor(xpBorderFocused, 50);
      xpFillHovered = lightColor(xpBorderNormal, 90);
      xpToolButtonBGColor = shadeColor(xpIconBackColor, 15);
      xpToolBarBGColor = lightColor(xpIconBackColor, 30);

      xpCatalogBGColor = lightColor ( xpFillNormal, 40);//new ColorUIResource(231,231,227);



      colorsInitialized = true;
    }
  }

  private static int lightColorValue(int colorValue, int percent) {
    int t = ((255 - colorValue) * percent);
    if(t % 100 >= 50)
      t = (t / 100) + 1;
    else
      t = t / 100;
    return colorValue + t;
  }
  private static ColorUIResource lightColor(ColorUIResource color, int percent) {
    if(percent <= 0) return color;
    if(percent > 100) percent = 100;
    return new ColorUIResource(lightColorValue(color.getRed(), percent), lightColorValue(color.getGreen(), percent), lightColorValue(color.getBlue(), percent));
  }

  private static int trimColor(int colorValue, int trimValue) {
    colorValue -= trimValue;
    if(colorValue < 0) return 0;
    else if(colorValue > 255) return 255;
    else return colorValue;
  }

  private static ColorUIResource shadeColor(ColorUIResource color, int colorValue) {
    return new ColorUIResource(trimColor(color.getRed(), colorValue), trimColor(color.getGreen() + 2, colorValue), trimColor(color.getBlue(), colorValue));
  }
  /**
   * Returns the aqua.
   * @return ColorUIResource
   */
  public ColorUIResource getAqua() {
    return aqua;
  }

  /**
   * Returns the black.
   * @return ColorUIResource
   */
  public ColorUIResource getBlack() {
    return black;
  }

  /**
   * Returns the blue.
   * @return ColorUIResource
   */
  public ColorUIResource getBlue() {
    return blue;
  }

  /**
   * Returns the btnFace.
   * @return ColorUIResource
   */
  public ColorUIResource getBtnFace() {
    return btnFace;
  }

  /**
   * Returns the btnShadow.
   * @return ColorUIResource
   */
  public ColorUIResource getBtnShadow() {
    return btnShadow;
  }

  /**
   * Returns the colGroupBorder.
   * @return ColorUIResource
   */
  public ColorUIResource getColGroupBorder() {
    return colGroupBorder;
  }

  /**
   * Returns the colGroupBorderFooter.
   * @return ColorUIResource
   */
  public ColorUIResource getColGroupBorderFooter() {
    return colGroupBorderFooter;
  }

  /**
   * Returns the colGroupFill.
   * @return ColorUIResource
   */
  public ColorUIResource getColGroupFill() {
    return colGroupFill;
  }

  /**
   * Returns the colGroupFillFooter.
   * @return ColorUIResource
   */
  public ColorUIResource getColGroupFillFooter() {
    return colGroupFillFooter;
  }

  /**
   * Returns the colGroupFont.
   * @return ColorUIResource
   */
  public ColorUIResource getColGroupFont() {
    return colGroupFont;
  }

  /**
   * Returns the colGroupFontFooter.
   * @return ColorUIResource
   */
  public ColorUIResource getColGroupFontFooter() {
    return colGroupFontFooter;
  }

  /**
   * Returns the colorsInitialized.
   * @return boolean
   */
  public boolean isColorsInitialized() {
    return colorsInitialized;
  }

  /**
   * Returns the darkGray.
   * @return ColorUIResource
   */
  public ColorUIResource getDarkGray() {
    return darkGray;
  }

  /**
   * Returns the fuchsia.
   * @return ColorUIResource
   */
  public ColorUIResource getFuchsia() {
    return fuchsia;
  }

  /**
   * Returns the gray.
   * @return ColorUIResource
   */
  public ColorUIResource getGray() {
    return gray;
  }

  /**
   * Returns the green.
   * @return ColorUIResource
   */
  public ColorUIResource getGreen() {
    return green;
  }

  /**
   * Returns the highLight.
   * @return ColorUIResource
   */
  public ColorUIResource getHighLight() {
    return highLight;
  }

  /**
   * Returns the inactiveCaption.
   * @return ColorUIResource
   */
  public ColorUIResource getInactiveCaption() {
    return inactiveCaption;
  }

  /**
   * Returns the lightGray.
   * @return ColorUIResource
   */
  public ColorUIResource getLightGray() {
    return lightGray;
  }

  /**
   * Returns the lime.
   * @return ColorUIResource
   */
  public ColorUIResource getLime() {
    return lime;
  }

  /**
   * Returns the maroon.
   * @return ColorUIResource
   */
  public ColorUIResource getMaroon() {
    return maroon;
  }

  /**
   * Returns the MenuText.
   * @return ColorUIResource
   */
  public ColorUIResource getMenuText() {
    return menuText;
  }

  /**
   * Returns the navy.
   * @return ColorUIResource
   */
  public ColorUIResource getNavy() {
    return navy;
  }

  /**
   * Returns the olive.
   * @return ColorUIResource
   */
  public ColorUIResource getOlive() {
    return olive;
  }

  /**
   * Returns the purple.
   * @return ColorUIResource
   */
  public ColorUIResource getPurple() {
    return purple;
  }

  /**
   * Returns the red.
   * @return ColorUIResource
   */
  public ColorUIResource getRed() {
    return red;
  }

  /**
   * Returns the silver.
   * @return ColorUIResource
   */
  public ColorUIResource getSilver() {
    return silver;
  }

  /**
   * Returns the teal.
   * @return ColorUIResource
   */
  public ColorUIResource getTeal() {
    return teal;
  }

  /**
   * Returns the white.
   * @return ColorUIResource
   */
  public ColorUIResource getWhite() {
    return white;
  }

  /**
   * Returns the xpArrowDisabled.
   * @return ColorUIResource
   */
  public ColorUIResource getArrowDisabled() {
    return xpArrowDisabled;
  }

  /**
   * Returns the xpArrowDown.
   * @return ColorUIResource
   */
  public ColorUIResource getArrowDown() {
    return xpArrowDown;
  }

  /**
   * Returns the xpArrowNormal.
   * @return ColorUIResource
   */
  public ColorUIResource getArrowNormal() {
    return xpArrowNormal;
  }

  /**
   * Returns the xpBaseSelectColor.
   * @return ColorUIResource
   */
  public ColorUIResource getBaseSelectColor() {
    return xpBaseSelectColor;
  }

  /**
   * Returns the xpBorderFocused.
   * @return ColorUIResource
   */
  public ColorUIResource getBorderFocused() {
    return xpBorderFocused;
  }

  /**
   * Returns the xpBorderHovered.
   * @return ColorUIResource
   */
  public ColorUIResource getBorderHovered() {
    return xpBorderHovered;
  }

  /**
   * Returns the xpBorderNormal.
   * @return ColorUIResource
   */
  public ColorUIResource getBorderNormal() {
    return xpBorderNormal;
  }

  /**
   * Returns the xpButtonUpLeftCorner.
   * @return ColorUIResource
   */
  public ColorUIResource getButtonUpLeftCorner() {
    return xpButtonUpLeftCorner;
  }

  /**
   * Returns the xpCheckedAreaColor.
   * @return ColorUIResource
   */
  public ColorUIResource getCheckedAreaColor() {
    return xpCheckedAreaColor;
  }

  /**
   * Returns the xpCheckedAreaSelectColor.
   * @return ColorUIResource
   */
  public ColorUIResource getCheckedAreaSelectColor() {
    return xpCheckedAreaSelectColor;
  }

  /**
   * Returns the xpCheckedColor.
   * @return ColorUIResource
   */
  public ColorUIResource getCheckedColor() {
    return xpCheckedColor;
  }

  /**
   * Returns the xpColor.
   * @return ColorUIResource
   */
  public ColorUIResource getColor() {
    return xpColor;
  }

  /**
   * Returns the xpDisabledColor.
   * @return ColorUIResource
   */
  public ColorUIResource getDisabledColor() {
    return xpDisabledColor;
  }

  /**
   * Returns the xpFillDown.
   * @return ColorUIResource
   */
  public ColorUIResource getFillDown() {
    return xpFillDown;
  }

  /**
   * Returns the xpFillFocused.
   * @return ColorUIResource
   */
  public ColorUIResource getFillFocused() {
    return xpFillFocused;
  }

  /**
   * Returns the xpFillHovered.
   * @return ColorUIResource
   */
  public ColorUIResource getFillHovered() {
    return xpFillHovered;
  }

  /**
   * Returns the xpFillNormal.
   * @return ColorUIResource
   */
  public ColorUIResource getFillNormal() {
    return xpFillNormal;
  }

  /**
   * Returns the xpIconBackColor.
   * @return ColorUIResource
   */
  public ColorUIResource getIconBackColor() {
    return xpIconBackColor;
  }

  /**
   * Returns the xpMenuBarColor.
   * @return ColorUIResource
   */
  public ColorUIResource getMenuBarColor() {
    return xpMenuBarColor;
  }

  /**
   * Returns the xpMenuBorderColor.
   * @return ColorUIResource
   */
  public ColorUIResource getMenuBorderColor() {
    return xpMenuBorderColor;
  }

  /**
   * Returns the xpMenuShadowColor.
   * @return ColorUIResource
   */
  public ColorUIResource getMenuShadowColor() {
    return xpMenuShadowColor;
  }

  /**
   * Returns the xpSelectBorderColor.
   * @return ColorUIResource
   */
  public ColorUIResource getSelectBorderColor() {
    return xpSelectBorderColor;
  }

  /**
   * Returns the xpSelectColor.
   * @return ColorUIResource
   */
  public ColorUIResource getSelectColor() {
    return xpSelectColor;
  }

  /**
   * Returns the xpSelectFontColor.
   * @return ColorUIResource
   */
  public ColorUIResource getSelectFontColor() {
    return xpSelectFontColor;
  }

  /**
   * Returns the xpSeparatorColor.
   * @return ColorUIResource
   */
  public ColorUIResource getSeparatorColor() {
    return xpSeparatorColor;
  }

  /**
   * Returns the xpToolButtonBGColor.
   * @return ColorUIResource
   */
  public ColorUIResource getToolButtonBGColor() {
    return xpToolButtonBGColor;
  }


  /**
   * Returns the xpToolBarBGColor.
   * @return ColorUIResource
   */
  public ColorUIResource getToolBarBGColor() {
    return xpToolBarBGColor;
  }

  /**
   * Returns the yellow.
   * @return ColorUIResource
   */
  public ColorUIResource getYellow() {
    return yellow;
  }

    public ColorUIResource getCatalogBGColor(){
        return xpCatalogBGColor;
    }

    public static ColorUIResource getGridZebraColor () {
        return xpGridZebraColor;
    }



}
