package ch.abacus.lib.ui.plaf.generic;

/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

/*
 * AbacusButtonUI.java
 *
 *
 * Based on code from 09.08.2002 20:07:01 Hemmer
 *
 * Moved/Edited to the generic branch on March 29th 2005 by open source.
 * $Id: GenericButtonUI.java,v 1.4 2005/03/29 22:22:59 mario Exp $
 *
 */

public class GenericButtonUI extends BasicButtonUI {
  private GenericButtonListener mButtonListener = new GenericButtonListener(null);

  private Color mSavedSelectedBackgroundColor;

  public static ComponentUI createUI(JComponent c) {

     return new GenericButtonUI();
  }

  protected BasicButtonListener createButtonListener(AbstractButton b) {
    return mButtonListener;
  }

  public void paint(Graphics g, JComponent c) {
    super.paint(g, c);
    AbstractButton b = (AbstractButton) c;

    if(b.getModel().isSelected()) {
      if(b.getBackground() != GenericLookAndFeel.getSelectColor()) {
        if(mSavedSelectedBackgroundColor == null) mSavedSelectedBackgroundColor = b.getBackground();
        if(!b.getModel().isPressed()) b.setBackground(GenericLookAndFeel.getFillDown());
      }
    } else if(mSavedSelectedBackgroundColor != null && !b.isFocusOwner()) {
      b.setBackground(mSavedSelectedBackgroundColor);
      mSavedSelectedBackgroundColor = null;
    }
  }

  // the focus is painted in the mouselistener
  protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
//    Rectangle focusRect = new Rectangle();
//    String text = b.getText();
//    boolean isIcon = b.getIcon() != null;
////     If there is text
//    if(text != null && !text.equals("")) {
//      if(!isIcon) {
//        focusRect.setBounds(textRect);
//      } else {
//        focusRect.setBounds(iconRect.union(textRect));
//      }
//    }
//    // If there is an icon and no text
//    else if(isIcon) {
//      focusRect.setBounds(iconRect);
//    }
//
//    // paint the selection of the button (this is the small line around the text
//    g.setColor(GenericLookAndFeel.getDarkGray());
//    g.drawRect((focusRect.x - 1), (focusRect.y - 1), focusRect.width + 1, focusRect.height + 1);
  }

  protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
    AbstractButton b = (AbstractButton) c;
    ButtonModel model = b.getModel();
    FontMetrics fm = g.getFontMetrics();
    int mnemIndex = b.getDisplayedMnemonicIndex();
    /* Draw the Text */
    if(model.isEnabled()) {
      /*** paint the text normally */
      g.setColor(b.getForeground());
      BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    } else {
      /*** paint the text disabled ***/
      g.setColor(GenericLookAndFeel.getDarkGray());
      BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }
  }
}

class GenericButtonListener extends BasicButtonListener {

  private Border mSavedBorder;
  private Color mSavedBackgroundColor;

  private Border mSavedFocuesdBorder;
  private Color mSavedFocusedBackgroundColor;

  public GenericButtonListener(AbstractButton b) {
    super(b);
  }

  public void focusGained(FocusEvent e) {
    if(((JComponent) e.getSource()).isEnabled()) {
      AbstractButton button = (AbstractButton) e.getSource();
      if(!button.getBackground().equals(GenericLookAndFeel.getSelectColor()) &&
          !button.getBackground().equals(GenericLookAndFeel.getFillDown())) {

        if(!button.getModel().isPressed()) {  // this is for the catalog, do not change color if a button is pressed
          mSavedFocusedBackgroundColor = button.getBackground();
          mSavedFocuesdBorder = button.getBorder();

          button.setBackground(GenericLookAndFeel.getSelectColor());
        } else {
          button.setBackground(GenericLookAndFeel.getFillDown());
        }
      }
      ((JComponent) e.getSource()).repaint();
    }
  }

  public void focusLost(FocusEvent e) {
    if(mSavedFocusedBackgroundColor != null && mSavedFocuesdBorder != null) {
      AbstractButton button = (AbstractButton) e.getSource();
      // this is a ugly hack, the catalog should not lose the pressed color...
      // the catalog is the second parent
      // Stuart: added a check that the parent is not null, as this situation happens in the Design Cockpit when buttons are being destroyed
      if ( (button.getParent() != null) && (button.getParent().getParent() instanceof ch.abacus.lib.ui.menu.Catalog) ) {
        if(!button.getModel().isPressed()) {
          button.setBackground(mSavedFocusedBackgroundColor);
          button.setBorder(mSavedFocuesdBorder);
          mSavedFocusedBackgroundColor = null;
          mSavedFocuesdBorder = null;
        }
      } else {
        button.setBackground(mSavedFocusedBackgroundColor);
        button.setBorder(mSavedFocuesdBorder);
      }
      ((JComponent) e.getSource()).repaint();
    }
  }


  public void mouseEntered(MouseEvent e) {
    super.mouseEntered(e);
    if(((JComponent) e.getSource()).isEnabled()) {
      AbstractButton button = (AbstractButton) e.getSource();
      if(!button.getBackground().equals(GenericLookAndFeel.getSelectColor()) &&
          !button.getBackground().equals(GenericLookAndFeel.getFillDown())) {

 //       if ( button.isFocusable () == false ) return;
        if(!button.getModel().isPressed()) {  // this is for the catalog, do not change color if a button is pressed
          if(button.getModel().isSelected()) {
            mSavedBackgroundColor = button.getBackground();
            mSavedBorder = button.getBorder();
            button.setBackground(GenericLookAndFeel.getSelectColor());
          } else {
            mSavedBackgroundColor = button.getBackground();
            mSavedBorder = button.getBorder();
            button.setBackground(GenericLookAndFeel.getSelectColor());
          }
        } else {
          button.setBackground(GenericLookAndFeel.getFillDown());
        }
        button.setBorder(GenericBorders.getHoveredButtonBorder(button));
      }
    }
  }

  public void mouseExited(MouseEvent e) {
    super.mouseExited(e);
    if(mSavedBackgroundColor != null && mSavedBorder != null) {
      AbstractButton button = (AbstractButton) e.getSource();

 //     if ( button.isFocusable () == false ) return;

      if(!button.getModel().isPressed()) {
        button.setBackground(mSavedBackgroundColor);
        button.setBorder(mSavedBorder);

// test that if it runs right 10.11.03
        mSavedBackgroundColor = null;
        mSavedBorder = null;
      } else {
        if(!button.isFocusable()) { // added cause the new focusmanagement sets the catalog/menu-buttons to non focusable 12.08.2004 / phe
          button.setBorder(mSavedBorder);
        }
      }
    }
  }

  public void mousePressed(MouseEvent e) {
    super.mousePressed(e);
    if(((JComponent) e.getSource()).isEnabled()) {
      AbstractButton button = (AbstractButton) e.getSource();

//      if ( button.isFocusable () == false ) return; // removed cause the non focussable button painted wrong (10.2.2005 phe)
      if(mSavedBackgroundColor == null && mSavedBorder == null) {
        mSavedBackgroundColor = button.getBackground();
        mSavedBorder = button.getBorder();
      } else {
        // hack to fix the problem, that the label has not enough space and is painted with "..." 10.11.03
        button.setBackground(mSavedBackgroundColor);
        button.setBorder(mSavedBorder);
      }
      button.setBackground(GenericLookAndFeel.getFillDown());
    }
  }

  public void mouseReleased(MouseEvent e) {
    super.mouseReleased(e);
    if(mSavedBackgroundColor != null && mSavedBorder != null) {
      AbstractButton button = (AbstractButton) e.getSource();

  //    if ( button.isFocusable () == false ) return;

      if(!button.getModel().isPressed()) { // this is for the catalog, do not change color if a button is pressed

        if(button.getModel().isSelected()) {
          button.setBackground(GenericLookAndFeel.getSelectColor());
        } else if(button.isFocusOwner()) {
          button.setBackground(GenericLookAndFeel.getSelectColor());
          button.setBorder(GenericBorders.getHoveredButtonBorder(button));
        } else if(!button.isFocusable()) {  // inserted cause the non focussable button painted wrong (10.2.2005 phe)
          button.setBackground(GenericLookAndFeel.getSelectColor());
          button.setBorder(GenericBorders.getHoveredButtonBorder(button));
        } else {
          button.setBackground(mSavedBackgroundColor);
          button.setBorder(mSavedBorder);
        }
      }
    }
  }
}