/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 16:47:28 Misteli
 *
 * Maintainer:
 * 15.04.2005 16:47:28 Misteli
 *
 * Last Modification:
 * $Id: Clazz.java,v 1.2 2005/09/03 08:50:24 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

/**
 * A Clazz is used to define a shadow class. Since the property editor is basically used to edit properties of a physical class
 * that exists already, it makes sense to define this class hierarchy in a way we need it.
 * A Clazz can inherit from another base class and contains all properties that are needed for this class.
 * A Clazz also has a physical class it belongs to. A sample usage for Swing components could be to define the class hierarchy
 * about as follows:
 * <code>
 * Clazz jcomponent = new Clazz(null, JComponent.class);
 * jcomponent.getProperties().add(new Property(.... "left", ..));
 * jcomponent.getProperties().add(new Property(.... "top", ..));
 * Clazz jcheckbox = new Clazz(jcomponent, JCheckBox.class);
 * jcheckbox.getProperties().add(new Property(...., "checked", ...));
 * </code>
 * etc..
 */
public class Clazz {

  private Properties properties = new Properties(this);
  private Class origin;
  private String originClass;
  private Clazz parent;
  private Clazzes inheritance = new Clazzes();

  public Clazz(Clazz parent, Class origin, String originClass) {
    this.parent = parent;
    if (parent != null)
      parent.inheritance.add(this);
    this.origin = origin;
    this.originClass = originClass;
  }

  public Clazz(Clazz parent, String originClass) {
    this(parent, null, originClass);
  }

  public Clazz(Clazz parent, Class origin) {
    this(parent, origin, null);
  }

  public Clazz findByInstance(Object object) {
    if (isClazzObject(object, this))
      return this;
    Clazz clazz;
    for (int i=0; i<inheritance.size(); i++) {
      clazz = inheritance.get(i).findByInstance(object);
      if (clazz != null)
        return clazz;
    }
    return null;
  }

  private boolean isClazzObject(Object object, Clazz clazz) {
    boolean ok;
    if (originClass != null)
      ok = clazz.originClass.equals(object);
    else
      ok = clazz.origin == object.getClass();
    if (!ok) { // Sinds vielleicht Interfaces?
      if (originClass == null) {
        Class[] interfaces = object.getClass().getInterfaces();
        for (int i=0; i<interfaces.length; i++)
          if (interfaces[i] == clazz.origin)
            return true;
      }
    }
    return ok;
  }

  public Clazzes getInheritance() {
    return inheritance;
  }

  public Properties getProperties() {
    return properties;
  }

//  public Class getOrigin() {
//    return origin;
//  }

  public Clazz getParent() {
    return parent;
  }

}
