/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 16:46:16 Misteli
 *
 * Maintainer:
 * 15.04.2005 16:46:16 Misteli
 *
 * Last Modification:
 * $Id: Values.java,v 1.1 2005/09/02 14:26:04 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

import java.util.Comparator;

public class Values extends BaseList {

  public Object get(int index) {
    return list.get(index);
  }

  public Object getCurrentValue() {
    if (isSame())
      return list.get(0);
    else
      return null;
  }

  public boolean isSame() {
    boolean ok = true;
    if (list.size() > 0) {
      Object v = get(0);
      Object vv;
      for (int i=1; i<list.size(); i++) {
        vv = get(i);
        ok &= (v == null ? v == vv : v.equals(vv));
      }
    }
    return ok;
  }

  public Comparator comparator(boolean sortAlphabetically) {
    return new Comparator() {
      public int compare(Object o, Object o1) {
        return 0;
      }
    };
  }

}
