/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 10:37:17 Misteli
 *
 * Maintainer:
 * 18.04.2005 10:37:17 Misteli
 *
 * Last Modification:
 * $Id: DisplayGroups.java,v 1.2 2005/09/02 14:35:39 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import ch.abacus.lib.ui.propertyinspector.core.BaseList;
import ch.abacus.lib.ui.propertyinspector.core.Group;

import java.util.Comparator;

public class DisplayGroups extends BaseList {

  public DisplayGroup get(int index) {
    return (DisplayGroup) list.get(index);
  }

  public DisplayGroup findByGroup(Group group) {
    DisplayGroup g;
    for (int i=0; i<list.size(); i++) {
      g = get(i);
      if (g.getGroup() == group)
        return g;

    }
    return null;
  }

  public Comparator comparator(final boolean sortAlphabetically) {
    return new Comparator() {
      public int compare(Object o, Object o1) {
        if (!sortAlphabetically)
          return 0;
        DisplayGroup g1 = (DisplayGroup) o;
        DisplayGroup g2 = (DisplayGroup) o1;
        return g1.getGroup().getName().compareTo(g2.getGroup().getName());
      }
    };
  }

}
