/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 21.04.2005 13:59:13 Misteli
 *
 * Maintainer:
 * 21.04.2005 13:59:13 Misteli
 *
 * Last Modification:
 * $Id: PropertyEditorEvent.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import javax.swing.table.TableCellEditor;

public class PropertyEditorEvent {

  private PropertyValueEditorInterface editor;
  private DisplayProperty displayProperty;
  private Object value;
  private PropertyRunner handler;

  public PropertyEditorEvent(PropertyValueEditorInterface editor, DisplayProperty displayProperty, Object value, PropertyRunner handler) {
    this.editor = editor;
    this.displayProperty = displayProperty;
    this.value = value;
    this.handler = handler;
  }

  public TableCellEditor getEditor() {
    return editor;
  }

  public DisplayProperty getDisplayProperty() {
    return displayProperty;
  }

  public Object getValue() {
    return value;
  }

  public void setValue(Object value) {
    handler.execute(value);
  }

}
