/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 22.04.2005 08:58:53 Misteli
 *
 * Maintainer:
 * 22.04.2005 08:58:53 Misteli
 *
 * Last Modification:
 * $Id: PropertyRendererRegistry.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import java.util.HashMap;
import java.util.Iterator;

public class PropertyRendererRegistry {

  private HashMap<String, PropertyRendererInterface> map = new HashMap<String, PropertyRendererInterface>();

  public PropertyRendererInterface register(String name, PropertyRendererInterface renderer) {
    if (map.containsKey(name))
      throw new IllegalArgumentException("PropertyRenderer " + name + " is already registered");
    map.put(name, renderer);
    return renderer;
  }

  public PropertyRendererInterface get(String name) {
    return map.get(name);
  }

  public Iterator iterator() {
    return map.values().iterator();
  }

}
