/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 19.04.2005 12:32:25 Misteli
 *
 * Maintainer:
 * 19.04.2005 12:32:25 Misteli
 *
 * Last Modification:
 * $Id: BaseEditor.java,v 1.7 2005/09/27 13:34:01 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.editor;

import ch.abacus.lib.images.ImageLoader;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.layout.JABox;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyEditorEvent;
import ch.abacus.lib.ui.propertyinspector.display.PropertyRunner;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;
import ch.abacus.lib.ui.report.preview.PreviewPanel;

import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import java.util.Timer;
import java.util.TimerTask;

public class BaseEditor extends AbstractCellEditor implements PropertyValueEditorInterface {

  private JComponent editorComponent;
  private JTable table;

  private JAButton editorButton = new JAButton("..");
  private JAButton btnUp = new JAButton();
  private JAButton btnDown = new JAButton();

  protected EditorDelegate delegate;

  private PreviewPanel panel = new PreviewPanel();
  private DisplayProperty property;
  private boolean hasUpDown;
  private PreviewPanel editorButtonWrapper;
  private PreviewPanel spinButtonWrapper;
  private PropertyRunner propertyRunner = new PropertyRunner() {
    public void execute(Object value) {
      delegate.setValue(value);
      stopCellEditing();
    }
  };
  private ActionListener upDownActionListener = new ActionListener() {
    public void actionPerformed(ActionEvent e) {
      if (e.getSource() == btnUp)
        spinUp();
      else
      if (e.getSource() == btnDown)
        spinDown();
    }
  };
  private ActionListener buttonEditorActionListener = new ActionListener() {
    public void actionPerformed(ActionEvent e) {
      Object value = property.getValues().isSame() ? property.getValues().get(0) : null;
      property.getProperty().getPropertyEditor().edit(new PropertyEditorEvent(BaseEditor.this, property, value, propertyRunner));
    }
  };
  private ButtonMouseAdapter upDownMouseAdapter = new ButtonMouseAdapter(upDownActionListener);

  public BaseEditor() {
  }

  public boolean isModified() {
    return delegate.isModified();
  }

  public void modify() {
    delegate.modify();
  }

  public void setValueEditorReadOnly(boolean value) {
    editorComponent.setEnabled(!value);
  }

  public BaseEditor(final JTextField textField) {
    delegate = new EditorDelegate(this) {
      public void setValue(Object value) {
        textField.setText((value != null) ? value.toString() : "");
      }

      public void selectAll() {
        textField.selectAll();
      }

      public void selectNone() {
        textField.select(0, 0);
      }

      public Object getValue() {
        return textField.getText();
      }
    };
    initialize(textField);
    textField.addActionListener(delegate);
  }

  public BaseEditor (final JCheckBox checkBox) {
    delegate = new EditorDelegate(this) {
      public void setValue(Object value) {
        if (value == null)
          value = Boolean.FALSE;
        checkBox.setSelected(((Boolean) value).booleanValue());
      }

      public Object getValue() {
        return Boolean.valueOf(checkBox.isSelected());
      }
    };
    initialize(checkBox);
    checkBox.addActionListener(delegate);
  }

  public BaseEditor (final JComboBox comboBox) {
    comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    delegate = new EditorDelegate(this) {
      public void setValue(Object value) {
        comboBox.setSelectedIndex(((Integer) value).intValue());
      }

      public Object getValue() {
        return Integer.valueOf(comboBox.getSelectedIndex());
      }

      public boolean shouldSelectCell(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
          MouseEvent e = (MouseEvent) anEvent;
          return e.getID() != MouseEvent.MOUSE_DRAGGED;
        }
        return true;
      }

      public boolean stopCellEditing() {
        if (comboBox.isEditable()) {
          // Commit edited value.
          comboBox.actionPerformed(new ActionEvent(BaseEditor.this, 0, ""));
        }
        return super.stopCellEditing();
      }
    };
    initialize(comboBox);
    comboBox.addActionListener(delegate);
  }

  public void fireEditingStopped() {
    super.fireEditingStopped();
  }

  public void fireEditingCanceled() {
    super.fireEditingCanceled();
  }

  protected JAButton getEditorButton() {
    return editorButton;
  }

  private PreviewPanel getWrapperPanel(JComponent component) {
    PreviewPanel p = new PreviewPanel();
    p.setLayout(new BorderLayout());
    p.add(JABox.createHorizontalStrut(1), BorderLayout.WEST);
    p.add(component, BorderLayout.CENTER);
    return p;
  }

  public void initialized() {
  }

  protected void initialize(JComponent editor) {
    panel.setLayout(new BorderLayout(0, 0));
    editorComponent = editor;
    panel.add(editorComponent, BorderLayout.CENTER);

    // Create Button Wrappers..
    editorButtonWrapper = getWrapperPanel(editorButton);
    PreviewPanel p = new PreviewPanel();
    p.setLayout(new BorderLayout());
    p.add(btnUp, BorderLayout.NORTH);
    p.add(JABox.createVerticalStrut(1), BorderLayout.CENTER);
    p.add(btnDown, BorderLayout.SOUTH);
    btnUp.setIcon(ImageLoader.getImageIcon("spin_up.gif"));
    btnDown.setIcon(ImageLoader.getImageIcon("spin_down.gif"));
    btnUp.setPreferredSize(new Dimension(16, 7));
    btnDown.setPreferredSize(new Dimension(16, 7));
    spinButtonWrapper = getWrapperPanel(p);
    p = new PreviewPanel();
    p.setLayout(new FlowLayout(FlowLayout.TRAILING, 0, 0));
    p.add(spinButtonWrapper);
    p.add(editorButtonWrapper);
    panel.add(p, BorderLayout.EAST);

    // Add listeners..
    editorButton.addActionListener(buttonEditorActionListener);
    editorButton.setPreferredSize(new Dimension(16, 15));
    editorComponent.addKeyListener(delegate);
    editorComponent.addFocusListener(delegate);
    btnUp.addActionListener(upDownActionListener);
    btnUp.addMouseListener(upDownMouseAdapter);
    btnDown.addActionListener(upDownActionListener);
    btnDown.addMouseListener(upDownMouseAdapter);
  }

  public boolean isHasUpDown() {
    return hasUpDown;
  }

  public void setHasUpDown(boolean hasUpDown) {
    this.hasUpDown = hasUpDown;
  }

  public Object getCellEditorValue() {
    return delegate.getValue();
  }

  public boolean isCellEditable(EventObject anEvent) {
    return delegate.isCellEditable(anEvent);
  }

  public boolean shouldSelectCell(EventObject anEvent) {
    return delegate.shouldSelectCell(anEvent);
  }

  public boolean stopCellEditing() {
    return delegate.stopCellEditing();
  }

  protected void spinUp() {
  }

  protected void spinDown() {
  }

  public void cancelCellEditing() {
    delegate.cancelCellEditing();
  }

  public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
    this.table = table;
    property = (DisplayProperty) value;
    editorButtonWrapper.setVisible(property.getProperty().getPropertyEditor() != null && property.getProperty().getPropertyEditor().isVisible(property.getProperty()));
    spinButtonWrapper.setVisible(hasUpDown);
    if (property.getValues().isSame())
      delegate.setValue(property.getValues().get(0));
    else
      delegate.setValue(null);
    delegate.clearModified();
    return panel;
  }

}

class ButtonMouseAdapter implements MouseListener, MouseMotionListener {

  private boolean click = false;
  private ActionListener actionListener;
  private Timer timer;

  public ButtonMouseAdapter(ActionListener actionListener) {
    this.actionListener = actionListener;
  }

  public void mousePressed(MouseEvent e) {
    click = true;
    if (timer != null)
      return;
    createTimer();
    try {
      fire(e);
    }
    catch (IllegalStateException is) {
      createTimer();
    }
  }

  private void createTimer() {
    timer = new Timer("ButtonTimer", true);
  }

  private void fire(final MouseEvent e) {
    timer.schedule(new TimerTask() {
      public void run() {
        while (click) {
          try {
            if (click)
              actionListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
            Thread.sleep(100);
          }
          catch (InterruptedException ie) {
            click = false;
          }
        }
      }
    }, 500);
  }

  private void cancel() {
    click = false;
    if (timer != null)
      timer.cancel();
    timer = null;
  }

  public void mouseReleased(MouseEvent e) {
    cancel();
  }

  public void mouseClicked(MouseEvent e) {
    cancel();
  }

  public void mouseExited(MouseEvent e) {
    cancel();
  }

  public void mouseEntered(MouseEvent e) {  }
  public void mouseDragged(MouseEvent e) {  }
  public void mouseMoved(MouseEvent e) {  }
}