/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 15:42:39 Misteli
 *
 * Maintainer:
 * 18.04.2005 15:42:39 Misteli
 *
 * Last Modification:
 * $Id: BaseCellRenderer.java,v 1.3 2005/11/29 13:55:19 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.plaf.AbacusTheme;
import ch.abacus.lib.ui.propertyinspector.display.PropertyRendererInterface;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import java.awt.Color;
import java.awt.Font;

public abstract class BaseCellRenderer implements PropertyRendererInterface {

  protected Color background = UIManager.getColor("Panel.background");
  protected Color textBackground = UIManager.getColor("Table.background");
  protected Color textForeground = UIManager.getColor("Table.foreground");
  protected Color selectionBackground = UIManager.getColor("Table.selectionBackground");
  protected Color selectionForeground = UIManager.getColor("Table.selectionForeground");
  protected PropertyBorder border;
  protected Font font;
  protected JTable table;

  public BaseCellRenderer(JTable table) {
    font = table.getFont();
    border = new PropertyBorder(((PropertyModel) table.getModel()));
  }

  public BaseCellRenderer() {
    textForeground = AbacusTheme.navy;
  }

  public void initialize(JComponent component, JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
    if (isSelected) {
      component.setForeground(table.getSelectionForeground());
      component.setBackground(table.getSelectionBackground());
    }
    else {
      component.setForeground(textForeground);
      component.setBackground(textBackground);
    }

    component.setFont(table.getFont());
  }

}
