/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 22.04.2005 08:49:14 Misteli
 *
 * Maintainer:
 * 22.04.2005 08:49:14 Misteli
 *
 * Last Modification:
 * $Id: BaseStringListRenderer.java,v 1.2 2005/09/20 07:44:25 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.propertyinspector.core.StringEntry;

import javax.swing.Icon;
import java.util.List;

public class BaseStringListRenderer extends StringRenderer {

  private List<StringEntry> list;
  private List<Icon> icons;

  public BaseStringListRenderer(List<StringEntry> list) {
    this.list = list;
  }

  public BaseStringListRenderer(List<ch.abacus.lib.ui.propertyinspector.core.StringEntry> list, List<Icon> icons) {
    this.list = list;
    this.icons = icons;
  }

  public void setValue(Object value) {
    ch.abacus.lib.ui.propertyinspector.core.StringEntry entry;
    for (int i=0; i<list.size(); i++) {
      entry = list.get(i);
      if (entry.getProperty().equals(value)) {
        label.setText(entry.getTranslatedName());
        if (icons != null && i < icons.size())
          label.setIcon(icons.get(i));
        return;
      }
    }
    label.setText("");
    label.setIcon(null);
  }
}
