/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.util.CloseInterface;
import ch.abacus.lib.util.GlobalInterface;

import javax.swing.*;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 7:55:43 PM
 * To change this template use Options | File Templates.
 */

public class RendererFocusTraversalPolicy extends FocusTraversalPolicy implements CloseInterface {

    private static RendererFocusTraversalPolicy instance = new RendererFocusTraversalPolicy();
    private RendererFocusTree theTree;
    private GlobalInterface theGlobalInterface;


    private RendererFocusTraversalPolicy() {
    }

    public void init(MetaObject theTopObject, GlobalInterface _GlobalInterface) {
        this.theGlobalInterface = _GlobalInterface;
        theTree = new RendererFocusTree(theTopObject, theGlobalInterface);
        //ALEX
        if (theGlobalInterface != null) {

            theGlobalInterface.addToShutdownCollector(this);
        }
    }

    public void init(JComponent theTopObject, GlobalInterface _GlobalInterface) {
        this.theGlobalInterface = _GlobalInterface;
        theTree = new RendererFocusTree(theTopObject, theGlobalInterface);
        //ALEX
        if (theGlobalInterface != null) {

            theGlobalInterface.addToShutdownCollector(this);
        }
        if (getPolicyObject(theTopObject)) {
            Container theContainer = theTopObject;
            if (theContainer != null)
                theContainer.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
        }
    }

    public void init(JFrame theTopObject, GlobalInterface _GlobalInterface) {
        this.theGlobalInterface = _GlobalInterface;
        theTree = new RendererFocusTree(theTopObject, theGlobalInterface);
        //ALEX
        if (theGlobalInterface != null) {

            theGlobalInterface.addToShutdownCollector(this);
        }
        theTopObject.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
    }

    public void init(JDialog theTopObject, GlobalInterface _GlobalInterface) {
        this.theGlobalInterface = _GlobalInterface;
        theTree = new RendererFocusTree(theTopObject, theGlobalInterface);
        //ALEX
        if (theGlobalInterface != null) {

            theGlobalInterface.addToShutdownCollector(this);
        }
        theTopObject.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
    }

    public static boolean getPolicyObject(Object oTest) {
        if ((oTest instanceof JFrame) || (oTest instanceof JPanel) ||
                (oTest instanceof ButtonGroup))
            return true;
        else
            return false;
    }

    //ALEX
    public void close() {
        instance = null;
        if (theGlobalInterface != null) {
            theGlobalInterface.removeFromShutdownCollector(this);
        }
    }

    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        RendererFocusNode theMatchingNode;
        theMatchingNode = theTree.getMatchingNode(aComponent);
        if (theMatchingNode != null)
            return theMatchingNode.next();
        else
            return aComponent;  // stuck here.
    }

    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        RendererFocusNode theMatchingNode;
        theMatchingNode = theTree.getMatchingNode(aComponent);
        if (theMatchingNode != null)
            return theMatchingNode.previous();
        else
            return aComponent;  // stuck here.
    }

    public Component getDefaultComponent(Container focusCycleRoot) {
        RendererFocusNode theMatchingNode;
        theMatchingNode = theTree.getMatchingNode(focusCycleRoot);
        if (theMatchingNode != null)
            return theMatchingNode.first();
        else
            return focusCycleRoot;  // stuck here.
    }

    public Component getFirstComponent(Container focusCycleRoot) {
        RendererFocusNode theMatchingNode;
        theMatchingNode = theTree.getMatchingNode(focusCycleRoot);
        if (theMatchingNode != null)
            return theMatchingNode.first();
        else
            return focusCycleRoot;  // stuck here.
    }

    public Component getLastComponent(Container focusCycleRoot) {
        RendererFocusNode theMatchingNode = theTree.getMatchingNode(focusCycleRoot);
        if (theMatchingNode != null)
            return theMatchingNode.last();
        else
            return focusCycleRoot;  // stuck here.
    }

    public Component getInitialComponent(Window window) {
        RendererFocusNode theMatchingNode = theTree.getMatchingNode(window);
        if (theMatchingNode != null)
            return theMatchingNode.first();
        else
            return window;  // stuck here.
    }

    public static RendererFocusTraversalPolicy getInstance() {
        //ALEX
        if (instance == null) {
            instance = new RendererFocusTraversalPolicy();
        }
        return instance;
    }

    public RendererFocusTree getTree() {
        return this.theTree;
    }

}
